/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.consumer.filter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.oauth.common.OAuthProviderParameter;
import org.springframework.security.oauth.consumer.AccessTokenRequiredException;
import org.springframework.security.oauth.consumer.OAuthConsumerSupport;
import org.springframework.security.oauth.consumer.OAuthConsumerToken;
import org.springframework.security.oauth.consumer.OAuthRequestFailedException;
import org.springframework.security.oauth.consumer.OAuthSecurityContextHolder;
import org.springframework.security.oauth.consumer.OAuthSecurityContextImpl;
import org.springframework.security.oauth.consumer.ProtectedResourceDetails;
import org.springframework.security.oauth.consumer.rememberme.HttpSessionOAuthRememberMeServices;
import org.springframework.security.oauth.consumer.rememberme.OAuthRememberMeServices;
import org.springframework.security.oauth.consumer.token.HttpSessionBasedTokenServices;
import org.springframework.security.oauth.consumer.token.OAuthConsumerTokenServices;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.PortResolver;
import org.springframework.security.web.PortResolverImpl;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.security.web.util.ThrowableAnalyzer;
import org.springframework.security.web.util.ThrowableCauseExtractor;
import org.springframework.util.Assert;

public class OAuthConsumerContextFilter
implements Filter,
InitializingBean,
MessageSourceAware {
    public static final String ACCESS_TOKENS_DEFAULT_ATTRIBUTE = "OAUTH_ACCESS_TOKENS";
    public static final String OAUTH_FAILURE_KEY = "OAUTH_FAILURE_KEY";
    private static final Log LOG = LogFactory.getLog(OAuthConsumerContextFilter.class);
    private AccessDeniedHandler OAuthFailureHandler;
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private OAuthRememberMeServices rememberMeServices = new HttpSessionOAuthRememberMeServices();
    private OAuthConsumerSupport consumerSupport;
    private String accessTokensRequestAttribute = "OAUTH_ACCESS_TOKENS";
    private PortResolver portResolver = new PortResolverImpl();
    private ThrowableAnalyzer throwableAnalyzer = new DefaultThrowableAnalyzer();
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private OAuthConsumerTokenServices tokenServices = new HttpSessionBasedTokenServices();

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.rememberMeServices, (String)"Remember-me services must be provided.");
        Assert.notNull((Object)this.consumerSupport, (String)"Consumer support must be provided.");
        Assert.notNull((Object)this.tokenServices, (String)"OAuth token services are required.");
        Assert.notNull((Object)this.redirectStrategy, (String)"A redirect strategy must be supplied.");
    }

    public void init(FilterConfig ignored) throws ServletException {
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        block31: {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            OAuthSecurityContextImpl context = new OAuthSecurityContextImpl();
            context.setDetails(request);
            Map<String, OAuthConsumerToken> rememberedTokens = this.getRememberMeServices().loadRememberedTokens(request, response);
            TreeMap<String, OAuthConsumerToken> accessTokens = new TreeMap<String, OAuthConsumerToken>();
            TreeMap<String, OAuthConsumerToken> requestTokens = new TreeMap<String, OAuthConsumerToken>();
            if (rememberedTokens != null) {
                for (Map.Entry<String, OAuthConsumerToken> tokenEntry : rememberedTokens.entrySet()) {
                    OAuthConsumerToken token = tokenEntry.getValue();
                    if (token == null) continue;
                    if (token.isAccessToken()) {
                        accessTokens.put(tokenEntry.getKey(), token);
                        continue;
                    }
                    requestTokens.put(tokenEntry.getKey(), token);
                }
            }
            context.setAccessTokens(accessTokens);
            OAuthSecurityContextHolder.setContext(context);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Storing access tokens in request attribute '" + this.getAccessTokensRequestAttribute() + "'."));
            }
            try {
                try {
                    request.setAttribute(this.getAccessTokensRequestAttribute(), new ArrayList(accessTokens.values()));
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
                catch (Exception e) {
                    String verifier;
                    OAuthConsumerToken token;
                    ProtectedResourceDetails resourceThatNeedsAuthorization = this.checkForResourceThatNeedsAuthorization(e);
                    String neededResourceId = resourceThatNeedsAuthorization.getId();
                    while (!accessTokens.containsKey(neededResourceId)) {
                        token = (OAuthConsumerToken)requestTokens.remove(neededResourceId);
                        if (token == null) {
                            token = this.getTokenServices().getToken(neededResourceId);
                        }
                        verifier = request.getParameter(OAuthProviderParameter.oauth_verifier.toString());
                        if (token != null && (token.isAccessToken() || resourceThatNeedsAuthorization.isUse10a() && verifier != null)) break block32;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Obtaining request token for resource: " + neededResourceId));
                        }
                        String callbackURL = response.encodeRedirectURL(this.getCallbackURL(request));
                        token = this.getConsumerSupport().getUnauthorizedRequestToken(neededResourceId, callbackURL);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Request token obtained for resource " + neededResourceId + ": " + token));
                        }
                        requestTokens.put(neededResourceId, token);
                        this.getTokenServices().storeToken(neededResourceId, token);
                        String redirect = this.getUserAuthorizationRedirectURL(resourceThatNeedsAuthorization, token, callbackURL);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Redirecting request to " + redirect + " for user authorization of the request token for resource " + neededResourceId + "."));
                        }
                        request.setAttribute("org.springframework.security.oauth.consumer.AccessTokenRequiredException", (Object)e);
                        this.redirectStrategy.sendRedirect(request, response, redirect);
                    }
                    break block31;
                    {
                        block32: {
                            OAuthSecurityContextHolder.setContext(null);
                            HashMap<String, OAuthConsumerToken> tokensToRemember = new HashMap<String, OAuthConsumerToken>();
                            tokensToRemember.putAll(requestTokens);
                            tokensToRemember.putAll(accessTokens);
                            this.getRememberMeServices().rememberTokens(tokensToRemember, request, response);
                            return;
                        }
                        try {
                            try {
                                if (!token.isAccessToken()) {
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("Obtaining access token for resource: " + neededResourceId));
                                    }
                                    try {
                                        token = this.getConsumerSupport().getAccessToken(token, verifier);
                                    }
                                    finally {
                                        this.getTokenServices().removeToken(neededResourceId);
                                    }
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)("Access token " + token + " obtained for resource " + neededResourceId + ". Now storing and using."));
                                    }
                                    this.getTokenServices().storeToken(neededResourceId, token);
                                }
                                accessTokens.put(neededResourceId, token);
                                try {
                                    if (!response.isCommitted()) {
                                        request.setAttribute(this.getAccessTokensRequestAttribute(), new ArrayList(accessTokens.values()));
                                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                                        continue;
                                    }
                                    throw new IllegalStateException("Unable to reprocess filter chain with needed OAuth2 resources because the response is already committed.");
                                }
                                catch (Exception e1) {
                                    resourceThatNeedsAuthorization = this.checkForResourceThatNeedsAuthorization(e1);
                                    neededResourceId = resourceThatNeedsAuthorization.getId();
                                    continue;
                                }
                            }
                            catch (OAuthRequestFailedException eo) {
                                this.fail(request, response, eo);
                            }
                            catch (Exception ex) {
                                Throwable[] causeChain = this.getThrowableAnalyzer().determineCauseChain((Throwable)ex);
                                OAuthRequestFailedException rfe = (OAuthRequestFailedException)((Object)this.getThrowableAnalyzer().getFirstThrowableOfType(OAuthRequestFailedException.class, causeChain));
                                if (rfe != null) {
                                    this.fail(request, response, rfe);
                                    break block31;
                                }
                                if (ex instanceof ServletException) {
                                    throw (ServletException)((Object)ex);
                                }
                                if (ex instanceof RuntimeException) {
                                    throw (RuntimeException)ex;
                                }
                                throw new RuntimeException(ex);
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            break;
                        }
                    }
                }
            }
            finally {
                OAuthSecurityContextHolder.setContext(null);
                HashMap<String, OAuthConsumerToken> tokensToRemember = new HashMap<String, OAuthConsumerToken>();
                tokensToRemember.putAll(requestTokens);
                tokensToRemember.putAll(accessTokens);
                this.getRememberMeServices().rememberTokens(tokensToRemember, request, response);
            }
        }
    }

    protected ProtectedResourceDetails checkForResourceThatNeedsAuthorization(Exception ex) throws ServletException, IOException {
        ProtectedResourceDetails resourceThatNeedsAuthorization;
        Throwable[] causeChain = this.getThrowableAnalyzer().determineCauseChain((Throwable)ex);
        AccessTokenRequiredException ase = (AccessTokenRequiredException)((Object)this.getThrowableAnalyzer().getFirstThrowableOfType(AccessTokenRequiredException.class, causeChain));
        if (ase != null) {
            resourceThatNeedsAuthorization = ase.getResource();
            if (resourceThatNeedsAuthorization == null) {
                throw new OAuthRequestFailedException(ase.getMessage());
            }
        } else {
            if (ex instanceof ServletException) {
                throw (ServletException)((Object)ex);
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        return resourceThatNeedsAuthorization;
    }

    protected String getCallbackURL(HttpServletRequest request) {
        return new DefaultSavedRequest(request, this.getPortResolver()).getRedirectUrl();
    }

    protected String getUserAuthorizationRedirectURL(ProtectedResourceDetails details, OAuthConsumerToken requestToken, String callbackURL) {
        try {
            String baseURL = details.getUserAuthorizationURL();
            StringBuilder builder = new StringBuilder(baseURL);
            char appendChar = baseURL.indexOf(63) < 0 ? (char)'?' : '&';
            builder.append(appendChar).append("oauth_token=");
            builder.append(URLEncoder.encode(requestToken.getValue(), "UTF-8"));
            if (!details.isUse10a()) {
                builder.append('&').append("oauth_callback=");
                builder.append(URLEncoder.encode(callbackURL, "UTF-8"));
            }
            return builder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void fail(HttpServletRequest request, HttpServletResponse response, OAuthRequestFailedException failure) throws IOException, ServletException {
        try {
            request.getSession().setAttribute(OAUTH_FAILURE_KEY, (Object)failure);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)failure);
        }
        if (this.getOAuthFailureHandler() == null) {
            throw failure;
        }
        this.getOAuthFailureHandler().handle(request, response, (AccessDeniedException)failure);
    }

    public AccessDeniedHandler getOAuthFailureHandler() {
        return this.OAuthFailureHandler;
    }

    public void setOAuthFailureHandler(AccessDeniedHandler OAuthFailureHandler) {
        this.OAuthFailureHandler = OAuthFailureHandler;
    }

    public OAuthConsumerTokenServices getTokenServices() {
        return this.tokenServices;
    }

    public void setTokenServices(OAuthConsumerTokenServices tokenServices) {
        this.tokenServices = tokenServices;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public OAuthConsumerSupport getConsumerSupport() {
        return this.consumerSupport;
    }

    @Autowired
    public void setConsumerSupport(OAuthConsumerSupport consumerSupport) {
        this.consumerSupport = consumerSupport;
    }

    public String getAccessTokensRequestAttribute() {
        return this.accessTokensRequestAttribute;
    }

    public void setAccessTokensRequestAttribute(String accessTokensRequestAttribute) {
        this.accessTokensRequestAttribute = accessTokensRequestAttribute;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    @Autowired(required=false)
    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    public OAuthRememberMeServices getRememberMeServices() {
        return this.rememberMeServices;
    }

    public void setRememberMeServices(OAuthRememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public ThrowableAnalyzer getThrowableAnalyzer() {
        return this.throwableAnalyzer;
    }

    public void setThrowableAnalyzer(ThrowableAnalyzer throwableAnalyzer) {
        this.throwableAnalyzer = throwableAnalyzer;
    }

    public RedirectStrategy getRedirectStrategy() {
        return this.redirectStrategy;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    private static final class DefaultThrowableAnalyzer
    extends ThrowableAnalyzer {
        private DefaultThrowableAnalyzer() {
        }

        protected void initExtractorMap() {
            super.initExtractorMap();
            this.registerExtractor(ServletException.class, new ThrowableCauseExtractor(){

                public Throwable extractCause(Throwable throwable) {
                    ThrowableAnalyzer.verifyThrowableHierarchy((Throwable)throwable, ServletException.class);
                    return ((ServletException)throwable).getRootCause();
                }
            });
        }
    }
}

