/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth.common.signature;

import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth.common.OAuthCodec;
import org.springframework.security.oauth.common.signature.HMAC_SHA1SignatureMethod;
import org.springframework.security.oauth.common.signature.OAuthSignatureMethod;
import org.springframework.security.oauth.common.signature.OAuthSignatureMethodFactory;
import org.springframework.security.oauth.common.signature.PlainTextSignatureMethod;
import org.springframework.security.oauth.common.signature.RSAKeySecret;
import org.springframework.security.oauth.common.signature.RSA_SHA1SignatureMethod;
import org.springframework.security.oauth.common.signature.SaltedConsumerSecret;
import org.springframework.security.oauth.common.signature.SharedConsumerSecret;
import org.springframework.security.oauth.common.signature.SignatureSecret;
import org.springframework.security.oauth.common.signature.UnsupportedSignatureMethodException;

public class CoreOAuthSignatureMethodFactory
implements OAuthSignatureMethodFactory {
    private boolean supportPlainText = false;
    private boolean supportHMAC_SHA1 = true;
    private boolean supportRSA_SHA1 = true;
    private PasswordEncoder plainTextPasswordEncoder;

    public OAuthSignatureMethod getSignatureMethod(String methodName, SignatureSecret signatureSecret, String tokenSecret) throws UnsupportedSignatureMethodException {
        if (this.supportPlainText && "PLAINTEXT".equals(methodName)) {
            if (!(signatureSecret instanceof SharedConsumerSecret)) {
                throw new IllegalArgumentException("Invalid secret for signature method " + methodName + ". Expected a " + SharedConsumerSecret.class.getName() + ", got " + (signatureSecret == null ? "null" : signatureSecret.getClass().getName()) + ".");
            }
            String consumerSecret = ((SharedConsumerSecret)signatureSecret).getConsumerSecret();
            if (consumerSecret == null) {
                consumerSecret = "";
            }
            if (tokenSecret == null) {
                tokenSecret = "";
            }
            consumerSecret = OAuthCodec.oauthEncode(consumerSecret);
            tokenSecret = OAuthCodec.oauthEncode(tokenSecret);
            Object salt = null;
            if (signatureSecret instanceof SaltedConsumerSecret) {
                salt = ((SaltedConsumerSecret)((Object)signatureSecret)).getSalt();
            }
            return new PlainTextSignatureMethod(OAuthCodec.oauthEncode(consumerSecret + '&' + tokenSecret), this.plainTextPasswordEncoder, salt);
        }
        if (this.supportHMAC_SHA1 && "HMAC-SHA1".equals(methodName)) {
            byte[] keyBytes;
            if (!(signatureSecret instanceof SharedConsumerSecret)) {
                throw new IllegalArgumentException("Invalid secret for signature method " + methodName + ". Expected a " + SharedConsumerSecret.class.getName() + ", got " + (signatureSecret == null ? "null" : signatureSecret.getClass().getName()) + ".");
            }
            String consumerSecret = ((SharedConsumerSecret)signatureSecret).getConsumerSecret();
            if (consumerSecret == null) {
                consumerSecret = "";
            }
            if (tokenSecret == null) {
                tokenSecret = "";
            }
            consumerSecret = OAuthCodec.oauthEncode(consumerSecret);
            tokenSecret = OAuthCodec.oauthEncode(tokenSecret);
            try {
                keyBytes = (consumerSecret + '&' + tokenSecret).getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
            SecretKeySpec spec = new SecretKeySpec(keyBytes, "HmacSHA1");
            return new HMAC_SHA1SignatureMethod(spec);
        }
        if (this.supportRSA_SHA1 && "RSA-SHA1".equals(methodName)) {
            X509Certificate certificate;
            if (signatureSecret instanceof RSAKeySecret) {
                PublicKey publicKey = ((RSAKeySecret)signatureSecret).getPublicKey();
                PrivateKey privateKey = ((RSAKeySecret)signatureSecret).getPrivateKey();
                return new RSA_SHA1SignatureMethod(privateKey, publicKey);
            }
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication.getCredentials() instanceof X509Certificate && (certificate = (X509Certificate)authentication.getCredentials()) != null) {
                return new RSA_SHA1SignatureMethod(certificate.getPublicKey());
            }
        }
        throw new UnsupportedSignatureMethodException("Unsupported signature method: " + methodName);
    }

    public boolean isSupportPlainText() {
        return this.supportPlainText;
    }

    public void setSupportPlainText(boolean supportPlainText) {
        this.supportPlainText = supportPlainText;
    }

    public boolean isSupportHMAC_SHA1() {
        return this.supportHMAC_SHA1;
    }

    public void setSupportHMAC_SHA1(boolean supportHMAC_SHA1) {
        this.supportHMAC_SHA1 = supportHMAC_SHA1;
    }

    public boolean isSupportRSA_SHA1() {
        return this.supportRSA_SHA1;
    }

    public void setSupportRSA_SHA1(boolean supportRSA_SHA1) {
        this.supportRSA_SHA1 = supportRSA_SHA1;
    }

    public PasswordEncoder getPlainTextPasswordEncoder() {
        return this.plainTextPasswordEncoder;
    }

    public void setPlainTextPasswordEncoder(PasswordEncoder plainTextPasswordEncoder) {
        this.plainTextPasswordEncoder = plainTextPasswordEncoder;
    }
}

