/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.policy;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.classify.BinaryExceptionClassifier;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.context.RetryContextSupport;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SimpleRetryPolicy
implements RetryPolicy {
    public static final int DEFAULT_MAX_ATTEMPTS = 3;
    private int maxAttempts;
    private Supplier<Integer> maxAttemptsSupplier;
    private BinaryExceptionClassifier retryableClassifier;
    private BinaryExceptionClassifier recoverableClassifier = new BinaryExceptionClassifier(Collections.emptyMap(), true, true);

    public SimpleRetryPolicy() {
        this(3, BinaryExceptionClassifier.defaultClassifier());
    }

    public SimpleRetryPolicy(int maxAttempts) {
        this(maxAttempts, BinaryExceptionClassifier.defaultClassifier());
    }

    public SimpleRetryPolicy(int maxAttempts, Map<Class<? extends Throwable>, Boolean> retryableExceptions) {
        this(maxAttempts, retryableExceptions, false);
    }

    public SimpleRetryPolicy(int maxAttempts, Map<Class<? extends Throwable>, Boolean> retryableExceptions, boolean traverseCauses) {
        this(maxAttempts, retryableExceptions, traverseCauses, false);
    }

    public SimpleRetryPolicy(int maxAttempts, Map<Class<? extends Throwable>, Boolean> retryableExceptions, boolean traverseCauses, boolean defaultValue) {
        this.maxAttempts = maxAttempts;
        this.retryableClassifier = new BinaryExceptionClassifier(retryableExceptions, defaultValue);
        this.retryableClassifier.setTraverseCauses(traverseCauses);
    }

    public SimpleRetryPolicy(int maxAttempts, BinaryExceptionClassifier classifier) {
        this.maxAttempts = maxAttempts;
        this.retryableClassifier = classifier;
    }

    public void setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public void setNotRecoverable(Class<? extends Throwable> ... noRecovery) {
        HashMap<Class<? extends Throwable>, Boolean> map = new HashMap<Class<? extends Throwable>, Boolean>();
        for (Class<? extends Throwable> clazz : noRecovery) {
            map.put(clazz, false);
        }
        this.recoverableClassifier = new BinaryExceptionClassifier(map, true, true);
    }

    public void maxAttemptsSupplier(Supplier<Integer> maxAttemptsSupplier) {
        Assert.notNull(maxAttemptsSupplier, (String)"'maxAttemptsSupplier' cannot be null");
        this.maxAttemptsSupplier = maxAttemptsSupplier;
    }

    public int getMaxAttempts() {
        if (this.maxAttemptsSupplier != null) {
            return this.maxAttemptsSupplier.get();
        }
        return this.maxAttempts;
    }

    @Override
    public boolean canRetry(RetryContext context) {
        boolean can;
        Throwable t = context.getLastThrowable();
        boolean bl = can = (t == null || this.retryForException(t)) && context.getRetryCount() < this.getMaxAttempts();
        if (!can && t != null && !this.recoverableClassifier.classify(t).booleanValue()) {
            context.setAttribute("context.no-recovery", true);
        } else {
            context.removeAttribute("context.no-recovery");
        }
        return can;
    }

    @Override
    public void close(RetryContext status) {
    }

    @Override
    public void registerThrowable(RetryContext context, Throwable throwable) {
        SimpleRetryContext simpleContext = (SimpleRetryContext)context;
        simpleContext.registerThrowable(throwable);
    }

    @Override
    public RetryContext open(RetryContext parent) {
        return new SimpleRetryContext(parent);
    }

    private boolean retryForException(Throwable ex) {
        return this.retryableClassifier.classify(ex);
    }

    public String toString() {
        return ClassUtils.getShortName(this.getClass()) + "[maxAttempts=" + this.getMaxAttempts() + "]";
    }

    private static class SimpleRetryContext
    extends RetryContextSupport {
        public SimpleRetryContext(RetryContext parent) {
            super(parent);
        }
    }
}

