/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.core;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.Serializer;
import org.springframework.kafka.core.ProducerPostProcessor;
import org.springframework.lang.Nullable;

public interface ProducerFactory<K, V> {
    public static final Duration DEFAULT_PHYSICAL_CLOSE_TIMEOUT = Duration.ofSeconds(30L);

    public Producer<K, V> createProducer();

    default public Producer<K, V> createProducer(@Nullable String txIdPrefix) {
        throw new UnsupportedOperationException("This factory does not support this method");
    }

    default public Producer<K, V> createNonTransactionalProducer() {
        throw new UnsupportedOperationException("This factory does not support this method");
    }

    default public boolean transactionCapable() {
        return false;
    }

    default public void closeThreadBoundProducer() {
    }

    default public void reset() {
    }

    default public Map<String, Object> getConfigurationProperties() {
        return Collections.emptyMap();
    }

    default public Supplier<Serializer<V>> getValueSerializerSupplier() {
        return () -> null;
    }

    default public Supplier<Serializer<K>> getKeySerializerSupplier() {
        return () -> null;
    }

    default public boolean isProducerPerThread() {
        return false;
    }

    @Nullable
    default public String getTransactionIdPrefix() {
        return null;
    }

    default public Duration getPhysicalCloseTimeout() {
        return DEFAULT_PHYSICAL_CLOSE_TIMEOUT;
    }

    default public void addListener(Listener<K, V> listener) {
    }

    default public void addListener(int index, Listener<K, V> listener) {
    }

    default public boolean removeListener(Listener<K, V> listener) {
        return false;
    }

    default public List<Listener<K, V>> getListeners() {
        return Collections.emptyList();
    }

    default public void addPostProcessor(ProducerPostProcessor<K, V> postProcessor) {
    }

    default public boolean removePostProcessor(ProducerPostProcessor<K, V> postProcessor) {
        return false;
    }

    default public List<ProducerPostProcessor<K, V>> getPostProcessors() {
        return Collections.emptyList();
    }

    default public void updateConfigs(Map<String, Object> updates) {
    }

    default public void removeConfig(String configKey) {
    }

    @Nullable
    default public Serializer<K> getKeySerializer() {
        return null;
    }

    @Nullable
    default public Serializer<V> getValueSerializer() {
        return null;
    }

    default public ProducerFactory<K, V> copyWithConfigurationOverride(Map<String, Object> overrideProperties) {
        throw new UnsupportedOperationException("This factory implementation doesn't support creating reconfigured copies.");
    }

    public static interface Listener<K, V> {
        default public void producerAdded(String id, Producer<K, V> producer) {
        }

        default public void producerRemoved(String id, Producer<K, V> producer) {
        }
    }
}

