/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.config;

import java.util.Collection;
import org.springframework.kafka.config.AbstractKafkaListenerContainerFactory;
import org.springframework.kafka.config.KafkaListenerEndpoint;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.config.ContainerProperties;
import org.springframework.kafka.support.TopicPartitionInitialOffset;

public class ConcurrentKafkaListenerContainerFactory<K, V>
extends AbstractKafkaListenerContainerFactory<ConcurrentMessageListenerContainer<K, V>, K, V> {
    private Integer concurrency;

    public void setConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
    }

    @Override
    protected ConcurrentMessageListenerContainer<K, V> createContainerInstance(KafkaListenerEndpoint endpoint) {
        Collection<TopicPartitionInitialOffset> topicPartitions = endpoint.getTopicPartitions();
        if (!topicPartitions.isEmpty()) {
            ContainerProperties properties = new ContainerProperties(topicPartitions.toArray(new TopicPartitionInitialOffset[topicPartitions.size()]));
            return new ConcurrentMessageListenerContainer(this.getConsumerFactory(), properties);
        }
        Collection<String> topics = endpoint.getTopics();
        if (!topics.isEmpty()) {
            ContainerProperties properties = new ContainerProperties(topics.toArray(new String[topics.size()]));
            return new ConcurrentMessageListenerContainer(this.getConsumerFactory(), properties);
        }
        ContainerProperties properties = new ContainerProperties(endpoint.getTopicPattern());
        return new ConcurrentMessageListenerContainer(this.getConsumerFactory(), properties);
    }

    @Override
    protected void initializeContainer(ConcurrentMessageListenerContainer<K, V> instance) {
        super.initializeContainer(instance);
        if (this.concurrency != null) {
            instance.setConcurrency(this.concurrency);
        }
    }
}

