/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka.support;

import java.util.Objects;
import org.apache.kafka.common.TopicPartition;

public class TopicPartitionInitialOffset {
    private final TopicPartition topicPartition;
    private final Long initialOffset;

    public TopicPartitionInitialOffset(String topic, int partition) {
        this(topic, partition, null);
    }

    public TopicPartitionInitialOffset(String topic, int partition, Long initialOffset) {
        this.topicPartition = new TopicPartition(topic, partition);
        this.initialOffset = initialOffset;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int partition() {
        return this.topicPartition.partition();
    }

    public String topic() {
        return this.topicPartition.topic();
    }

    public Long initialOffset() {
        return this.initialOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TopicPartitionInitialOffset that = (TopicPartitionInitialOffset)o;
        return Objects.equals(this.topicPartition, that.topicPartition);
    }

    public int hashCode() {
        return this.topicPartition.hashCode();
    }

    public String toString() {
        return "TopicPartitionInitialOffset{topicPartition=" + this.topicPartition + ", initialOffset=" + this.initialOffset + '}';
    }
}

