/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.valuesource;

import java.util.LinkedList;
import java.util.List;
import org.springframework.config.java.valuesource.ValueResolutionException;
import org.springframework.config.java.valuesource.ValueSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeValueSource
implements ValueSource {
    private List<ValueSource> propertySources = new LinkedList<ValueSource>();

    public void add(ValueSource ps) {
        this.propertySources.add(ps);
    }

    @Override
    public <T> T resolve(String name, Class<?> requiredType) {
        for (ValueSource ps : this.propertySources) {
            try {
                return ps.resolve(name, requiredType);
            }
            catch (ValueResolutionException ex) {
            }
        }
        throw new ValueResolutionException(name, "Cannot resolve property '" + name + "'");
    }
}

