/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import java.lang.reflect.Method;
import org.springframework.aop.framework.autoproxy.AutoProxyUtils;
import org.springframework.aop.scope.ScopedProxyFactoryBean;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.annotation.aop.ScopedProxy;
import org.springframework.config.java.core.ScopedProxyMethodProcessor;
import org.springframework.config.java.process.ConfigurationListener;
import org.springframework.config.java.process.ConfigurationListenerSupport;
import org.springframework.config.java.process.ConfigurationProcessor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScopedProxyConfigurationListener
extends ConfigurationListenerSupport {
    ScopedProxyConfigurationListener() {
    }

    @Override
    public void beanCreationMethod(ConfigurationListener.BeanDefinitionRegistration beanDefinitionRegistration, ConfigurationProcessor cp, String configurerBeanName, Class<?> configurerClass, Method m, Bean beanAnnotation) {
        ScopedProxy proxyAnnotation = m.getAnnotation(ScopedProxy.class);
        if (proxyAnnotation != null) {
            String scope = beanAnnotation.scope();
            if ("prototype".equals(scope) || "singleton".equals(scope)) {
                throw new BeanDefinitionStoreException(String.format("[%s] contains an invalid annotation declaration: @ScopedProxy cannot be used on a singleton/prototype bean", m));
            }
            ++cp.beanDefsGenerated;
            String originalBeanName = beanDefinitionRegistration.name;
            RootBeanDefinition targetDefinition = beanDefinitionRegistration.rbd;
            String targetBeanName = ScopedProxyMethodProcessor.resolveHiddenScopedProxyBeanName(originalBeanName);
            RootBeanDefinition scopedProxyDefinition = new RootBeanDefinition(ScopedProxyFactoryBean.class);
            scopedProxyDefinition.getPropertyValues().addPropertyValue("targetBeanName", (Object)targetBeanName);
            if (proxyAnnotation.proxyTargetClass()) {
                targetDefinition.setAttribute(AutoProxyUtils.PRESERVE_TARGET_CLASS_ATTRIBUTE, (Object)Boolean.TRUE);
            } else {
                scopedProxyDefinition.getPropertyValues().addPropertyValue("proxyTargetClass", (Object)Boolean.FALSE);
            }
            targetDefinition.setAutowireCandidate(false);
            cp.registerBeanDefinition(targetBeanName, (BeanDefinition)targetDefinition, beanDefinitionRegistration.hide);
            beanDefinitionRegistration.rbd = scopedProxyDefinition;
        }
    }

    @Override
    public void otherMethod(ConfigurationProcessor cp, String configurerBeanName, Class<?> configurerClass, Method m) {
        if (m.isAnnotationPresent(ScopedProxy.class)) {
            throw new BeanDefinitionStoreException(String.format("[%s] contains an invalid annotation declaration: @ScopedProxy should be used along side @Bean, not by itself", m));
        }
    }

    @Override
    public boolean understands(Class<?> configurerClass) {
        Assert.notNull(configurerClass);
        return configurerClass.isAnnotationPresent(Configuration.class);
    }
}

