/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.config.java.process.AspectJAdviceConfigurationListener;
import org.springframework.config.java.process.AutoBeanConfigurationListener;
import org.springframework.config.java.process.ConfigurationListener;
import org.springframework.config.java.process.HotSwapConfigurationListener;
import org.springframework.config.java.process.ImportConfigurationListener;
import org.springframework.config.java.process.ResourceBundlesConfigurationListener;
import org.springframework.config.java.process.ScopedProxyConfigurationListener;
import org.springframework.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConfigurationListenerRegistry {
    private final List<ConfigurationListener> configurationListeners = new ArrayList<ConfigurationListener>();

    public ConfigurationListenerRegistry() {
        this.registerConfigurationListener(new AutoBeanConfigurationListener());
        this.registerConfigurationListener(new ResourceBundlesConfigurationListener());
        this.registerConfigurationListener(new ScopedProxyConfigurationListener());
        this.registerConfigurationListener(new ImportConfigurationListener());
        if (ClassUtils.isPresent((String)"org.springframework.aop.TargetSource")) {
            this.registerConfigurationListener(new HotSwapConfigurationListener());
            this.registerConfigurationListener(new AspectJAdviceConfigurationListener());
        }
    }

    public final void registerConfigurationListener(ConfigurationListener listener) {
        this.configurationListeners.add(listener);
    }

    public final List<ConfigurationListener> getConfigurationListeners() {
        return Collections.unmodifiableList(this.configurationListeners);
    }
}

