/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.process;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.annotation.AutoBean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.process.ConfigurationListenerSupport;
import org.springframework.config.java.process.ConfigurationProcessor;
import org.springframework.core.annotation.AnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AutoBeanConfigurationListener
extends ConfigurationListenerSupport {
    AutoBeanConfigurationListener() {
    }

    @Override
    public boolean understands(Class<?> configurerClass) {
        return configurerClass.isAnnotationPresent(Configuration.class);
    }

    @Override
    public void otherMethod(ConfigurationProcessor configurationProcessor, String configurerBeanName, Class<?> configurerClass, Method m) {
        AutoBean autoBean = (AutoBean)AnnotationUtils.findAnnotation((Method)m, AutoBean.class);
        if (autoBean != null) {
            if (m.getReturnType().isInterface()) {
                throw new BeanDefinitionStoreException("Cannot use AutoBean of interface type " + m.getReturnType() + ": don't know what class to instantiate; processing @AutoBean method " + m);
            }
            RootBeanDefinition bd = new RootBeanDefinition(m.getReturnType());
            bd.setAutowireMode(autoBean.autowire().value());
            configurationProcessor.registerBeanDefinition(m.getName(), (BeanDefinition)bd, !Modifier.isPublic(m.getModifiers()));
            ++configurationProcessor.beanDefsGenerated;
        }
    }
}

