/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.naming;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.config.java.naming.BeanNamingStrategy;
import org.springframework.util.Assert;

public class ChainedStrategy
implements BeanNamingStrategy {
    private BeanNamingStrategy[] strategies;

    public ChainedStrategy(BeanNamingStrategy[] strategies) {
        Assert.notEmpty((Object[])strategies, (String)"at least one strategy required");
        this.strategies = strategies;
    }

    public String getBeanName(Method beanCreationMethod) {
        for (BeanNamingStrategy strategy : this.strategies) {
            String name;
            if (strategy == null || (name = strategy.getBeanName(beanCreationMethod)) == null) continue;
            return name;
        }
        throw new IllegalArgumentException("no strategy returned a name; consider using different naming strategies " + Arrays.toString(this.strategies));
    }
}

