/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.config.java.context;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.config.java.context.ClassPathScanningConfigurationProviderFactory;
import org.springframework.config.java.context.JavaConfigBeanFactoryPostProcessorRegistry;
import org.springframework.config.java.context.TypeSafeBeanFactory;
import org.springframework.config.java.context.TypeSafeBeanFactoryUtils;
import org.springframework.config.java.process.ConfigurationProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.support.AbstractRefreshableApplicationContext;
import org.springframework.core.io.ResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaConfigApplicationContext
extends AbstractRefreshableApplicationContext
implements TypeSafeBeanFactory {
    private Class<?>[] configClasses;
    private String[] basePackages;
    private boolean closedForConfiguration = false;
    private final ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningConfigurationProviderFactory().getProvider((ResourceLoader)this);

    public JavaConfigApplicationContext() {
        this((ApplicationContext)null);
    }

    public JavaConfigApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    public JavaConfigApplicationContext(String ... basePackages) {
        this((ApplicationContext)null, (Class<?>[])null, basePackages);
    }

    public JavaConfigApplicationContext(Class<?> ... classes) {
        this((ApplicationContext)null, classes, (String[])null);
    }

    public JavaConfigApplicationContext(ApplicationContext parent, Class<?> ... classes) {
        this(parent, classes, (String[])null);
    }

    public JavaConfigApplicationContext(ApplicationContext parent, String ... basePackages) {
        this(parent, (Class<?>[])null, basePackages);
    }

    public JavaConfigApplicationContext(Class<?>[] classes, String[] basePackages) {
        this(null, classes, basePackages);
    }

    public JavaConfigApplicationContext(ApplicationContext parent, Class<?>[] classes, String[] basePackages) {
        super(parent);
        this.setConfigClasses(classes);
        this.setBasePackages(basePackages);
        this.refresh();
    }

    protected void prepareRefresh() {
        super.prepareRefresh();
        this.processAnyOuterClasses();
        this.registerDefaultPostProcessors();
    }

    public void setConfigClasses(Class<?> ... classes) {
        if (this.closedForConfiguration) {
            throw new IllegalStateException("setConfigClasses() may only be called before refresh()");
        }
        this.configClasses = JavaConfigApplicationContext.reverse(classes);
    }

    public void addConfigClass(Class<?> cls) {
        if (this.closedForConfiguration) {
            throw new IllegalStateException("setConfigClasses() may only be called before refresh()");
        }
        ArrayList classes = new ArrayList();
        if (this.configClasses != null) {
            for (Class<?> existingClass : this.configClasses) {
                classes.add(existingClass);
            }
        }
        classes.add(cls);
        this.configClasses = classes.toArray(new Class[classes.size()]);
    }

    public void setBasePackages(String ... basePackages) {
        if (this.closedForConfiguration) {
            throw new IllegalStateException("setBasePackages() may only be called before refresh()");
        }
        this.basePackages = basePackages;
    }

    public void setParent(ApplicationContext context) {
        if (this.closedForConfiguration) {
            throw new IllegalStateException("setParent() may only be called before refresh()");
        }
        super.setParent(context);
    }

    protected String[] getBasePackages() {
        return this.basePackages;
    }

    protected Class<?>[] getConfigClasses() {
        return this.configClasses;
    }

    private void processAnyOuterClasses() {
        Class<?> outerConfig = null;
        if (this.configClasses != null && this.configClasses.length > 0) {
            for (Class<?> configClass : this.configClasses) {
                Class<?> candidate = configClass.getDeclaringClass();
                if (candidate == null || !ConfigurationProcessor.isConfigurationClass(candidate)) continue;
                if (outerConfig != null) {
                    throw new RuntimeException("cannot specify more than one inner configuration class");
                }
                outerConfig = candidate;
            }
        }
        if (outerConfig != null) {
            this.setParent((ApplicationContext)new JavaConfigApplicationContext(outerConfig));
        }
    }

    protected void finishRefresh() {
        this.closedForConfiguration = true;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException, BeansException {
        if (this.configClasses != null && this.configClasses.length > 0) {
            for (Class<?> cz : this.configClasses) {
                if (!ConfigurationProcessor.isConfigurationClass(cz)) continue;
                beanFactory.registerBeanDefinition(cz.getName(), (BeanDefinition)new RootBeanDefinition((Class)cz, true));
            }
        }
        if (this.basePackages != null && this.basePackages.length > 0) {
            for (String location : this.basePackages) {
                Set beandefs = this.scanner.findCandidateComponents(location);
                for (BeanDefinition bd : beandefs) {
                    beanFactory.registerBeanDefinition(bd.getBeanClassName(), bd);
                }
            }
        }
    }

    protected void registerDefaultPostProcessors() {
        new JavaConfigBeanFactoryPostProcessorRegistry().addAllPostProcessors((ConfigurableApplicationContext)this);
    }

    @Override
    public <T> T getBean(Class<T> type) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.getBeanFactory(), type);
    }

    @Override
    public <T> T getBean(Class<T> type, String beanName) {
        return TypeSafeBeanFactoryUtils.getBean((ListableBeanFactory)this.getBeanFactory(), type, beanName);
    }

    private static Class<?>[] reverse(Class<?>[] array) {
        if (array == null) {
            return array;
        }
        int size = array.length;
        Class[] reversed = new Class[size];
        for (int i = 0; i < size; ++i) {
            reversed[size - i - 1] = array[i];
        }
        return reversed;
    }
}

