/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.core.ResolvableType;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.lang.Nullable;

abstract class TypedSubtreeVisitor<T extends Visitable>
extends DelegatingVisitor {
    private final ResolvableType type = ResolvableType.forClass(this.getClass()).as(TypedSubtreeVisitor.class).getGeneric(new int[]{0});
    @Nullable
    private Visitable currentSegment;

    TypedSubtreeVisitor() {
    }

    DelegatingVisitor.Delegation enterMatched(T segment) {
        return DelegatingVisitor.Delegation.retain();
    }

    DelegatingVisitor.Delegation enterNested(Visitable segment) {
        return DelegatingVisitor.Delegation.retain();
    }

    DelegatingVisitor.Delegation leaveMatched(T segment) {
        return DelegatingVisitor.Delegation.leave();
    }

    DelegatingVisitor.Delegation leaveNested(Visitable segment) {
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public final DelegatingVisitor.Delegation doEnter(Visitable segment) {
        if (this.currentSegment == null) {
            if (this.type.isInstance((Object)segment)) {
                this.currentSegment = segment;
                return this.enterMatched(segment);
            }
        } else {
            return this.enterNested(segment);
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public final DelegatingVisitor.Delegation doLeave(Visitable segment) {
        if (this.currentSegment == null) {
            return DelegatingVisitor.Delegation.leave();
        }
        if (segment == this.currentSegment) {
            this.currentSegment = null;
            return this.leaveMatched(segment);
        }
        return this.leaveNested(segment);
    }
}

