/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.GeoOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;

class DefaultGeoOperations<K, M>
extends AbstractOperations<K, M>
implements GeoOperations<K, M> {
    DefaultGeoOperations(RedisTemplate<K, M> template) {
        super(template);
    }

    @Override
    public Long add(K key, Point point, M member) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember = this.rawValue(member);
        return this.execute(connection -> connection.geoAdd(rawKey, point, rawMember));
    }

    @Override
    public Long add(K key, RedisGeoCommands.GeoLocation<M> location) {
        return this.add(key, location.getPoint(), location.getName());
    }

    @Override
    public Long add(K key, Map<M, Point> memberCoordinateMap) {
        byte[] rawKey = this.rawKey(key);
        HashMap<byte[], Point> rawMemberCoordinateMap = new HashMap<byte[], Point>();
        for (M member : memberCoordinateMap.keySet()) {
            byte[] rawMember = this.rawValue(member);
            rawMemberCoordinateMap.put(rawMember, memberCoordinateMap.get(member));
        }
        return this.execute(connection -> connection.geoAdd(rawKey, rawMemberCoordinateMap));
    }

    @Override
    public Long add(K key, Iterable<RedisGeoCommands.GeoLocation<M>> locations) {
        LinkedHashMap memberCoordinateMap = new LinkedHashMap();
        for (RedisGeoCommands.GeoLocation<M> location : locations) {
            memberCoordinateMap.put(location.getName(), location.getPoint());
        }
        return this.add(key, memberCoordinateMap);
    }

    @Override
    public Distance distance(K key, M member1, M member2) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember1 = this.rawValue(member1);
        byte[] rawMember2 = this.rawValue(member2);
        return this.execute(connection -> connection.geoDist(rawKey, rawMember1, rawMember2));
    }

    @Override
    public Distance distance(K key, M member1, M member2, Metric metric) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember1 = this.rawValue(member1);
        byte[] rawMember2 = this.rawValue(member2);
        return this.execute(connection -> connection.geoDist(rawKey, rawMember1, rawMember2, metric));
    }

    @Override
    public List<String> hash(K key, M ... members) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawMembers = this.rawValues(members);
        return this.execute(connection -> connection.geoHash(rawKey, rawMembers));
    }

    @Override
    public List<Point> position(K key, M ... members) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawMembers = this.rawValues(members);
        return this.execute(connection -> connection.geoPos(rawKey, rawMembers));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K key, Circle within) {
        byte[] rawKey = this.rawKey(key);
        GeoResults raw = this.execute(connection -> connection.geoRadius(rawKey, within));
        return this.deserializeGeoResults((GeoResults<RedisGeoCommands.GeoLocation<byte[]>>)raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        byte[] rawKey = this.rawKey(key);
        GeoResults raw = this.execute(connection -> connection.geoRadius(rawKey, within, args));
        return this.deserializeGeoResults((GeoResults<RedisGeoCommands.GeoLocation<byte[]>>)raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K key, M member, double radius) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember = this.rawValue(member);
        GeoResults raw = this.execute(connection -> connection.geoRadiusByMember(rawKey, rawMember, radius));
        return this.deserializeGeoResults((GeoResults<RedisGeoCommands.GeoLocation<byte[]>>)raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K key, M member, Distance distance) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember = this.rawValue(member);
        GeoResults raw = this.execute(connection -> connection.geoRadiusByMember(rawKey, rawMember, distance));
        return this.deserializeGeoResults((GeoResults<RedisGeoCommands.GeoLocation<byte[]>>)raw);
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K key, M member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs param) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawMember = this.rawValue(member);
        GeoResults raw = this.execute(connection -> connection.geoRadiusByMember(rawKey, rawMember, distance, param));
        return this.deserializeGeoResults((GeoResults<RedisGeoCommands.GeoLocation<byte[]>>)raw);
    }

    @Override
    public Long remove(K key, M ... members) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawMembers = this.rawValues(members);
        return this.execute(connection -> connection.zRem(rawKey, rawMembers));
    }

    @Override
    public GeoResults<RedisGeoCommands.GeoLocation<M>> search(K key, GeoReference<M> reference, GeoShape geoPredicate, RedisGeoCommands.GeoSearchCommandArgs args) {
        byte[] rawKey = this.rawKey(key);
        GeoReference<byte[]> rawMember = this.getGeoReference(reference);
        GeoResults raw = this.execute(connection -> connection.geoSearch(rawKey, rawMember, geoPredicate, args));
        return this.deserializeGeoResults((GeoResults<RedisGeoCommands.GeoLocation<byte[]>>)raw);
    }

    @Override
    public Long searchAndStore(K key, K destKey, GeoReference<M> reference, GeoShape geoPredicate, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawDestKey = this.rawKey(destKey);
        GeoReference<byte[]> rawMember = this.getGeoReference(reference);
        return this.execute(connection -> connection.geoSearchStore(rawDestKey, rawKey, rawMember, geoPredicate, args));
    }

    private GeoReference<byte[]> getGeoReference(GeoReference<M> reference) {
        return reference instanceof GeoReference.GeoMemberReference ? GeoReference.fromMember(this.rawValue(((GeoReference.GeoMemberReference)reference).getMember())) : reference;
    }
}

