/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.redis.cache.CacheStatistics;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.data.redis.cache.MutableCacheStatistics;

class DefaultCacheStatisticsCollector
implements CacheStatisticsCollector {
    private final Map<String, MutableCacheStatistics> stats = new ConcurrentHashMap<String, MutableCacheStatistics>();

    DefaultCacheStatisticsCollector() {
    }

    @Override
    public void incPuts(String cacheName) {
        this.statsFor(cacheName).incPuts();
    }

    @Override
    public void incGets(String cacheName) {
        this.statsFor(cacheName).incGets();
    }

    @Override
    public void incHits(String cacheName) {
        this.statsFor(cacheName).incHits();
    }

    @Override
    public void incMisses(String cacheName) {
        this.statsFor(cacheName).incMisses();
    }

    @Override
    public void incDeletesBy(String cacheName, int value) {
        this.statsFor(cacheName).incDeletes(value);
    }

    @Override
    public void incLockTime(String name, long durationNS) {
        this.statsFor(name).incLockWaitTime(durationNS);
    }

    @Override
    public void reset(String cacheName) {
        this.statsFor(cacheName).reset();
    }

    @Override
    public CacheStatistics getCacheStatistics(String cacheName) {
        return this.statsFor(cacheName).captureSnapshot();
    }

    private MutableCacheStatistics statsFor(String cacheName) {
        return this.stats.computeIfAbsent(cacheName, MutableCacheStatistics::new);
    }
}

