/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.ClusterTopologyProvider;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisExceptionConverter;
import org.springframework.data.redis.connection.jedis.JedisSentinelConnection;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisSentinelPool;
import redis.clients.jedis.util.Pool;

public class JedisConnectionFactory
implements RedisConnectionFactory,
InitializingBean,
DisposableBean,
SmartLifecycle {
    private static final Log log = LogFactory.getLog(JedisConnectionFactory.class);
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new PassThroughExceptionTranslationStrategy(JedisExceptionConverter.INSTANCE);
    private int phase = 0;
    private boolean autoStartup = true;
    private boolean earlyStartup = true;
    private boolean convertPipelineAndTxResults = true;
    private final AtomicReference<State> state = new AtomicReference<State>(State.CREATED);
    @Nullable
    private ClusterCommandExecutor clusterCommandExecutor;
    @Nullable
    private AsyncTaskExecutor executor;
    @Nullable
    private ClusterTopologyProvider topologyProvider;
    private JedisClientConfig clientConfig = DefaultJedisClientConfig.builder().build();
    private final JedisClientConfiguration clientConfiguration;
    @Nullable
    private JedisCluster cluster;
    @Nullable
    private Pool<Jedis> pool;
    @Nullable
    private RedisConfiguration configuration;
    private RedisStandaloneConfiguration standaloneConfig = new RedisStandaloneConfiguration("localhost", 6379);

    public JedisConnectionFactory() {
        this(new MutableJedisClientConfiguration());
    }

    private JedisConnectionFactory(JedisClientConfiguration clientConfiguration) {
        Assert.notNull((Object)clientConfiguration, (String)"JedisClientConfiguration must not be null");
        this.clientConfiguration = clientConfiguration;
    }

    public JedisConnectionFactory(JedisPoolConfig poolConfig) {
        this((RedisSentinelConfiguration)null, poolConfig);
    }

    public JedisConnectionFactory(RedisClusterConfiguration clusterConfiguration) {
        this(clusterConfiguration, (JedisClientConfiguration)new MutableJedisClientConfiguration());
    }

    public JedisConnectionFactory(RedisClusterConfiguration clusterConfiguration, JedisClientConfiguration clientConfiguration) {
        this(clientConfiguration);
        Assert.notNull((Object)clusterConfiguration, (String)"RedisClusterConfiguration must not be null");
        this.configuration = clusterConfiguration;
    }

    public JedisConnectionFactory(RedisClusterConfiguration clusterConfiguration, JedisPoolConfig poolConfig) {
        Assert.notNull((Object)clusterConfiguration, (String)"RedisClusterConfiguration must not be null");
        this.configuration = clusterConfiguration;
        this.clientConfiguration = MutableJedisClientConfiguration.create((GenericObjectPoolConfig)poolConfig);
    }

    public JedisConnectionFactory(RedisSentinelConfiguration sentinelConfiguration) {
        this(sentinelConfiguration, (JedisClientConfiguration)new MutableJedisClientConfiguration());
    }

    public JedisConnectionFactory(RedisSentinelConfiguration sentinelConfiguration, JedisClientConfiguration clientConfiguration) {
        this(clientConfiguration);
        Assert.notNull((Object)sentinelConfiguration, (String)"RedisSentinelConfiguration must not be null");
        this.configuration = sentinelConfiguration;
    }

    public JedisConnectionFactory(RedisSentinelConfiguration sentinelConfiguration, @Nullable JedisPoolConfig poolConfig) {
        this.configuration = sentinelConfiguration;
        this.clientConfiguration = MutableJedisClientConfiguration.create((GenericObjectPoolConfig)(poolConfig != null ? poolConfig : new JedisPoolConfig()));
    }

    public JedisConnectionFactory(RedisStandaloneConfiguration standaloneConfiguration) {
        this(standaloneConfiguration, (JedisClientConfiguration)new MutableJedisClientConfiguration());
    }

    public JedisConnectionFactory(RedisStandaloneConfiguration standaloneConfiguration, JedisClientConfiguration clientConfiguration) {
        this(clientConfiguration);
        Assert.notNull((Object)standaloneConfiguration, (String)"RedisStandaloneConfiguration must not be null");
        this.standaloneConfig = standaloneConfiguration;
    }

    ClusterCommandExecutor getRequiredClusterCommandExecutor() {
        if (this.clusterCommandExecutor == null) {
            throw new IllegalStateException("ClusterCommandExecutor not initialized");
        }
        return this.clusterCommandExecutor;
    }

    public void setExecutor(AsyncTaskExecutor executor) {
        Assert.notNull((Object)executor, (String)"AsyncTaskExecutor must not be null");
        this.executor = executor;
    }

    public String getHostName() {
        return this.standaloneConfig.getHostName();
    }

    @Deprecated
    public void setHostName(String hostName) {
        this.standaloneConfig.setHostName(hostName);
    }

    public boolean isUseSsl() {
        return this.clientConfiguration.isUseSsl();
    }

    @Deprecated
    public void setUseSsl(boolean useSsl) {
        this.getMutableConfiguration().setUseSsl(useSsl);
    }

    @Nullable
    public String getPassword() {
        return this.getRedisPassword().map(String::new).orElse(null);
    }

    @Nullable
    private String getRedisUsername() {
        return RedisConfiguration.getUsernameOrElse(this.configuration, this.standaloneConfig::getUsername);
    }

    private RedisPassword getRedisPassword() {
        return RedisConfiguration.getPasswordOrElse(this.configuration, this.standaloneConfig::getPassword);
    }

    @Deprecated
    public void setPassword(String password) {
        if (RedisConfiguration.isAuthenticationAware(this.configuration)) {
            ((RedisConfiguration.WithPassword)((Object)this.configuration)).setPassword(password);
            return;
        }
        this.standaloneConfig.setPassword(RedisPassword.of(password));
    }

    public int getPort() {
        return this.standaloneConfig.getPort();
    }

    @Deprecated
    public void setPort(int port) {
        this.standaloneConfig.setPort(port);
    }

    public int getTimeout() {
        return this.getReadTimeout();
    }

    @Deprecated
    public void setTimeout(int timeout) {
        this.getMutableConfiguration().setReadTimeout(Duration.ofMillis(timeout));
        this.getMutableConfiguration().setConnectTimeout(Duration.ofMillis(timeout));
    }

    public boolean getUsePool() {
        return this.isRedisSentinelAware() || this.getClientConfiguration().isUsePooling();
    }

    @Deprecated
    public void setUsePool(boolean usePool) {
        if (this.isRedisSentinelAware() && !usePool) {
            throw new IllegalStateException("Jedis requires pooling for Redis Sentinel use");
        }
        this.getMutableConfiguration().setUsePooling(usePool);
    }

    @Nullable
    public <T> GenericObjectPoolConfig<T> getPoolConfig() {
        return this.clientConfiguration.getPoolConfig().orElse(null);
    }

    @Deprecated
    public void setPoolConfig(JedisPoolConfig poolConfig) {
        this.getMutableConfiguration().setPoolConfig((GenericObjectPoolConfig)poolConfig);
    }

    public int getDatabase() {
        return RedisConfiguration.getDatabaseOrElse(this.configuration, this.standaloneConfig::getDatabase);
    }

    @Deprecated
    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        if (RedisConfiguration.isDatabaseIndexAware(this.configuration)) {
            ((RedisConfiguration.WithDatabaseIndex)((Object)this.configuration)).setDatabase(index);
            return;
        }
        this.standaloneConfig.setDatabase(index);
    }

    @Nullable
    public String getClientName() {
        return this.clientConfiguration.getClientName().orElse(null);
    }

    @Deprecated
    public void setClientName(String clientName) {
        this.getMutableConfiguration().setClientName(clientName);
    }

    public JedisClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    @Nullable
    public RedisStandaloneConfiguration getStandaloneConfiguration() {
        return this.standaloneConfig;
    }

    @Nullable
    public RedisSentinelConfiguration getSentinelConfiguration() {
        return RedisConfiguration.isSentinelConfiguration(this.configuration) ? (RedisSentinelConfiguration)this.configuration : null;
    }

    @Nullable
    public RedisClusterConfiguration getClusterConfiguration() {
        return RedisConfiguration.isClusterConfiguration(this.configuration) ? (RedisClusterConfiguration)this.configuration : null;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isEarlyStartup() {
        return this.earlyStartup;
    }

    public void setEarlyStartup(boolean earlyStartup) {
        this.earlyStartup = earlyStartup;
    }

    @Override
    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    public boolean isRedisSentinelAware() {
        return RedisConfiguration.isSentinelConfiguration(this.configuration);
    }

    public boolean isRedisClusterAware() {
        return RedisConfiguration.isClusterConfiguration(this.configuration);
    }

    public void afterPropertiesSet() {
        this.clientConfig = this.createClientConfig(this.getDatabase(), this.getRedisUsername(), this.getRedisPassword());
        if (this.isEarlyStartup()) {
            this.start();
        }
    }

    private JedisClientConfig createClientConfig(int database, @Nullable String username, RedisPassword password) {
        DefaultJedisClientConfig.Builder builder = DefaultJedisClientConfig.builder();
        this.clientConfiguration.getClientName().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)builder).clientName(arg_0));
        builder.connectionTimeoutMillis(this.getConnectTimeout());
        builder.socketTimeoutMillis(this.getReadTimeout());
        builder.database(database);
        if (!ObjectUtils.isEmpty((Object)username)) {
            builder.user(username);
        }
        password.toOptional().map(String::new).ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)builder).password(arg_0));
        if (this.isUseSsl()) {
            builder.ssl(true);
            this.clientConfiguration.getSslSocketFactory().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)builder).sslSocketFactory(arg_0));
            this.clientConfiguration.getHostnameVerifier().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)builder).hostnameVerifier(arg_0));
            this.clientConfiguration.getSslParameters().ifPresent(arg_0 -> ((DefaultJedisClientConfig.Builder)builder).sslParameters(arg_0));
        }
        return builder.build();
    }

    JedisClientConfig createSentinelClientConfig(RedisConfiguration.SentinelConfiguration sentinelConfiguration) {
        return this.createClientConfig(0, sentinelConfiguration.getSentinelUsername(), sentinelConfiguration.getSentinelPassword());
    }

    public void start() {
        State current = this.state.getAndUpdate(state -> this.isCreatedOrStopped((State)((Object)state)) ? State.STARTING : state);
        if (this.isCreatedOrStopped(current)) {
            if (this.getUsePool() && !this.isRedisClusterAware()) {
                this.pool = this.createPool();
            }
            if (this.isRedisClusterAware()) {
                this.cluster = this.createCluster(this.getClusterConfiguration(), this.getPoolConfig());
                this.topologyProvider = this.createTopologyProvider(this.cluster);
                this.clusterCommandExecutor = new ClusterCommandExecutor(this.topologyProvider, new JedisClusterConnection.JedisClusterNodeResourceProvider(this.cluster, this.topologyProvider), EXCEPTION_TRANSLATION, this.executor);
            }
            this.state.set(State.STARTED);
        }
    }

    private boolean isCreatedOrStopped(@Nullable State state) {
        return State.CREATED.equals((Object)state) || State.STOPPED.equals((Object)state);
    }

    public void stop() {
        if (this.state.compareAndSet(State.STARTED, State.STOPPING)) {
            ClusterCommandExecutor clusterCommandExecutor;
            if (this.getUsePool() && !this.isRedisClusterAware() && this.pool != null) {
                try {
                    this.pool.close();
                    this.pool = null;
                }
                catch (Exception ex) {
                    log.warn((Object)"Cannot properly close Jedis pool", (Throwable)ex);
                }
            }
            if ((clusterCommandExecutor = this.clusterCommandExecutor) != null) {
                try {
                    clusterCommandExecutor.destroy();
                    this.clusterCommandExecutor = null;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (this.cluster != null) {
                this.topologyProvider = null;
                try {
                    this.cluster.close();
                    this.cluster = null;
                }
                catch (Exception ex) {
                    log.warn((Object)"Cannot properly close Jedis cluster", (Throwable)ex);
                }
            }
            this.state.set(State.STOPPED);
        }
    }

    public boolean isRunning() {
        return State.STARTED.equals((Object)this.state.get());
    }

    private Pool<Jedis> createPool() {
        if (this.isRedisSentinelAware()) {
            return this.createRedisSentinelPool(this.getSentinelConfiguration());
        }
        return this.createRedisPool();
    }

    protected Pool<Jedis> createRedisSentinelPool(RedisSentinelConfiguration config) {
        JedisPoolConfig poolConfig = this.getPoolConfig() != null ? this.getPoolConfig() : new JedisPoolConfig();
        JedisClientConfig sentinelConfig = this.createSentinelClientConfig(config);
        return new JedisSentinelPool(config.getMaster().getName(), JedisConnectionFactory.convertToJedisSentinelSet(config.getSentinels()), (GenericObjectPoolConfig)poolConfig, this.clientConfig, sentinelConfig);
    }

    protected Pool<Jedis> createRedisPool() {
        return new JedisPool(this.getPoolConfig(), new HostAndPort(this.getHostName(), this.getPort()), this.clientConfig);
    }

    protected ClusterTopologyProvider createTopologyProvider(JedisCluster cluster) {
        return new JedisClusterConnection.JedisClusterTopologyProvider(cluster);
    }

    protected JedisCluster createCluster(RedisClusterConfiguration clusterConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        Assert.notNull((Object)clusterConfig, (String)"Cluster configuration must not be null");
        HashSet<HostAndPort> hostAndPort = new HashSet<HostAndPort>();
        for (RedisNode node : clusterConfig.getClusterNodes()) {
            hostAndPort.add(new HostAndPort(node.getHost(), node.getPort().intValue()));
        }
        int redirects = clusterConfig.getMaxRedirects() != null ? clusterConfig.getMaxRedirects() : 5;
        return new JedisCluster(hostAndPort, this.clientConfig, redirects, poolConfig);
    }

    public void destroy() {
        this.stop();
        this.state.set(State.DESTROYED);
    }

    @Override
    public RedisConnection getConnection() {
        this.assertInitialized();
        if (this.isRedisClusterAware()) {
            return this.getClusterConnection();
        }
        Jedis jedis = this.fetchJedisConnector();
        JedisClientConfig sentinelConfig = this.clientConfig;
        RedisSentinelConfiguration sentinelConfiguration = this.getSentinelConfiguration();
        if (sentinelConfiguration != null) {
            sentinelConfig = this.createSentinelClientConfig(sentinelConfiguration);
        }
        JedisConnection connection = this.getUsePool() ? new JedisConnection(jedis, this.pool, this.clientConfig, sentinelConfig) : new JedisConnection(jedis, null, this.clientConfig, sentinelConfig);
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return this.postProcessConnection(connection);
    }

    protected Jedis fetchJedisConnector() {
        try {
            if (this.getUsePool() && this.pool != null) {
                return (Jedis)this.pool.getResource();
            }
            Jedis jedis = this.createJedis();
            jedis.connect();
            return jedis;
        }
        catch (Exception ex) {
            throw new RedisConnectionFailureException("Cannot get Jedis connection", ex);
        }
    }

    private Jedis createJedis() {
        return new Jedis(new HostAndPort(this.getHostName(), this.getPort()), this.clientConfig);
    }

    protected JedisConnection postProcessConnection(JedisConnection connection) {
        return connection;
    }

    @Override
    public RedisClusterConnection getClusterConnection() {
        this.assertInitialized();
        if (!this.isRedisClusterAware()) {
            throw new InvalidDataAccessApiUsageException("Cluster is not configured");
        }
        JedisClusterConnection clusterConnection = new JedisClusterConnection(this.cluster, this.getRequiredClusterCommandExecutor(), this.topologyProvider);
        return this.postProcessConnection(clusterConnection);
    }

    protected JedisClusterConnection postProcessConnection(JedisClusterConnection connection) {
        return connection;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EXCEPTION_TRANSLATION.translate(ex);
    }

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        this.assertInitialized();
        if (!this.isRedisSentinelAware()) {
            throw new InvalidDataAccessResourceUsageException("No Sentinels configured");
        }
        return new JedisSentinelConnection(this.getActiveSentinel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Jedis getActiveSentinel() {
        Assert.isTrue((boolean)RedisConfiguration.isSentinelConfiguration(this.configuration), (String)"SentinelConfig must not be null");
        RedisConfiguration.SentinelConfiguration sentinelConfiguration = (RedisConfiguration.SentinelConfiguration)((Object)this.configuration);
        JedisClientConfig clientConfig = this.createSentinelClientConfig(sentinelConfiguration);
        for (RedisNode node : sentinelConfiguration.getSentinels()) {
            Jedis jedis = null;
            boolean success = false;
            try {
                jedis = new Jedis(new HostAndPort(node.getHost(), node.getPort().intValue()), clientConfig);
                if (!jedis.ping().equalsIgnoreCase("pong")) continue;
                success = true;
                Jedis jedis2 = jedis;
                return jedis2;
            }
            catch (Exception ex) {
                log.warn((Object)"Ping failed for sentinel host: %s".formatted(node.getHost()), (Throwable)ex);
            }
            finally {
                if (success || jedis == null) continue;
                jedis.close();
            }
        }
        throw new InvalidDataAccessResourceUsageException("No Sentinel found");
    }

    private static Set<HostAndPort> convertToJedisSentinelSet(Collection<RedisNode> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return Collections.emptySet();
        }
        LinkedHashSet<HostAndPort> convertedNodes = new LinkedHashSet<HostAndPort>(nodes.size());
        for (RedisNode node : nodes) {
            if (node == null) continue;
            convertedNodes.add(new HostAndPort(node.getHost(), node.getPort().intValue()));
        }
        return convertedNodes;
    }

    private int getReadTimeout() {
        return Math.toIntExact(this.clientConfiguration.getReadTimeout().toMillis());
    }

    private int getConnectTimeout() {
        return Math.toIntExact(this.clientConfiguration.getConnectTimeout().toMillis());
    }

    private MutableJedisClientConfiguration getMutableConfiguration() {
        Assert.state((boolean)(this.clientConfiguration instanceof MutableJedisClientConfiguration), () -> "Client configuration must be instance of MutableJedisClientConfiguration but is %s".formatted(ClassUtils.getShortName(this.clientConfiguration.getClass())));
        return (MutableJedisClientConfiguration)this.clientConfiguration;
    }

    private void assertInitialized() {
        State current = this.state.get();
        if (State.STARTED.equals((Object)current)) {
            return;
        }
        switch (current) {
            case CREATED: 
            case STOPPED: {
                throw new IllegalStateException("JedisConnectionFactory has been %s. Use start() to initialize it".formatted(new Object[]{current}));
            }
            case DESTROYED: {
                throw new IllegalStateException("JedisConnectionFactory was destroyed and cannot be used anymore");
            }
        }
        throw new IllegalStateException("JedisConnectionFactory is %s".formatted(new Object[]{current}));
    }

    static class MutableJedisClientConfiguration
    implements JedisClientConfiguration {
        private boolean useSsl;
        @Nullable
        private SSLSocketFactory sslSocketFactory;
        @Nullable
        private SSLParameters sslParameters;
        @Nullable
        private HostnameVerifier hostnameVerifier;
        private boolean usePooling = true;
        private GenericObjectPoolConfig poolConfig = new JedisPoolConfig();
        @Nullable
        private String clientName;
        private Duration readTimeout = Duration.ofMillis(2000L);
        private Duration connectTimeout = Duration.ofMillis(2000L);

        MutableJedisClientConfiguration() {
        }

        public static JedisClientConfiguration create(GenericObjectPoolConfig jedisPoolConfig) {
            MutableJedisClientConfiguration configuration = new MutableJedisClientConfiguration();
            configuration.setPoolConfig(jedisPoolConfig);
            return configuration;
        }

        @Override
        public boolean isUseSsl() {
            return this.useSsl;
        }

        public void setUseSsl(boolean useSsl) {
            this.useSsl = useSsl;
        }

        @Override
        public Optional<SSLSocketFactory> getSslSocketFactory() {
            return Optional.ofNullable(this.sslSocketFactory);
        }

        public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
        }

        @Override
        public Optional<SSLParameters> getSslParameters() {
            return Optional.ofNullable(this.sslParameters);
        }

        public void setSslParameters(SSLParameters sslParameters) {
            this.sslParameters = sslParameters;
        }

        @Override
        public Optional<HostnameVerifier> getHostnameVerifier() {
            return Optional.ofNullable(this.hostnameVerifier);
        }

        public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
        }

        @Override
        public boolean isUsePooling() {
            return this.usePooling;
        }

        public void setUsePooling(boolean usePooling) {
            this.usePooling = usePooling;
        }

        @Override
        public Optional<GenericObjectPoolConfig> getPoolConfig() {
            return Optional.ofNullable(this.poolConfig);
        }

        public void setPoolConfig(GenericObjectPoolConfig poolConfig) {
            this.poolConfig = poolConfig;
        }

        @Override
        public Optional<String> getClientName() {
            return Optional.ofNullable(this.clientName);
        }

        public void setClientName(String clientName) {
            this.clientName = clientName;
        }

        @Override
        public Duration getReadTimeout() {
            return this.readTimeout;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
        }

        @Override
        public Duration getConnectTimeout() {
            return this.connectTimeout;
        }

        public void setConnectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
        }
    }

    static enum State {
        CREATED,
        STARTING,
        STARTED,
        STOPPING,
        STOPPED,
        DESTROYED;

    }
}

