/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.util;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;

public class ByteArrayWrapper
implements Comparable<ByteArrayWrapper> {
    private final byte[] array;
    private final int hashCode;

    public ByteArrayWrapper(ByteBuffer buffer) {
        this(ByteUtils.getBytes(buffer.asReadOnlyBuffer()));
    }

    public ByteArrayWrapper(byte[] array) {
        this.array = array;
        this.hashCode = Arrays.hashCode(array);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof ByteArrayWrapper) {
            return Arrays.equals(this.array, ((ByteArrayWrapper)obj).array);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public byte[] getArray() {
        return this.array;
    }

    public String toString() {
        return new String(this.array);
    }

    @Override
    public int compareTo(ByteArrayWrapper o) {
        return Arrays.compare(this.array, o.array);
    }
}

