/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.BitFieldArgs;
import io.lettuce.core.GeoArgs;
import io.lettuce.core.GeoCoordinates;
import io.lettuce.core.GeoSearch;
import io.lettuce.core.GeoWithin;
import io.lettuce.core.GetExArgs;
import io.lettuce.core.KeyScanArgs;
import io.lettuce.core.KeyValue;
import io.lettuce.core.LMoveArgs;
import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.RedisURI;
import io.lettuce.core.ScanArgs;
import io.lettuce.core.ScoredValue;
import io.lettuce.core.ScriptOutputType;
import io.lettuce.core.SetArgs;
import io.lettuce.core.SortArgs;
import io.lettuce.core.TransactionResult;
import io.lettuce.core.cluster.models.partitions.Partitions;
import io.lettuce.core.cluster.models.partitions.RedisClusterNode;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.BitFieldSubCommands;
import org.springframework.data.redis.connection.DefaultTuple;
import org.springframework.data.redis.connection.RedisClusterNode;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisServer;
import org.springframework.data.redis.connection.RedisSocketConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.convert.ListConverter;
import org.springframework.data.redis.connection.convert.LongToBooleanConverter;
import org.springframework.data.redis.connection.convert.StringToRedisClientInfoConverter;
import org.springframework.data.redis.connection.lettuce.LettuceExceptionConverter;
import org.springframework.data.redis.core.KeyScanOptions;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.core.types.RedisClientInfo;
import org.springframework.data.redis.domain.geo.BoundingBox;
import org.springframework.data.redis.domain.geo.BoxShape;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.data.redis.domain.geo.RadiusShape;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class LettuceConverters
extends Converters {
    private static final Converter<Exception, DataAccessException> EXCEPTION_CONVERTER = new LettuceExceptionConverter();
    private static final ListConverter<GeoCoordinates, Point> GEO_COORDINATE_LIST_TO_POINT_LIST_CONVERTER;
    private static final ListConverter<KeyValue<Object, Object>, Object> KEY_VALUE_LIST_UNWRAPPER;
    public static final byte[] PLUS_BYTES;
    public static final byte[] MINUS_BYTES;
    public static final byte[] POSITIVE_INFINITY_BYTES;
    public static final byte[] NEGATIVE_INFINITY_BYTES;
    private static final long INDEXED_RANGE_START = 0L;
    private static final long INDEXED_RANGE_END = -1L;

    @Deprecated
    public static List<RedisZSetCommands.Tuple> toTuple(List<byte[]> source) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        ArrayList<RedisZSetCommands.Tuple> tuples = new ArrayList<RedisZSetCommands.Tuple>();
        Iterator<byte[]> it = source.iterator();
        while (it.hasNext()) {
            tuples.add(new DefaultTuple(it.next(), it.hasNext() ? Double.valueOf(LettuceConverters.toString(it.next())) : null));
        }
        return tuples;
    }

    @Deprecated
    public static Converter<List<byte[]>, List<RedisZSetCommands.Tuple>> bytesListToTupleListConverter() {
        return LettuceConverters::toTuple;
    }

    public static Point geoCoordinatesToPoint(@Nullable GeoCoordinates geoCoordinate) {
        return geoCoordinate != null ? new Point(geoCoordinate.getX().doubleValue(), geoCoordinate.getY().doubleValue()) : null;
    }

    public static Converter<String, List<RedisClientInfo>> stringToRedisClientListConverter() {
        return LettuceConverters::toListOfRedisClientInformation;
    }

    @Deprecated
    public static Converter<Date, Long> dateToLong() {
        return LettuceConverters::toLong;
    }

    @Deprecated
    public static Converter<List<byte[]>, Set<byte[]>> bytesListToBytesSet() {
        return LettuceConverters::toBytesSet;
    }

    @Deprecated
    public static Converter<byte[], String> bytesToString() {
        return LettuceConverters::toString;
    }

    @Deprecated
    public static Converter<KeyValue<byte[], byte[]>, List<byte[]>> keyValueToBytesList() {
        return LettuceConverters::toBytesList;
    }

    @Deprecated
    public static Converter<Collection<byte[]>, List<byte[]>> bytesSetToBytesList() {
        return LettuceConverters::toBytesList;
    }

    @Deprecated
    public static Converter<Collection<byte[]>, List<byte[]>> bytesCollectionToBytesList() {
        return LettuceConverters::toBytesList;
    }

    @Deprecated
    public static Converter<List<ScoredValue<byte[]>>, Set<RedisZSetCommands.Tuple>> scoredValuesToTupleSet() {
        return LettuceConverters::toTupleSet;
    }

    public static Converter<List<ScoredValue<byte[]>>, List<RedisZSetCommands.Tuple>> scoredValuesToTupleList() {
        return source -> {
            if (source == null) {
                return null;
            }
            ArrayList<RedisZSetCommands.Tuple> tuples = new ArrayList<RedisZSetCommands.Tuple>(source.size());
            for (ScoredValue value : source) {
                tuples.add(LettuceConverters.toTuple((ScoredValue<byte[]>)value));
            }
            return tuples;
        };
    }

    @Deprecated
    public static Converter<ScoredValue<byte[]>, RedisZSetCommands.Tuple> scoredValueToTuple() {
        return LettuceConverters::toTuple;
    }

    @Deprecated
    public static Converter<Exception, DataAccessException> exceptionConverter() {
        return EXCEPTION_CONVERTER;
    }

    public static Converter<Long, Boolean> longToBooleanConverter() {
        return LongToBooleanConverter.INSTANCE;
    }

    public static Long toLong(@Nullable Date source) {
        return source != null ? Long.valueOf(source.getTime()) : null;
    }

    public static Set<byte[]> toBytesSet(@Nullable List<byte[]> source) {
        return source != null ? new LinkedHashSet<byte[]>(source) : null;
    }

    public static List<byte[]> toBytesList(KeyValue<byte[], byte[]> source) {
        if (source == null) {
            return null;
        }
        ArrayList<byte[]> list = new ArrayList<byte[]>(2);
        list.add((byte[])source.getKey());
        list.add((byte[])source.getValue());
        return list;
    }

    public static List<byte[]> toBytesList(Collection<byte[]> source) {
        if (source instanceof List) {
            return (List)source;
        }
        return source != null ? new ArrayList<byte[]>(source) : null;
    }

    @Deprecated
    public static Set<RedisZSetCommands.Tuple> toTupleSet(@Nullable List<ScoredValue<byte[]>> source) {
        if (source == null) {
            return null;
        }
        LinkedHashSet<RedisZSetCommands.Tuple> tuples = new LinkedHashSet<RedisZSetCommands.Tuple>(source.size());
        for (ScoredValue<byte[]> value : source) {
            tuples.add(LettuceConverters.toTuple(value));
        }
        return tuples;
    }

    public static RedisZSetCommands.Tuple toTuple(@Nullable ScoredValue<byte[]> source) {
        return source != null && source.hasValue() ? new DefaultTuple((byte[])source.getValue(), source.getScore()) : null;
    }

    public static String toString(@Nullable byte[] source) {
        if (source == null || Arrays.equals(source, new byte[0])) {
            return null;
        }
        return new String(source);
    }

    public static ScriptOutputType toScriptOutputType(ReturnType returnType) {
        switch (returnType) {
            case BOOLEAN: {
                return ScriptOutputType.BOOLEAN;
            }
            case MULTI: {
                return ScriptOutputType.MULTI;
            }
            case VALUE: {
                return ScriptOutputType.VALUE;
            }
            case INTEGER: {
                return ScriptOutputType.INTEGER;
            }
            case STATUS: {
                return ScriptOutputType.STATUS;
            }
        }
        throw new IllegalArgumentException("Return type " + (Object)((Object)returnType) + " is not a supported script output type");
    }

    public static boolean toBoolean(RedisListCommands.Position where) {
        Assert.notNull((Object)((Object)where), (String)"list positions are mandatory");
        return !RedisListCommands.Position.AFTER.equals((Object)where);
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static Map<byte[], byte[]> toMap(List<byte[]> source) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<byte[], byte[]> target = new LinkedHashMap<byte[], byte[]>();
        Iterator<byte[]> kv = source.iterator();
        while (kv.hasNext()) {
            target.put(kv.next(), kv.hasNext() ? kv.next() : null);
        }
        return target;
    }

    @Deprecated
    public static Converter<List<byte[]>, Map<byte[], byte[]>> bytesListToMapConverter() {
        return LettuceConverters::toMap;
    }

    public static SortArgs toSortArgs(SortParameters params) {
        Boolean isAlpha;
        SortArgs args = new SortArgs();
        if (params == null) {
            return args;
        }
        if (params.getByPattern() != null) {
            args.by(new String(params.getByPattern(), StandardCharsets.US_ASCII));
        }
        if (params.getLimit() != null) {
            args.limit(params.getLimit().getStart(), params.getLimit().getCount());
        }
        if (params.getGetPattern() != null) {
            byte[][] pattern;
            for (byte[] bs : pattern = params.getGetPattern()) {
                args.get(new String(bs, StandardCharsets.US_ASCII));
            }
        }
        if (params.getOrder() != null) {
            if (params.getOrder() == SortParameters.Order.ASC) {
                args.asc();
            } else {
                args.desc();
            }
        }
        if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
            args.alpha();
        }
        return args;
    }

    public static List<RedisClientInfo> toListOfRedisClientInformation(String clientList) {
        if (!StringUtils.hasText((String)clientList)) {
            return Collections.emptyList();
        }
        return StringToRedisClientInfoConverter.INSTANCE.convert(clientList.split("\\r?\\n"));
    }

    @Deprecated
    public static byte[][] subarray(byte[][] input, int index) {
        if (input.length > index) {
            byte[][] output = new byte[input.length - index][];
            System.arraycopy(input, index, output, 0, output.length);
            return output;
        }
        return null;
    }

    @Deprecated
    public static String boundaryToStringForZRange(RedisZSetCommands.Range.Boundary boundary, String defaultValue) {
        if (boundary == null || boundary.getValue() == null) {
            return defaultValue;
        }
        return LettuceConverters.boundaryToString(boundary, "", "(");
    }

    private static String boundaryToString(RedisZSetCommands.Range.Boundary boundary, String inclPrefix, String exclPrefix) {
        String prefix = boundary.isIncluding() ? inclPrefix : exclPrefix;
        String value = null;
        value = boundary.getValue() instanceof byte[] ? LettuceConverters.toString((byte[])boundary.getValue()) : boundary.getValue().toString();
        return prefix + value;
    }

    public static Limit toLimit(RedisZSetCommands.Limit limit) {
        return limit.isUnlimited() ? Limit.unlimited() : Limit.create((long)limit.getOffset(), (long)limit.getCount());
    }

    public static <T> Range<T> toRange(RedisZSetCommands.Range range) {
        return Range.from(LettuceConverters.lowerBoundaryOf(range, false), LettuceConverters.upperBoundaryOf(range, false));
    }

    public static <T> Range<T> toRange(RedisZSetCommands.Range range, boolean convertNumberToBytes) {
        return Range.from(LettuceConverters.lowerBoundaryOf(range, convertNumberToBytes), LettuceConverters.upperBoundaryOf(range, convertNumberToBytes));
    }

    public static <T> Range<T> toRevRange(RedisZSetCommands.Range range) {
        return Range.from(LettuceConverters.upperBoundaryOf(range, false), LettuceConverters.lowerBoundaryOf(range, false));
    }

    private static <T> Range.Boundary<T> lowerBoundaryOf(RedisZSetCommands.Range range, boolean convertNumberToBytes) {
        return (Range.Boundary)LettuceConverters.rangeToBoundaryArgumentConverter(false, convertNumberToBytes).convert((Object)range);
    }

    private static <T> Range.Boundary<T> upperBoundaryOf(RedisZSetCommands.Range range, boolean convertNumberToBytes) {
        return (Range.Boundary)LettuceConverters.rangeToBoundaryArgumentConverter(true, convertNumberToBytes).convert((Object)range);
    }

    private static Converter<RedisZSetCommands.Range, Range.Boundary<?>> rangeToBoundaryArgumentConverter(boolean upper, boolean convertNumberToBytes) {
        return source -> {
            RedisZSetCommands.Range.Boundary sourceBoundary;
            RedisZSetCommands.Range.Boundary boundary = sourceBoundary = upper ? source.getMax() : source.getMin();
            if (sourceBoundary == null || sourceBoundary.getValue() == null) {
                return Range.Boundary.unbounded();
            }
            boolean inclusive = sourceBoundary.isIncluding();
            Object value = sourceBoundary.getValue();
            if (value instanceof Number) {
                if (convertNumberToBytes) {
                    value = value.toString();
                } else {
                    return inclusive ? Range.Boundary.including((Object)((Number)value)) : Range.Boundary.excluding((Object)((Number)value));
                }
            }
            if (value instanceof String) {
                if (!StringUtils.hasText((String)((String)value)) || ObjectUtils.nullSafeEquals((Object)value, (Object)"+") || ObjectUtils.nullSafeEquals((Object)value, (Object)"-")) {
                    return Range.Boundary.unbounded();
                }
                return inclusive ? Range.Boundary.including((Object)value.toString().getBytes(StandardCharsets.UTF_8)) : Range.Boundary.excluding((Object)value.toString().getBytes(StandardCharsets.UTF_8));
            }
            return inclusive ? Range.Boundary.including((Object)((byte[])value)) : Range.Boundary.excluding((Object)((byte[])value));
        };
    }

    public static List<RedisServer> toListOfRedisServer(List<Map<String, String>> source) {
        if (CollectionUtils.isEmpty(source)) {
            return Collections.emptyList();
        }
        ArrayList<RedisServer> sentinels = new ArrayList<RedisServer>();
        for (Map<String, String> info : source) {
            sentinels.add(RedisServer.newServerFrom(Converters.toProperties(info)));
        }
        return sentinels;
    }

    public static RedisURI sentinelConfigurationToRedisURI(RedisSentinelConfiguration sentinelConfiguration) {
        Assert.notNull((Object)sentinelConfiguration, (String)"RedisSentinelConfiguration is required");
        Set<RedisNode> sentinels = sentinelConfiguration.getSentinels();
        RedisPassword sentinelPassword = sentinelConfiguration.getSentinelPassword();
        RedisURI.Builder builder = RedisURI.builder();
        for (RedisNode sentinel : sentinels) {
            RedisURI.Builder sentinelBuilder = RedisURI.Builder.redis((String)sentinel.getHost(), (int)sentinel.getPort());
            sentinelPassword.toOptional().ifPresent(arg_0 -> ((RedisURI.Builder)sentinelBuilder).withPassword(arg_0));
            builder.withSentinel(sentinelBuilder.build());
        }
        String username = sentinelConfiguration.getUsername();
        RedisPassword password = sentinelConfiguration.getPassword();
        if (StringUtils.hasText((String)username)) {
            builder.withAuthentication(username, (CharSequence)new String(password.toOptional().orElse(new char[0])));
        } else {
            password.toOptional().ifPresent(arg_0 -> ((RedisURI.Builder)builder).withPassword(arg_0));
        }
        builder.withSentinelMasterId(sentinelConfiguration.getMaster().getName());
        return builder.build();
    }

    static RedisStandaloneConfiguration createRedisStandaloneConfiguration(RedisURI redisURI) {
        RedisStandaloneConfiguration standaloneConfiguration = new RedisStandaloneConfiguration();
        standaloneConfiguration.setHostName(redisURI.getHost());
        standaloneConfiguration.setPort(redisURI.getPort());
        standaloneConfiguration.setDatabase(redisURI.getDatabase());
        LettuceConverters.applyAuthentication(redisURI, standaloneConfiguration);
        return standaloneConfiguration;
    }

    static RedisSocketConfiguration createRedisSocketConfiguration(RedisURI redisURI) {
        RedisSocketConfiguration socketConfiguration = new RedisSocketConfiguration();
        socketConfiguration.setSocket(redisURI.getSocket());
        socketConfiguration.setDatabase(redisURI.getDatabase());
        LettuceConverters.applyAuthentication(redisURI, socketConfiguration);
        return socketConfiguration;
    }

    static RedisSentinelConfiguration createRedisSentinelConfiguration(RedisURI redisURI) {
        RedisSentinelConfiguration sentinelConfiguration = new RedisSentinelConfiguration();
        if (!ObjectUtils.isEmpty((Object)redisURI.getSentinelMasterId())) {
            sentinelConfiguration.setMaster(redisURI.getSentinelMasterId());
        }
        sentinelConfiguration.setDatabase(redisURI.getDatabase());
        for (RedisURI sentinelNodeRedisUri : redisURI.getSentinels()) {
            RedisNode sentinelNode = new RedisNode(sentinelNodeRedisUri.getHost(), sentinelNodeRedisUri.getPort());
            if (sentinelNodeRedisUri.getPassword() != null) {
                sentinelConfiguration.setSentinelPassword(sentinelNodeRedisUri.getPassword());
            }
            sentinelConfiguration.addSentinel(sentinelNode);
        }
        LettuceConverters.applyAuthentication(redisURI, sentinelConfiguration);
        return sentinelConfiguration;
    }

    private static void applyAuthentication(RedisURI redisURI, RedisConfiguration.WithAuthentication redisConfiguration) {
        if (StringUtils.hasText((String)redisURI.getUsername())) {
            redisConfiguration.setUsername(redisURI.getUsername());
        }
        if (redisURI.getPassword() != null) {
            redisConfiguration.setPassword(redisURI.getPassword());
        }
    }

    public static byte[] toBytes(@Nullable String source) {
        if (source == null) {
            return null;
        }
        return source.getBytes();
    }

    public static byte[] toBytes(Integer source) {
        return String.valueOf(source).getBytes();
    }

    public static byte[] toBytes(Long source) {
        return String.valueOf(source).getBytes();
    }

    public static byte[] toBytes(Double source) {
        return LettuceConverters.toBytes(String.valueOf(source));
    }

    @Deprecated
    public static String boundaryToBytesForZRange(RedisZSetCommands.Range.Boundary boundary, byte[] defaultValue) {
        if (boundary == null || boundary.getValue() == null) {
            return LettuceConverters.toString(defaultValue);
        }
        return LettuceConverters.boundaryToBytes(boundary, new byte[0], LettuceConverters.toBytes("("));
    }

    @Deprecated
    public static String boundaryToBytesForZRangeByLex(RedisZSetCommands.Range.Boundary boundary, byte[] defaultValue) {
        if (boundary == null || boundary.getValue() == null) {
            return LettuceConverters.toString(defaultValue);
        }
        return LettuceConverters.boundaryToBytes(boundary, LettuceConverters.toBytes("["), LettuceConverters.toBytes("("));
    }

    private static String boundaryToBytes(RedisZSetCommands.Range.Boundary boundary, byte[] inclPrefix, byte[] exclPrefix) {
        byte[] prefix = boundary.isIncluding() ? inclPrefix : exclPrefix;
        byte[] value = null;
        if (boundary.getValue() instanceof byte[]) {
            value = (byte[])boundary.getValue();
        } else if (boundary.getValue() instanceof Double) {
            value = LettuceConverters.toBytes((Double)boundary.getValue());
        } else if (boundary.getValue() instanceof Long) {
            value = LettuceConverters.toBytes((Long)boundary.getValue());
        } else if (boundary.getValue() instanceof Integer) {
            value = LettuceConverters.toBytes((Integer)boundary.getValue());
        } else if (boundary.getValue() instanceof String) {
            value = LettuceConverters.toBytes((String)boundary.getValue());
        } else {
            throw new IllegalArgumentException(String.format("Cannot convert %s to binary format", boundary.getValue()));
        }
        ByteBuffer buffer = ByteBuffer.allocate(prefix.length + value.length);
        buffer.put(prefix);
        buffer.put(value);
        return LettuceConverters.toString(ByteUtils.getBytes(buffer));
    }

    public static List<RedisClusterNode> partitionsToClusterNodes(@Nullable Partitions source) {
        if (source == null) {
            return Collections.emptyList();
        }
        ArrayList<RedisClusterNode> nodes = new ArrayList<RedisClusterNode>();
        for (io.lettuce.core.cluster.models.partitions.RedisClusterNode node : source) {
            nodes.add(LettuceConverters.toRedisClusterNode(node));
        }
        return nodes;
    }

    public static RedisClusterNode toRedisClusterNode(io.lettuce.core.cluster.models.partitions.RedisClusterNode source) {
        Set<RedisClusterNode.Flag> flags = LettuceConverters.parseFlags(source.getFlags());
        return RedisClusterNode.newRedisClusterNode().listeningAt(source.getUri().getHost(), source.getUri().getPort()).withId(source.getNodeId()).promotedAs(flags.contains((Object)RedisClusterNode.Flag.MASTER) ? RedisNode.NodeType.MASTER : RedisNode.NodeType.SLAVE).serving(new RedisClusterNode.SlotRange(source.getSlots())).withFlags(flags).linkState(source.isConnected() ? RedisClusterNode.LinkState.CONNECTED : RedisClusterNode.LinkState.DISCONNECTED).slaveOf(source.getSlaveOf()).build();
    }

    private static Set<RedisClusterNode.Flag> parseFlags(@Nullable Set<RedisClusterNode.NodeFlag> source) {
        LinkedHashSet<RedisClusterNode.Flag> flags = new LinkedHashSet<RedisClusterNode.Flag>(source != null ? source.size() : 8, 1.0f);
        for (RedisClusterNode.NodeFlag flag : source) {
            switch (flag) {
                case NOFLAGS: {
                    flags.add(RedisClusterNode.Flag.NOFLAGS);
                    break;
                }
                case EVENTUAL_FAIL: {
                    flags.add(RedisClusterNode.Flag.PFAIL);
                    break;
                }
                case FAIL: {
                    flags.add(RedisClusterNode.Flag.FAIL);
                    break;
                }
                case HANDSHAKE: {
                    flags.add(RedisClusterNode.Flag.HANDSHAKE);
                    break;
                }
                case MASTER: {
                    flags.add(RedisClusterNode.Flag.MASTER);
                    break;
                }
                case MYSELF: {
                    flags.add(RedisClusterNode.Flag.MYSELF);
                    break;
                }
                case NOADDR: {
                    flags.add(RedisClusterNode.Flag.NOADDR);
                    break;
                }
                case SLAVE: {
                    flags.add(RedisClusterNode.Flag.SLAVE);
                }
            }
        }
        return flags;
    }

    public static SetArgs toSetArgs(@Nullable Expiration expiration, @Nullable RedisStringCommands.SetOption option) {
        SetArgs args = new SetArgs();
        if (expiration != null) {
            if (expiration.isKeepTtl()) {
                args.keepttl();
            } else if (!expiration.isPersistent()) {
                switch (expiration.getTimeUnit()) {
                    case MILLISECONDS: {
                        if (expiration.isUnixTimestamp()) {
                            args.pxAt(expiration.getConverted(TimeUnit.MILLISECONDS));
                            break;
                        }
                        args.px(expiration.getConverted(TimeUnit.MILLISECONDS));
                        break;
                    }
                    default: {
                        if (expiration.isUnixTimestamp()) {
                            args.exAt(expiration.getConverted(TimeUnit.SECONDS));
                            break;
                        }
                        args.ex(expiration.getConverted(TimeUnit.SECONDS));
                    }
                }
            }
        }
        if (option != null) {
            switch (option) {
                case SET_IF_ABSENT: {
                    args.nx();
                    break;
                }
                case SET_IF_PRESENT: {
                    args.xx();
                    break;
                }
            }
        }
        return args;
    }

    static GetExArgs toGetExArgs(@Nullable Expiration expiration) {
        GetExArgs args = new GetExArgs();
        if (expiration == null) {
            return args;
        }
        if (expiration.isPersistent()) {
            return args.persist();
        }
        if (expiration.getTimeUnit() == TimeUnit.MILLISECONDS) {
            if (expiration.isUnixTimestamp()) {
                return args.pxAt(expiration.getExpirationTime());
            }
            return args.px(expiration.getExpirationTime());
        }
        return expiration.isUnixTimestamp() ? args.exAt(expiration.getConverted(TimeUnit.SECONDS)) : args.ex(expiration.getConverted(TimeUnit.SECONDS));
    }

    static Converter<List<byte[]>, Long> toTimeConverter(TimeUnit timeUnit) {
        return source -> {
            Assert.notEmpty((Collection)source, (String)"Received invalid result from server. Expected 2 items in collection.");
            Assert.isTrue((source.size() == 2 ? 1 : 0) != 0, (String)("Received invalid nr of arguments from redis server. Expected 2 received " + source.size()));
            return LettuceConverters.toTimeMillis(LettuceConverters.toString((byte[])source.get(0)), LettuceConverters.toString((byte[])source.get(1)), timeUnit);
        };
    }

    public static GeoArgs.Unit toGeoArgsUnit(Metric metric) {
        RedisGeoCommands.DistanceUnit metricToUse = metric == null || ObjectUtils.nullSafeEquals((Object)Metrics.NEUTRAL, (Object)metric) ? RedisGeoCommands.DistanceUnit.METERS : metric;
        return (GeoArgs.Unit)ObjectUtils.caseInsensitiveValueOf((Enum[])GeoArgs.Unit.values(), (String)metricToUse.getAbbreviation());
    }

    public static GeoArgs toGeoArgs(RedisGeoCommands.GeoRadiusCommandArgs args) {
        return LettuceConverters.toGeoArgs((RedisGeoCommands.GeoCommandArgs)args);
    }

    public static GeoArgs toGeoArgs(RedisGeoCommands.GeoCommandArgs args) {
        GeoArgs geoArgs = new GeoArgs();
        if (args.hasFlags()) {
            for (RedisGeoCommands.GeoCommandArgs.GeoCommandFlag geoCommandFlag : args.getFlags()) {
                if (geoCommandFlag.equals(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHCOORD)) {
                    geoArgs.withCoordinates();
                    continue;
                }
                if (!geoCommandFlag.equals(RedisGeoCommands.GeoRadiusCommandArgs.Flag.WITHDIST)) continue;
                geoArgs.withDistance();
            }
        }
        if (args.hasSortDirection()) {
            switch (args.getSortDirection()) {
                case ASC: {
                    geoArgs.asc();
                    break;
                }
                case DESC: {
                    geoArgs.desc();
                }
            }
        }
        if (args.hasLimit()) {
            geoArgs.withCount(args.getLimit().longValue(), args.getFlags().contains(RedisGeoCommands.GeoRadiusCommandArgs.Flag.ANY));
        }
        return geoArgs;
    }

    public static BitFieldArgs toBitFieldArgs(BitFieldSubCommands subCommands) {
        BitFieldArgs args = new BitFieldArgs();
        for (BitFieldSubCommands.BitFieldSubCommand subCommand : subCommands) {
            BitFieldArgs.BitFieldType bft = subCommand.getType().isSigned() ? BitFieldArgs.signed((int)subCommand.getType().getBits()) : BitFieldArgs.unsigned((int)subCommand.getType().getBits());
            BitFieldArgs.Offset offset = subCommand.getOffset().isZeroBased() ? BitFieldArgs.offset((int)((int)subCommand.getOffset().getValue())) : BitFieldArgs.typeWidthBasedOffset((int)((int)subCommand.getOffset().getValue()));
            if (subCommand instanceof BitFieldSubCommands.BitFieldGet) {
                args = args.get(bft, offset);
                continue;
            }
            if (subCommand instanceof BitFieldSubCommands.BitFieldSet) {
                args = args.set(bft, offset, ((BitFieldSubCommands.BitFieldSet)subCommand).getValue());
                continue;
            }
            if (!(subCommand instanceof BitFieldSubCommands.BitFieldIncrBy)) continue;
            BitFieldSubCommands.BitFieldIncrBy.Overflow overflow = ((BitFieldSubCommands.BitFieldIncrBy)subCommand).getOverflow();
            if (overflow != null) {
                BitFieldArgs.OverflowType type;
                switch (overflow) {
                    case SAT: {
                        type = BitFieldArgs.OverflowType.SAT;
                        break;
                    }
                    case FAIL: {
                        type = BitFieldArgs.OverflowType.FAIL;
                        break;
                    }
                    case WRAP: {
                        type = BitFieldArgs.OverflowType.WRAP;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Invalid OVERFLOW. Expected one the following %s but got %s.", new Object[]{Arrays.toString((Object[])BitFieldSubCommands.BitFieldIncrBy.Overflow.values()), overflow}));
                    }
                }
                args = args.overflow(type);
            }
            args = args.incrBy(bft, (int)subCommand.getOffset().getValue(), ((BitFieldSubCommands.BitFieldIncrBy)subCommand).getValue());
        }
        return args;
    }

    @Nullable
    static ScanArgs toScanArgs(@Nullable ScanOptions options) {
        if (options == null) {
            return null;
        }
        KeyScanArgs scanArgs = new KeyScanArgs();
        byte[] pattern = options.getBytePattern();
        if (pattern != null) {
            scanArgs.match(pattern);
        }
        if (options.getCount() != null) {
            scanArgs.limit(options.getCount().longValue());
        }
        if (options instanceof KeyScanOptions) {
            scanArgs.type(((KeyScanOptions)options).getType());
        }
        return scanArgs;
    }

    public static Converter<Set<byte[]>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> bytesSetToGeoResultsConverter() {
        return source -> {
            if (CollectionUtils.isEmpty((Collection)source)) {
                return new GeoResults(Collections.emptyList());
            }
            ArrayList<GeoResult> results = new ArrayList<GeoResult>(source.size());
            Iterator it = source.iterator();
            while (it.hasNext()) {
                results.add(new GeoResult(new RedisGeoCommands.GeoLocation(it.next(), null), new Distance(0.0)));
            }
            return new GeoResults(results);
        };
    }

    public static Converter<List<GeoWithin<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> geoRadiusResponseToGeoResultsConverter(Metric metric) {
        return GeoResultsConverterFactory.INSTANCE.forMetric(metric);
    }

    @Deprecated
    public static ListConverter<GeoCoordinates, Point> geoCoordinatesToPointConverter() {
        return GEO_COORDINATE_LIST_TO_POINT_LIST_CONVERTER;
    }

    @Deprecated
    public static <K, V> ListConverter<KeyValue<K, V>, V> keyValueListUnwrapper() {
        return KEY_VALUE_LIST_UNWRAPPER;
    }

    public static Converter<TransactionResult, List<Object>> transactionResultUnwrapper() {
        return transactionResult -> transactionResult.stream().collect(Collectors.toList());
    }

    static <T extends Comparable<T>> Optional<T> getLowerBound(org.springframework.data.domain.Range<T> range) {
        return range.getLowerBound().getValue();
    }

    static <T extends Comparable<T>> Optional<T> getUpperBound(org.springframework.data.domain.Range<T> range) {
        return range.getUpperBound().getValue();
    }

    static long getLowerBoundIndex(org.springframework.data.domain.Range<Long> range) {
        return LettuceConverters.getLowerBound(range).orElse(0L);
    }

    static long getUpperBoundIndex(org.springframework.data.domain.Range<Long> range) {
        return LettuceConverters.getUpperBound(range).orElse(-1L);
    }

    static LMoveArgs toLmoveArgs(Enum<?> from, Enum<?> to) {
        if (from.name().equals(RedisListCommands.Direction.LEFT.name())) {
            if (to.name().equals(RedisListCommands.Direction.LEFT.name())) {
                return LMoveArgs.Builder.leftLeft();
            }
            return LMoveArgs.Builder.leftRight();
        }
        if (to.name().equals(RedisListCommands.Direction.LEFT.name())) {
            return LMoveArgs.Builder.rightLeft();
        }
        return LMoveArgs.Builder.rightRight();
    }

    static GeoSearch.GeoPredicate toGeoPredicate(GeoShape predicate) {
        if (predicate instanceof RadiusShape) {
            Distance radius = ((RadiusShape)predicate).getRadius();
            return GeoSearch.byRadius((double)radius.getValue(), (GeoArgs.Unit)LettuceConverters.toGeoArgsUnit(radius.getMetric()));
        }
        if (predicate instanceof BoxShape) {
            BoxShape boxPredicate = (BoxShape)predicate;
            BoundingBox boundingBox = boxPredicate.getBoundingBox();
            return GeoSearch.byBox((double)boundingBox.getWidth().getValue(), (double)boundingBox.getHeight().getValue(), (GeoArgs.Unit)LettuceConverters.toGeoArgsUnit(boxPredicate.getMetric()));
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to Lettuce GeoPredicate", predicate));
    }

    static <T> GeoSearch.GeoRef<T> toGeoRef(GeoReference<T> reference) {
        if (reference instanceof GeoReference.GeoMemberReference) {
            return GeoSearch.fromMember(((GeoReference.GeoMemberReference)reference).getMember());
        }
        if (reference instanceof GeoReference.GeoCoordinateReference) {
            GeoReference.GeoCoordinateReference coordinates = (GeoReference.GeoCoordinateReference)reference;
            return GeoSearch.fromCoordinates((double)coordinates.getLongitude(), (double)coordinates.getLatitude());
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to Lettuce GeoRef", reference));
    }

    static {
        PLUS_BYTES = LettuceConverters.toBytes("+");
        MINUS_BYTES = LettuceConverters.toBytes("-");
        POSITIVE_INFINITY_BYTES = LettuceConverters.toBytes("+inf");
        NEGATIVE_INFINITY_BYTES = LettuceConverters.toBytes("-inf");
        GEO_COORDINATE_LIST_TO_POINT_LIST_CONVERTER = new ListConverter(LettuceConverters::geoCoordinatesToPoint);
        KEY_VALUE_LIST_UNWRAPPER = new ListConverter(source -> source.getValueOrElse(null));
    }

    static enum GeoResultConverterFactory {
        INSTANCE;


        Converter<GeoWithin<byte[]>, GeoResult<RedisGeoCommands.GeoLocation<byte[]>>> forMetric(Metric metric) {
            return new GeoResultConverter(metric);
        }

        private static class GeoResultConverter
        implements Converter<GeoWithin<byte[]>, GeoResult<RedisGeoCommands.GeoLocation<byte[]>>> {
            private Metric metric;

            public GeoResultConverter(Metric metric) {
                this.metric = metric;
            }

            public GeoResult<RedisGeoCommands.GeoLocation<byte[]>> convert(GeoWithin<byte[]> source) {
                Point point = LettuceConverters.geoCoordinatesToPoint(source.getCoordinates());
                return new GeoResult(new RedisGeoCommands.GeoLocation<Object>(source.getMember(), point), new Distance(source.getDistance() != null ? source.getDistance() : 0.0, this.metric));
            }
        }
    }

    static enum GeoResultsConverterFactory {
        INSTANCE;


        Converter<List<GeoWithin<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> forMetric(Metric metric) {
            return new GeoResultsConverter(metric == null || ObjectUtils.nullSafeEquals((Object)Metrics.NEUTRAL, (Object)metric) ? RedisGeoCommands.DistanceUnit.METERS : metric);
        }

        private static class GeoResultsConverter
        implements Converter<List<GeoWithin<byte[]>>, GeoResults<RedisGeoCommands.GeoLocation<byte[]>>> {
            private Metric metric;

            public GeoResultsConverter(Metric metric) {
                this.metric = metric;
            }

            public GeoResults<RedisGeoCommands.GeoLocation<byte[]>> convert(List<GeoWithin<byte[]>> source) {
                ArrayList<Object> results = new ArrayList<Object>(source.size());
                Converter<GeoWithin<byte[]>, GeoResult<RedisGeoCommands.GeoLocation<byte[]>>> converter = GeoResultConverterFactory.INSTANCE.forMetric(this.metric);
                for (GeoWithin<byte[]> result : source) {
                    results.add(converter.convert(result));
                }
                return new GeoResults(results, this.metric);
            }
        }
    }
}

