/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.data.redis.connection.ReactiveSetCommands;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.ReactiveSetOperations;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveSetOperations<K, V>
implements ReactiveSetOperations<K, V> {
    @NonNull
    private final ReactiveRedisTemplate<?, ?> template;
    @NonNull
    private final RedisSerializationContext<K, V> serializationContext;

    @Override
    public Mono<Long> add(K key, V ... values) {
        Assert.notNull(key, (String)"Key must not be null!");
        if (values.length == 1) {
            return this.createMono(connection -> connection.sAdd(this.rawKey(key), this.rawValue(values[0])));
        }
        return this.createMono(connection -> Flux.fromArray((Object[])values).map(this::rawValue).collectList().flatMap(serialized -> connection.sAdd(this.rawKey(key), (Collection<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<Long> remove(K key, Object ... values) {
        Assert.notNull(key, (String)"Key must not be null!");
        if (values.length == 1) {
            return this.createMono(connection -> connection.sRem(this.rawKey(key), this.rawValue(values[0])));
        }
        return this.createMono(connection -> Flux.fromArray((Object[])values).map(this::rawValue).collectList().flatMap(serialized -> connection.sRem(this.rawKey(key), (Collection<ByteBuffer>)serialized)));
    }

    @Override
    public Mono<V> pop(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.sPop(this.rawKey(key)).map(this::readValue));
    }

    @Override
    public Flux<V> pop(K key, long count) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createFlux(connection -> connection.sPop(this.rawKey(key), count).map(this::readValue));
    }

    @Override
    public Mono<Boolean> move(K sourceKey, V value, K destKey) {
        Assert.notNull(sourceKey, (String)"Source key must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> connection.sMove(this.rawKey(sourceKey), this.rawKey(destKey), this.rawValue(value)));
    }

    @Override
    public Mono<Long> size(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.sCard(this.rawKey(key)));
    }

    @Override
    public Mono<Boolean> isMember(K key, Object o) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.sIsMember(this.rawKey(key), this.rawValue(o)));
    }

    @Override
    public Flux<V> intersect(K key, K otherKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        return this.intersect(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Override
    public Flux<V> intersect(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(connection::sInter).map(this::readValue));
    }

    @Override
    public Mono<Long> intersectAndStore(K key, K otherKey, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.intersectAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Mono<Long> intersectAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(rawKeys -> connection.sInterStore(this.rawKey(destKey), (Collection<ByteBuffer>)rawKeys)));
    }

    @Override
    public Flux<V> union(K key, K otherKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        return this.union(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Override
    public Flux<V> union(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(connection::sUnion).map(this::readValue));
    }

    @Override
    public Mono<Long> unionAndStore(K key, K otherKey, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.unionAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Mono<Long> unionAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(rawKeys -> connection.sUnionStore(this.rawKey(destKey), (Collection<ByteBuffer>)rawKeys)));
    }

    @Override
    public Flux<V> difference(K key, K otherKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        return this.difference(key, (Collection<K>)Collections.singleton(otherKey));
    }

    @Override
    public Flux<V> difference(K key, Collection<K> otherKeys) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        return this.createFlux(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMapMany(connection::sDiff).map(this::readValue));
    }

    @Override
    public Mono<Long> differenceAndStore(K key, K otherKey, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKey, (String)"Other key must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.differenceAndStore(key, (Collection<K>)Collections.singleton(otherKey), destKey);
    }

    @Override
    public Mono<Long> differenceAndStore(K key, Collection<K> otherKeys, K destKey) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull(otherKeys, (String)"Other keys must not be null!");
        Assert.notNull(destKey, (String)"Destination key must not be null!");
        return this.createMono(connection -> Flux.fromIterable(this.getKeys(key, otherKeys)).map(this::rawKey).collectList().flatMap(rawKeys -> connection.sDiffStore(this.rawKey(destKey), (Collection<ByteBuffer>)rawKeys)));
    }

    @Override
    public Flux<V> members(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createFlux(connection -> connection.sMembers(this.rawKey(key)).map(this::readValue));
    }

    @Override
    public Flux<V> scan(K key, ScanOptions options) {
        Assert.notNull(key, (String)"Key must not be null!");
        Assert.notNull((Object)options, (String)"ScanOptions must not be null!");
        return this.createFlux(connection -> connection.sScan(this.rawKey(key)).map(this::readValue));
    }

    @Override
    public Mono<V> randomMember(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.createMono(connection -> connection.sRandMember(this.rawKey(key)).map(this::readValue));
    }

    @Override
    public Flux<V> distinctRandomMembers(K key, long count) {
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Negative count not supported. Use randomMembers to allow duplicate elements.");
        return this.createFlux(connection -> connection.sRandMember(this.rawKey(key), count).map(this::readValue));
    }

    @Override
    public Flux<V> randomMembers(K key, long count) {
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Use a positive number for count. This method is already allowing duplicate elements.");
        return this.createFlux(connection -> connection.sRandMember(this.rawKey(key), -count).map(this::readValue));
    }

    @Override
    public Mono<Boolean> delete(K key) {
        Assert.notNull(key, (String)"Key must not be null!");
        return this.template.createMono((ReactiveRedisConnection connection) -> connection.keyCommands().del(this.rawKey(key))).map(l -> l != 0L);
    }

    private <T> Mono<T> createMono(Function<ReactiveSetCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return this.template.createMono((ReactiveRedisConnection connection) -> (Publisher)function.apply(connection.setCommands()));
    }

    private <T> Flux<T> createFlux(Function<ReactiveSetCommands, Publisher<T>> function) {
        Assert.notNull(function, (String)"Function must not be null!");
        return this.template.createFlux((ReactiveRedisConnection connection) -> (Publisher)function.apply(connection.setCommands()));
    }

    private ByteBuffer rawKey(K key) {
        return this.serializationContext.getKeySerializationPair().write(key);
    }

    private List<K> getKeys(K key, Collection<K> otherKeys) {
        ArrayList<K> keys = new ArrayList<K>(1 + otherKeys.size());
        keys.add(key);
        keys.addAll(otherKeys);
        return keys;
    }

    private ByteBuffer rawValue(V value) {
        return this.serializationContext.getValueSerializationPair().write(value);
    }

    private V readValue(ByteBuffer buffer) {
        return this.serializationContext.getValueSerializationPair().read(buffer);
    }

    public DefaultReactiveSetOperations(@NonNull ReactiveRedisTemplate<?, ?> template, @NonNull RedisSerializationContext<K, V> serializationContext) {
        if (template == null) {
            throw new NullPointerException("template is marked non-null but is null");
        }
        if (serializationContext == null) {
            throw new NullPointerException("serializationContext is marked non-null but is null");
        }
        this.template = template;
        this.serializationContext = serializationContext;
    }
}

