/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;

class ClusterConnectionProvider
implements LettuceConnectionProvider {
    private final RedisClusterClient client;
    private final RedisCodec<?, ?> codec;

    ClusterConnectionProvider(RedisClusterClient client, RedisCodec<?, ?> codec) {
        this.client = client;
        this.codec = codec;
    }

    @Override
    public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
        if (connectionType.equals(StatefulRedisPubSubConnection.class)) {
            return (T)((StatefulConnection)connectionType.cast(this.client.connectPubSub(this.codec)));
        }
        if (StatefulRedisClusterConnection.class.isAssignableFrom(connectionType) || connectionType.equals(StatefulConnection.class)) {
            return (T)((StatefulConnection)connectionType.cast(this.client.connect(this.codec)));
        }
        throw new UnsupportedOperationException("Connection type " + connectionType + " not supported!");
    }

    public RedisClusterClient getClient() {
        return this.client;
    }
}

