/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.Callable;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.cache.RedisCacheElement;
import org.springframework.data.redis.cache.RedisCacheKey;
import org.springframework.data.redis.connection.DecoratedRedisConnection;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class RedisCache
implements Cache {
    private final RedisOperations redisOperations;
    private final RedisCacheMetadata cacheMetadata;
    private final CacheValueAccessor cacheValueAccessor;

    public RedisCache(String name, byte[] prefix, RedisOperations<? extends Object, ? extends Object> redisOperations, long expiration) {
        Assert.hasText((String)name, (String)"non-empty cache name is required");
        this.cacheMetadata = new RedisCacheMetadata(name, prefix);
        this.cacheMetadata.setDefaultExpiration(expiration);
        this.redisOperations = redisOperations;
        this.cacheValueAccessor = new CacheValueAccessor(redisOperations.getValueSerializer());
    }

    public <T> T get(Object key, Class<T> type) {
        Cache.ValueWrapper wrapper = this.get(key);
        return (T)(wrapper == null ? null : wrapper.get());
    }

    public Cache.ValueWrapper get(Object key) {
        return this.get(new RedisCacheKey(key).usePrefix(this.cacheMetadata.getKeyPrefix()).withKeySerializer(this.redisOperations.getKeySerializer()));
    }

    public <T> T get(Object key, Callable<T> valueLoader) {
        BinaryRedisCacheElement rce = new BinaryRedisCacheElement(new RedisCacheElement(new RedisCacheKey(key).usePrefix(this.cacheMetadata.getKeyPrefix()).withKeySerializer(this.redisOperations.getKeySerializer()), valueLoader), this.cacheValueAccessor);
        Cache.ValueWrapper val = this.get(key);
        if (val != null) {
            return (T)val.get();
        }
        RedisWriteThroughCallback callback = new RedisWriteThroughCallback(rce, this.cacheMetadata);
        try {
            byte[] result = this.redisOperations.execute(callback);
            return (T)(result == null ? null : this.cacheValueAccessor.deserializeIfNecessary(result));
        }
        catch (RuntimeException e) {
            throw CacheValueRetrievalExceptionFactory.INSTANCE.create(key, valueLoader, e);
        }
    }

    public RedisCacheElement get(RedisCacheKey cacheKey) {
        Assert.notNull((Object)cacheKey, (String)"CacheKey must not be null!");
        byte[] bytes = this.redisOperations.execute(new AbstractRedisCacheCallback<byte[]>(new BinaryRedisCacheElement(new RedisCacheElement(cacheKey, null), this.cacheValueAccessor), this.cacheMetadata){

            @Override
            public byte[] doInRedis(BinaryRedisCacheElement element, RedisConnection connection) throws DataAccessException {
                return connection.get(element.getKeyBytes());
            }
        });
        return bytes == null ? null : new RedisCacheElement(cacheKey, this.cacheValueAccessor.deserializeIfNecessary(bytes));
    }

    public void put(Object key, Object value) {
        this.put(new RedisCacheElement(new RedisCacheKey(key).usePrefix(this.cacheMetadata.getKeyPrefix()).withKeySerializer(this.redisOperations.getKeySerializer()), value).expireAfter(this.cacheMetadata.getDefaultExpiration()));
    }

    public void put(RedisCacheElement element) {
        Assert.notNull((Object)((Object)element), (String)"Element must not be null!");
        this.redisOperations.execute(new RedisCachePutCallback(new BinaryRedisCacheElement(element, this.cacheValueAccessor), this.cacheMetadata));
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        return this.putIfAbsent(new RedisCacheElement(new RedisCacheKey(key).usePrefix(this.cacheMetadata.getKeyPrefix()).withKeySerializer(this.redisOperations.getKeySerializer()), value).expireAfter(this.cacheMetadata.getDefaultExpiration()));
    }

    public Cache.ValueWrapper putIfAbsent(RedisCacheElement element) {
        Assert.notNull((Object)((Object)element), (String)"Element must not be null!");
        new RedisCachePutIfAbsentCallback(new BinaryRedisCacheElement(element, this.cacheValueAccessor), this.cacheMetadata);
        return this.toWrapper(this.cacheValueAccessor.deserializeIfNecessary(this.redisOperations.execute(new RedisCachePutIfAbsentCallback(new BinaryRedisCacheElement(element, this.cacheValueAccessor), this.cacheMetadata))));
    }

    public void evict(Object key) {
        this.evict(new RedisCacheElement(new RedisCacheKey(key).usePrefix(this.cacheMetadata.getKeyPrefix()).withKeySerializer(this.redisOperations.getKeySerializer()), null));
    }

    public void evict(RedisCacheElement element) {
        Assert.notNull((Object)((Object)element), (String)"Element must not be null!");
        this.redisOperations.execute(new RedisCacheEvictCallback(new BinaryRedisCacheElement(element, this.cacheValueAccessor), this.cacheMetadata));
    }

    public void clear() {
        this.redisOperations.execute(this.cacheMetadata.usesKeyPrefix() ? new RedisCacheCleanByPrefixCallback(this.cacheMetadata) : new RedisCacheCleanByKeysCallback(this.cacheMetadata));
    }

    public String getName() {
        return this.cacheMetadata.getCacheName();
    }

    public Object getNativeCache() {
        return this.redisOperations;
    }

    private Cache.ValueWrapper toWrapper(Object value) {
        return value != null ? new SimpleValueWrapper(value) : null;
    }

    private static boolean isClusterConnection(RedisConnection connection) {
        while (connection instanceof DecoratedRedisConnection) {
            connection = ((DecoratedRedisConnection)((Object)connection)).getDelegate();
        }
        return connection instanceof RedisClusterConnection;
    }

    private static enum CacheValueRetrievalExceptionFactory {
        INSTANCE;

        private static boolean isSpring43;

        public RuntimeException create(Object key, Callable<?> valueLoader, Throwable cause) {
            if (isSpring43) {
                try {
                    Class execption = ClassUtils.forName((String)"org.springframework.cache.Cache$ValueRetrievalException", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                    Constructor c = ClassUtils.getConstructorIfAvailable((Class)execption, (Class[])new Class[]{Object.class, Callable.class, Throwable.class});
                    return (RuntimeException)c.newInstance(key, valueLoader, cause);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new RedisSystemException(String.format("Value for key '%s' could not be loaded using '%s'.", key, valueLoader), cause);
        }

        static {
            isSpring43 = ClassUtils.isPresent((String)"org.springframework.cache.Cache$ValueRetrievalException", (ClassLoader)ClassUtils.getDefaultClassLoader());
        }
    }

    static class RedisWriteThroughCallback
    extends AbstractRedisCacheCallback<byte[]> {
        public RedisWriteThroughCallback(BinaryRedisCacheElement element, RedisCacheMetadata metadata) {
            super(element, metadata);
        }

        @Override
        public byte[] doInRedis(BinaryRedisCacheElement element, RedisConnection connection) throws DataAccessException {
            try {
                byte[] value;
                block10: {
                    this.lock(connection);
                    try {
                        value = connection.get(element.getKeyBytes());
                        if (value == null) break block10;
                        byte[] byArray = value;
                        return byArray;
                    }
                    catch (RuntimeException e) {
                        if (!RedisCache.isClusterConnection(connection)) {
                            connection.discard();
                        }
                        throw e;
                    }
                }
                if (!RedisCache.isClusterConnection(connection)) {
                    connection.watch(new byte[][]{element.getKeyBytes()});
                    connection.multi();
                }
                value = element.get();
                connection.set(element.getKeyBytes(), value);
                this.processKeyExpiration(element, connection);
                this.maintainKnownKeys(element, connection);
                if (!RedisCache.isClusterConnection(connection)) {
                    connection.exec();
                }
                byte[] byArray = value;
                return byArray;
            }
            finally {
                this.unlock(connection);
            }
        }
    }

    static class RedisCachePutIfAbsentCallback
    extends AbstractRedisCacheCallback<byte[]> {
        public RedisCachePutIfAbsentCallback(BinaryRedisCacheElement element, RedisCacheMetadata metadata) {
            super(element, metadata);
        }

        @Override
        public byte[] doInRedis(BinaryRedisCacheElement element, RedisConnection connection) throws DataAccessException {
            this.waitForLock(connection);
            byte[] resultValue = this.put(element, connection);
            if (ObjectUtils.nullSafeEquals((Object)element.get(), (Object)resultValue)) {
                this.processKeyExpiration(element, connection);
                this.maintainKnownKeys(element, connection);
            }
            return resultValue;
        }

        private byte[] put(BinaryRedisCacheElement element, RedisConnection connection) {
            boolean valueWasSet = connection.setNX(element.getKeyBytes(), element.get());
            return valueWasSet ? null : connection.get(element.getKeyBytes());
        }
    }

    static class RedisCachePutCallback
    extends AbstractRedisCacheCallback<Void> {
        public RedisCachePutCallback(BinaryRedisCacheElement element, RedisCacheMetadata metadata) {
            super(element, metadata);
        }

        @Override
        public Void doInRedis(BinaryRedisCacheElement element, RedisConnection connection) throws DataAccessException {
            if (!RedisCache.isClusterConnection(connection)) {
                connection.multi();
            }
            connection.set(element.getKeyBytes(), element.get());
            this.processKeyExpiration(element, connection);
            this.maintainKnownKeys(element, connection);
            if (!RedisCache.isClusterConnection(connection)) {
                connection.exec();
            }
            return null;
        }
    }

    static class RedisCacheEvictCallback
    extends AbstractRedisCacheCallback<Void> {
        public RedisCacheEvictCallback(BinaryRedisCacheElement element, RedisCacheMetadata metadata) {
            super(element, metadata);
        }

        @Override
        public Void doInRedis(BinaryRedisCacheElement element, RedisConnection connection) throws DataAccessException {
            connection.del(new byte[][]{element.getKeyBytes()});
            this.cleanKnownKeys(element, connection);
            return null;
        }
    }

    static class RedisCacheCleanByPrefixCallback
    extends LockingRedisCacheCallback<Void> {
        private static final byte[] REMOVE_KEYS_BY_PATTERN_LUA = new StringRedisSerializer().serialize("local keys = redis.call('KEYS', ARGV[1]); local keysCount = table.getn(keys); if(keysCount > 0) then for _, key in ipairs(keys) do redis.call('del', key); end; end; return keysCount;");
        private static final byte[] WILD_CARD = new StringRedisSerializer().serialize("*");
        private final RedisCacheMetadata metadata;

        public RedisCacheCleanByPrefixCallback(RedisCacheMetadata metadata) {
            super(metadata);
            this.metadata = metadata;
        }

        @Override
        public Void doInLock(RedisConnection connection) throws DataAccessException {
            byte[] prefixToUse = Arrays.copyOf(this.metadata.getKeyPrefix(), this.metadata.getKeyPrefix().length + WILD_CARD.length);
            System.arraycopy(WILD_CARD, 0, prefixToUse, this.metadata.getKeyPrefix().length, WILD_CARD.length);
            if (RedisCache.isClusterConnection(connection)) {
                Set<byte[]> keys = connection.keys(prefixToUse);
                if (!keys.isEmpty()) {
                    connection.del((byte[][])keys.toArray((T[])new byte[keys.size()][]));
                }
            } else {
                connection.eval(REMOVE_KEYS_BY_PATTERN_LUA, ReturnType.INTEGER, 0, new byte[][]{prefixToUse});
            }
            return null;
        }
    }

    static class RedisCacheCleanByKeysCallback
    extends LockingRedisCacheCallback<Void> {
        private static final int PAGE_SIZE = 128;
        private final RedisCacheMetadata metadata;

        RedisCacheCleanByKeysCallback(RedisCacheMetadata metadata) {
            super(metadata);
            this.metadata = metadata;
        }

        @Override
        public Void doInLock(RedisConnection connection) {
            int offset = 0;
            boolean finished = false;
            do {
                Set<byte[]> keys;
                finished = (keys = connection.zRange(this.metadata.getSetOfKnownKeysKey(), offset * 128, (offset + 1) * 128 - 1)).size() < 128;
                ++offset;
                if (keys.isEmpty()) continue;
                connection.del((byte[][])keys.toArray((T[])new byte[keys.size()][]));
            } while (!finished);
            connection.del(new byte[][]{this.metadata.getSetOfKnownKeysKey()});
            return null;
        }
    }

    static abstract class LockingRedisCacheCallback<T>
    implements RedisCallback<T> {
        private final RedisCacheMetadata metadata;

        public LockingRedisCacheCallback(RedisCacheMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public T doInRedis(RedisConnection connection) throws DataAccessException {
            T t;
            if (connection.exists(this.metadata.getCacheLockKey()).booleanValue()) {
                return null;
            }
            try {
                connection.set(this.metadata.getCacheLockKey(), this.metadata.getCacheLockKey());
                t = this.doInLock(connection);
            }
            catch (Throwable throwable) {
                connection.del(new byte[][]{this.metadata.getCacheLockKey()});
                throw throwable;
            }
            connection.del(new byte[][]{this.metadata.getCacheLockKey()});
            return t;
        }

        public abstract T doInLock(RedisConnection var1);
    }

    static abstract class AbstractRedisCacheCallback<T>
    implements RedisCallback<T> {
        private long WAIT_FOR_LOCK_TIMEOUT = 300L;
        private final BinaryRedisCacheElement element;
        private final RedisCacheMetadata cacheMetadata;

        public AbstractRedisCacheCallback(BinaryRedisCacheElement element, RedisCacheMetadata metadata) {
            this.element = element;
            this.cacheMetadata = metadata;
        }

        @Override
        public T doInRedis(RedisConnection connection) throws DataAccessException {
            this.waitForLock(connection);
            return this.doInRedis(this.element, connection);
        }

        public abstract T doInRedis(BinaryRedisCacheElement var1, RedisConnection var2) throws DataAccessException;

        protected void processKeyExpiration(RedisCacheElement element, RedisConnection connection) {
            if (!element.isEternal()) {
                connection.expire(element.getKeyBytes(), element.getTimeToLive());
            }
        }

        protected void maintainKnownKeys(RedisCacheElement element, RedisConnection connection) {
            if (!element.hasKeyPrefix()) {
                connection.zAdd(this.cacheMetadata.getSetOfKnownKeysKey(), 0.0, element.getKeyBytes());
                if (!element.isEternal()) {
                    connection.expire(this.cacheMetadata.getSetOfKnownKeysKey(), element.getTimeToLive());
                }
            }
        }

        protected void cleanKnownKeys(RedisCacheElement element, RedisConnection connection) {
            if (!element.hasKeyPrefix()) {
                connection.zRem(this.cacheMetadata.getSetOfKnownKeysKey(), new byte[][]{element.getKeyBytes()});
            }
        }

        protected boolean waitForLock(RedisConnection connection) {
            boolean retry;
            boolean foundLock = false;
            do {
                retry = false;
                if (!connection.exists(this.cacheMetadata.getCacheLockKey()).booleanValue()) continue;
                foundLock = true;
                try {
                    Thread.sleep(this.WAIT_FOR_LOCK_TIMEOUT);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                retry = true;
            } while (retry);
            return foundLock;
        }

        protected void lock(RedisConnection connection) {
            this.waitForLock(connection);
            connection.set(this.cacheMetadata.getCacheLockKey(), "locked".getBytes());
        }

        protected void unlock(RedisConnection connection) {
            connection.del(new byte[][]{this.cacheMetadata.getCacheLockKey()});
        }
    }

    static class BinaryRedisCacheElement
    extends RedisCacheElement {
        private byte[] keyBytes;
        private byte[] valueBytes;
        private RedisCacheElement element;
        private boolean lazyLoad;
        private CacheValueAccessor accessor;

        public BinaryRedisCacheElement(RedisCacheElement element, CacheValueAccessor accessor) {
            super(element.getKey(), element.get());
            this.element = element;
            this.keyBytes = element.getKeyBytes();
            this.accessor = accessor;
            this.lazyLoad = element.get() instanceof Callable;
            this.valueBytes = this.lazyLoad ? null : accessor.convertToBytesIfNecessary(element.get());
        }

        @Override
        public byte[] getKeyBytes() {
            return this.keyBytes;
        }

        @Override
        public long getTimeToLive() {
            return this.element.getTimeToLive();
        }

        @Override
        public boolean hasKeyPrefix() {
            return this.element.hasKeyPrefix();
        }

        @Override
        public boolean isEternal() {
            return this.element.isEternal();
        }

        @Override
        public RedisCacheElement expireAfter(long seconds) {
            return this.element.expireAfter(seconds);
        }

        public byte[] get() {
            if (this.lazyLoad && this.valueBytes == null) {
                try {
                    this.valueBytes = this.accessor.convertToBytesIfNecessary(((Callable)this.element.get()).call());
                }
                catch (Exception e) {
                    throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e.getMessage(), e);
                }
            }
            return this.valueBytes;
        }
    }

    static class CacheValueAccessor {
        private final RedisSerializer valueSerializer;

        CacheValueAccessor(RedisSerializer valueRedisSerializer) {
            this.valueSerializer = valueRedisSerializer;
        }

        byte[] convertToBytesIfNecessary(Object value) {
            if (value == null) {
                return new byte[0];
            }
            if (this.valueSerializer == null && value instanceof byte[]) {
                return (byte[])value;
            }
            return this.valueSerializer.serialize(value);
        }

        Object deserializeIfNecessary(byte[] value) {
            if (this.valueSerializer != null) {
                return this.valueSerializer.deserialize(value);
            }
            return value;
        }
    }

    static class RedisCacheMetadata {
        private final String cacheName;
        private final byte[] keyPrefix;
        private final byte[] setOfKnownKeys;
        private final byte[] cacheLockName;
        private long defaultExpiration = 0L;

        public RedisCacheMetadata(String cacheName, byte[] keyPrefix) {
            Assert.hasText((String)cacheName, (String)"CacheName must not be null or empty!");
            this.cacheName = cacheName;
            this.keyPrefix = keyPrefix;
            StringRedisSerializer stringSerializer = new StringRedisSerializer();
            this.setOfKnownKeys = this.usesKeyPrefix() ? new byte[]{} : stringSerializer.serialize(cacheName + "~keys");
            this.cacheLockName = stringSerializer.serialize(cacheName + "~lock");
        }

        public boolean usesKeyPrefix() {
            return this.keyPrefix != null && this.keyPrefix.length > 0;
        }

        public byte[] getKeyPrefix() {
            return this.keyPrefix;
        }

        public byte[] getSetOfKnownKeysKey() {
            return this.setOfKnownKeys;
        }

        public byte[] getCacheLockKey() {
            return this.cacheLockName;
        }

        public String getCacheName() {
            return this.cacheName;
        }

        public void setDefaultExpiration(long seconds) {
            this.defaultExpiration = seconds;
        }

        public long getDefaultExpiration() {
            return this.defaultExpiration;
        }
    }
}

