/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Optional;
import org.apiguardian.api.API;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.schema.Relationship;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
public interface RelationshipDescription {
    public static final String NAME_OF_RELATIONSHIP = "__relationship__";
    public static final String NAME_OF_RELATIONSHIP_TYPE = "__relationshipType__";

    public String getType();

    public boolean isDynamic();

    public NodeDescription<?> getSource();

    public NodeDescription<?> getTarget();

    public String getFieldName();

    public Relationship.Direction getDirection();

    @Nullable
    public NodeDescription<?> getRelationshipPropertiesEntity();

    public boolean hasRelationshipProperties();

    default public boolean hasInternalIdProperty() {
        return this.hasRelationshipProperties() && Optional.ofNullable(this.getRelationshipPropertiesEntity().getIdDescription()).filter(IdDescription::isInternallyGeneratedId).isPresent();
    }

    default public boolean isOutgoing() {
        return Relationship.Direction.OUTGOING.equals((Object)this.getDirection());
    }

    default public boolean isIncoming() {
        return Relationship.Direction.INCOMING.equals((Object)this.getDirection());
    }

    @NonNull
    default public String generateRelatedNodesCollectionName(NodeDescription<?> mostAbstractNodeDescription) {
        return this.getSource().getMostAbstractParentLabel(mostAbstractNodeDescription) + "_" + this.getType() + "_" + this.getTarget().getPrimaryLabel() + "_" + this.isOutgoing();
    }

    public void setRelationshipObverse(RelationshipDescription var1);

    public RelationshipDescription getRelationshipObverse();

    public boolean hasRelationshipObverse();

    public boolean cascadeUpdates();
}

