/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Objects;
import org.apiguardian.api.API;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.STABLE, since="6.2")
public final class UserSelection {
    private static final UserSelection CONNECTED_USER = new UserSelection(null);
    @Nullable
    private final String value;

    public static UserSelection connectedUser() {
        return CONNECTED_USER;
    }

    public static UserSelection impersonate(String value) {
        Assert.hasText((String)value, (String)"Cannot impersonate user without username");
        return new UserSelection(value);
    }

    private UserSelection(@Nullable String value) {
        this.value = value;
    }

    @Nullable
    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSelection that = (UserSelection)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

