/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import com.querydsl.core.types.Predicate;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.FluentFindOperation;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.FluentQuerySupport;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.2")
final class FetchableFluentQueryByPredicate<S, R>
extends FluentQuerySupport<R>
implements FluentQuery.FetchableFluentQuery<R> {
    private final Predicate predicate;
    private final Neo4jPersistentEntity<S> metaData;
    private final FluentFindOperation findOperation;
    private final Function<Predicate, Long> countOperation;
    private final Function<Predicate, Boolean> existsOperation;

    FetchableFluentQueryByPredicate(Predicate predicate, Neo4jPersistentEntity<S> metaData, Class<R> resultType, FluentFindOperation findOperation, Function<Predicate, Long> countOperation, Function<Predicate, Boolean> existsOperation) {
        this(predicate, metaData, resultType, findOperation, countOperation, existsOperation, Sort.unsorted(), null);
    }

    FetchableFluentQueryByPredicate(Predicate predicate, Neo4jPersistentEntity<S> metaData, Class<R> resultType, FluentFindOperation findOperation, Function<Predicate, Long> countOperation, Function<Predicate, Boolean> existsOperation, Sort sort, @Nullable Collection<String> properties) {
        super(resultType, sort, properties);
        this.predicate = predicate;
        this.metaData = metaData;
        this.findOperation = findOperation;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
    }

    public FluentQuery.FetchableFluentQuery<R> sortBy(Sort sort) {
        return new FetchableFluentQueryByPredicate<S, R>(this.predicate, this.metaData, this.resultType, this.findOperation, this.countOperation, this.existsOperation, this.sort.and(sort), this.properties);
    }

    public <NR> FluentQuery.FetchableFluentQuery<NR> as(Class<NR> resultType) {
        return new FetchableFluentQueryByPredicate<S, NR>(this.predicate, this.metaData, resultType, this.findOperation, this.countOperation, this.existsOperation);
    }

    public FluentQuery.FetchableFluentQuery<R> project(Collection<String> properties) {
        return new FetchableFluentQueryByPredicate<S, R>(this.predicate, this.metaData, this.resultType, this.findOperation, this.countOperation, this.existsOperation, this.sort, this.mergeProperties(properties));
    }

    public R oneValue() {
        return this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forCondition(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), null, CypherAdapterUtils.toSortItems(this.metaData, this.sort), this.createIncludedFieldsPredicate())).oneValue();
    }

    public R firstValue() {
        List<R> all = this.all();
        return all.isEmpty() ? null : (R)all.get(0);
    }

    public List<R> all() {
        return this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forCondition(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), null, CypherAdapterUtils.toSortItems(this.metaData, this.sort), this.createIncludedFieldsPredicate())).all();
    }

    public Page<R> page(Pageable pageable) {
        List page = this.findOperation.find(this.metaData.getType()).as(this.resultType).matching(QueryFragmentsAndParameters.forCondition(this.metaData, Cypher.adapt((Object)this.predicate).asCondition(), pageable, null, this.createIncludedFieldsPredicate())).all();
        LongSupplier totalCountSupplier = this::count;
        return PageableExecutionUtils.getPage(page, (Pageable)pageable, (LongSupplier)totalCountSupplier);
    }

    public Stream<R> stream() {
        return this.all().stream();
    }

    public long count() {
        return this.countOperation.apply(this.predicate);
    }

    public boolean exists() {
        return this.existsOperation.apply(this.predicate);
    }
}

