/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Statement;
import org.springframework.data.neo4j.core.TemplateSupport;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.lang.Nullable;

@API(status=API.Status.STABLE, since="6.1")
public interface FluentFindOperation {
    public <T> ExecutableFind<T> find(Class<T> var1);

    public static interface ExecutableFind<T>
    extends FindWithProjection<T> {
    }

    public static interface FindWithProjection<T>
    extends FindWithQuery<T> {
        public <R> FindWithQuery<R> as(Class<R> var1);
    }

    public static interface FindWithQuery<T>
    extends TerminatingFindWithoutQuery<T> {
        public TerminatingFind<T> matching(String var1, @Nullable Map<String, Object> var2);

        public TerminatingFind<T> matching(QueryFragmentsAndParameters var1);

        default public TerminatingFind<T> matching(String query) {
            return this.matching(query, Collections.emptyMap());
        }

        default public TerminatingFind<T> matching(Statement statement, @Nullable Map<String, Object> parameter) {
            return this.matching(statement.getCypher(), TemplateSupport.mergeParameters(statement, parameter));
        }

        default public TerminatingFind<T> matching(Statement statement) {
            return this.matching(statement, Collections.emptyMap());
        }
    }

    public static interface TerminatingFind<T>
    extends TerminatingFindWithoutQuery<T> {
        default public Optional<T> one() {
            return Optional.ofNullable(this.oneValue());
        }

        @Nullable
        public T oneValue();
    }

    public static interface TerminatingFindWithoutQuery<T> {
        public List<T> all();
    }
}

