/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.bookmark;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.springframework.data.neo4j.bookmark.BookmarkManager;

public class CaffeineBookmarkManager
implements BookmarkManager {
    private final Cache<String, String> cache;

    public CaffeineBookmarkManager() {
        this.cache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    }

    public CaffeineBookmarkManager(Cache<String, String> cache) {
        this.cache = cache;
    }

    @Override
    public Collection<String> getBookmarks() {
        return new HashSet<String>(this.cache.asMap().values());
    }

    @Override
    public void storeBookmark(String bookmark, Collection<String> previous) {
        this.cache.invalidateAll(previous);
        this.cache.put((Object)bookmark, (Object)bookmark);
    }
}

