/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.repository.MongoRepository;
import org.springframework.data.mongodb.repository.aot.AotMongoRepositoryPostProcessor;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.w3c.dom.Element;

public class MongoRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    private static final String MONGO_TEMPLATE_REF = "mongo-template-ref";
    private static final String CREATE_QUERY_INDEXES = "create-query-indexes";

    public String getModuleName() {
        return "MongoDB";
    }

    public String getModulePrefix() {
        return "mongo";
    }

    public String getRepositoryFactoryBeanClassName() {
        return MongoRepositoryFactoryBean.class.getName();
    }

    public String getModuleIdentifier() {
        return this.getModulePrefix();
    }

    public Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Document.class);
    }

    public Class<? extends BeanRegistrationAotProcessor> getRepositoryAotProcessor() {
        return AotMongoRepositoryPostProcessor.class;
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(MongoRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)MONGO_TEMPLATE_REF, (String)"mongoOperations");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)builder, (Element)element, (String)CREATE_QUERY_INDEXES, (String)"createIndexesForQueryMethods");
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("mongoOperations", attributes.getString("mongoTemplateRef"));
        builder.addPropertyValue("createIndexesForQueryMethods", (Object)attributes.getBoolean("createIndexesForQueryMethods"));
    }

    protected boolean useRepositoryConfiguration(RepositoryMetadata metadata) {
        return !metadata.isReactiveRepository();
    }
}

