/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.spel;

import java.util.Set;
import org.springframework.data.mongodb.core.spel.ExpressionNode;
import org.springframework.data.mongodb.core.spel.OperatorNode;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.BooleanLiteral;
import org.springframework.expression.spel.ast.FloatLiteral;
import org.springframework.expression.spel.ast.IntLiteral;
import org.springframework.expression.spel.ast.Literal;
import org.springframework.expression.spel.ast.LongLiteral;
import org.springframework.expression.spel.ast.NullLiteral;
import org.springframework.expression.spel.ast.RealLiteral;
import org.springframework.expression.spel.ast.StringLiteral;
import org.springframework.lang.Nullable;

public class LiteralNode
extends ExpressionNode {
    private static final Set<Class<?>> SUPPORTED_LITERAL_TYPES = Set.of(BooleanLiteral.class, FloatLiteral.class, IntLiteral.class, LongLiteral.class, NullLiteral.class, RealLiteral.class, StringLiteral.class);
    private final Literal literal;

    LiteralNode(Literal node, ExpressionState state) {
        super((SpelNode)node, state);
        this.literal = node;
    }

    public boolean isUnaryMinus(@Nullable ExpressionNode parent) {
        if (!(parent instanceof OperatorNode)) {
            return false;
        }
        OperatorNode operatorNode = (OperatorNode)parent;
        return operatorNode.isUnaryMinus();
    }

    @Override
    public boolean isLiteral() {
        return SUPPORTED_LITERAL_TYPES.contains(this.literal.getClass());
    }
}

