/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Iterator;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.RelaxedTypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class TypeBasedAggregationOperationContext
implements AggregationOperationContext {
    private final Class<?> type;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final QueryMapper mapper;

    public TypeBasedAggregationOperationContext(Class<?> type, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, QueryMapper mapper) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull(mappingContext, (String)"MappingContext must not be null!");
        Assert.notNull((Object)mapper, (String)"QueryMapper must not be null!");
        this.type = type;
        this.mappingContext = mappingContext;
        this.mapper = mapper;
    }

    @Override
    public Document getMappedObject(Document document) {
        return this.getMappedObject(document, this.type);
    }

    @Override
    public Document getMappedObject(Document document, @Nullable Class<?> type) {
        return this.mapper.getMappedObject((Bson)document, type != null ? (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type) : null);
    }

    @Override
    public ExposedFields.FieldReference getReference(Field field) {
        return this.getReferenceFor(field);
    }

    @Override
    public ExposedFields.FieldReference getReference(String name) {
        return this.getReferenceFor(Fields.field(name));
    }

    @Override
    public Fields getFields(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(type);
        if (entity == null) {
            return AggregationOperationContext.super.getFields(type);
        }
        ArrayList<String> fields = new ArrayList<String>();
        Iterator iterator = entity.iterator();
        while (iterator.hasNext()) {
            MongoPersistentProperty property = (MongoPersistentProperty)iterator.next();
            fields.add(property.getName());
        }
        return Fields.fields(fields.toArray(new String[0]));
    }

    @Override
    public AggregationOperationContext continueOnMissingFieldReference() {
        return new RelaxedTypeBasedAggregationOperationContext(this.type, this.mappingContext, this.mapper);
    }

    protected ExposedFields.FieldReference getReferenceFor(Field field) {
        PersistentPropertyPath propertyPath = this.mappingContext.getPersistentPropertyPath(field.getTarget(), this.type);
        Field mappedField = Fields.field(field.getName(), propertyPath.toDotPath((Converter)MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE));
        return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(mappedField, true));
    }
}

