/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.Collection;
import org.bson.Document;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.util.Assert;

class NestedDelegatingExpressionAggregationOperationContext
implements AggregationOperationContext {
    private final AggregationOperationContext delegate;
    private final Collection<Field> inners;

    NestedDelegatingExpressionAggregationOperationContext(AggregationOperationContext referenceContext, Collection<Field> inners) {
        Assert.notNull((Object)referenceContext, (String)"Reference context must not be null!");
        this.delegate = referenceContext;
        this.inners = inners;
    }

    @Override
    public Document getMappedObject(Document document) {
        return this.delegate.getMappedObject(document);
    }

    @Override
    public ExposedFields.FieldReference getReference(Field field) {
        ExposedFields.FieldReference reference = this.delegate.getReference(field);
        return this.isInnerVariableReference(field) ? new ExposedFields.ExpressionFieldReference(this.delegate.getReference(field)) : reference;
    }

    private boolean isInnerVariableReference(Field field) {
        if (this.inners.isEmpty()) {
            return false;
        }
        for (Field inner : this.inners) {
            if (!inner.getName().equals(field.getName()) && (!field.getTarget().contains(".") || !field.getTarget().startsWith(inner.getName()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExposedFields.FieldReference getReference(String name) {
        return new ExposedFields.ExpressionFieldReference(this.delegate.getReference(name));
    }
}

