/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.MongoRegexCreator;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.repository.core.support.ExampleMatcherAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class MongoExampleMapper {
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final MongoConverter converter;
    private final Map<ExampleMatcher.StringMatcher, Part.Type> stringMatcherPartMapping = new HashMap<ExampleMatcher.StringMatcher, Part.Type>();

    public MongoExampleMapper(MongoConverter converter) {
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
        this.stringMatcherPartMapping.put(ExampleMatcher.StringMatcher.EXACT, Part.Type.SIMPLE_PROPERTY);
        this.stringMatcherPartMapping.put(ExampleMatcher.StringMatcher.CONTAINING, Part.Type.CONTAINING);
        this.stringMatcherPartMapping.put(ExampleMatcher.StringMatcher.STARTING, Part.Type.STARTING_WITH);
        this.stringMatcherPartMapping.put(ExampleMatcher.StringMatcher.ENDING, Part.Type.ENDING_WITH);
        this.stringMatcherPartMapping.put(ExampleMatcher.StringMatcher.REGEX, Part.Type.REGEX);
    }

    public DBObject getMappedExample(Example<?> example) {
        Assert.notNull(example, (String)"Example must not be null!");
        return this.getMappedExample(example, (MongoPersistentEntity)this.mappingContext.getPersistentEntity(example.getProbeType()));
    }

    public DBObject getMappedExample(Example<?> example, MongoPersistentEntity<?> entity) {
        Assert.notNull(example, (String)"Example must not be null!");
        Assert.notNull(entity, (String)"MongoPersistentEntity must not be null!");
        DBObject reference = (DBObject)this.converter.convertToMongoType(example.getProbe());
        if (entity.hasIdProperty() && ClassUtils.isAssignable((Class)entity.getType(), (Class)example.getProbeType()) && entity.getIdentifierAccessor(example.getProbe()).getIdentifier() == null) {
            reference.removeField(((MongoPersistentProperty)entity.getIdProperty()).getFieldName());
        }
        ExampleMatcherAccessor matcherAccessor = new ExampleMatcherAccessor(example.getMatcher());
        this.applyPropertySpecs("", reference, example.getProbeType(), matcherAccessor);
        DBObject flattened = ObjectUtils.nullSafeEquals((Object)ExampleMatcher.NullHandler.INCLUDE, (Object)matcherAccessor.getNullHandler()) ? reference : new BasicDBObject(SerializationUtils.flattenMap(reference));
        DBObject result = example.getMatcher().isAllMatching() ? flattened : MongoExampleMapper.orConcatenate(flattened);
        return this.updateTypeRestrictions(result, example);
    }

    private void applyPropertySpecs(String path, DBObject source, Class<?> probeType, ExampleMatcherAccessor exampleSpecAccessor) {
        if (!(source instanceof BasicDBObject)) {
            return;
        }
        Iterator iter = ((BasicDBObject)source).entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String propertyPath = StringUtils.hasText((String)path) ? path + "." + (String)entry.getKey() : (String)entry.getKey();
            String mappedPropertyPath = this.getMappedPropertyPath(propertyPath, probeType);
            if (MongoExampleMapper.isEmptyIdProperty(entry)) {
                iter.remove();
                continue;
            }
            if (exampleSpecAccessor.isIgnoredPath(propertyPath) || exampleSpecAccessor.isIgnoredPath(mappedPropertyPath)) {
                iter.remove();
                continue;
            }
            ExampleMatcher.StringMatcher stringMatcher = exampleSpecAccessor.getDefaultStringMatcher();
            Object value = entry.getValue();
            boolean ignoreCase = exampleSpecAccessor.isIgnoreCaseEnabled();
            if (exampleSpecAccessor.hasPropertySpecifiers()) {
                mappedPropertyPath = exampleSpecAccessor.hasPropertySpecifier(propertyPath) ? propertyPath : this.getMappedPropertyPath(propertyPath, probeType);
                stringMatcher = exampleSpecAccessor.getStringMatcherForPath(mappedPropertyPath);
                ignoreCase = exampleSpecAccessor.isIgnoreCaseForPath(mappedPropertyPath);
            }
            if (exampleSpecAccessor.hasPropertySpecifier(mappedPropertyPath)) {
                ExampleMatcher.PropertyValueTransformer valueTransformer = exampleSpecAccessor.getValueTransformerForPath(mappedPropertyPath);
                value = valueTransformer.convert(value);
                if (value == null) {
                    iter.remove();
                    continue;
                }
                entry.setValue(value);
            }
            if (entry.getValue() instanceof String) {
                this.applyStringMatcher(entry, stringMatcher, ignoreCase);
                continue;
            }
            if (!(entry.getValue() instanceof BasicDBObject)) continue;
            this.applyPropertySpecs(propertyPath, (DBObject)((BasicDBObject)entry.getValue()), probeType, exampleSpecAccessor);
        }
    }

    private String getMappedPropertyPath(String path, Class<?> probeType) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(probeType);
        Iterator<String> parts = Arrays.asList(path.split("\\.")).iterator();
        final Stack stack = new Stack();
        ArrayList<String> resultParts = new ArrayList<String>();
        while (parts.hasNext()) {
            final String part = parts.next();
            MongoPersistentProperty prop = (MongoPersistentProperty)entity.getPersistentProperty(part);
            if (prop == null) {
                entity.doWithProperties((PropertyHandler)new PropertyHandler<MongoPersistentProperty>(){

                    public void doWithPersistentProperty(MongoPersistentProperty property) {
                        if (property.getFieldName().equals(part)) {
                            stack.push(property);
                        }
                    }
                });
                if (stack.isEmpty()) {
                    return "";
                }
                prop = (MongoPersistentProperty)stack.pop();
            }
            resultParts.add(prop.getName());
            if (!prop.isEntity() || !this.mappingContext.hasPersistentEntityFor(prop.getActualType())) break;
            entity = (MongoPersistentEntity)this.mappingContext.getPersistentEntity(prop.getActualType());
        }
        return StringUtils.collectionToDelimitedString(resultParts, (String)".");
    }

    private DBObject updateTypeRestrictions(DBObject query, Example example) {
        BasicDBObject result = new BasicDBObject();
        if (this.isTypeRestricting(example.getMatcher())) {
            result.putAll((BSONObject)query);
            this.converter.getTypeMapper().writeTypeRestrictions((DBObject)result, this.getTypesToMatch(example));
            return result;
        }
        for (String key : query.keySet()) {
            if (this.converter.getTypeMapper().isTypeKey(key)) continue;
            result.put(key, query.get(key));
        }
        return result;
    }

    private boolean isTypeRestricting(ExampleMatcher matcher) {
        if (matcher.getIgnoredPaths().isEmpty()) {
            return true;
        }
        for (String path : matcher.getIgnoredPaths()) {
            if (!this.converter.getTypeMapper().isTypeKey(path)) continue;
            return false;
        }
        return true;
    }

    private Set<Class<?>> getTypesToMatch(Example<?> example) {
        HashSet types = new HashSet();
        for (TypeInformation reference : this.mappingContext.getManagedTypes()) {
            if (!example.getProbeType().isAssignableFrom(reference.getType())) continue;
            types.add(reference.getType());
        }
        return types;
    }

    private static boolean isEmptyIdProperty(Map.Entry<String, Object> entry) {
        return entry.getKey().equals("_id") && entry.getValue() == null;
    }

    private void applyStringMatcher(Map.Entry<String, Object> entry, ExampleMatcher.StringMatcher stringMatcher, boolean ignoreCase) {
        BasicDBObject dbo = new BasicDBObject();
        if (ObjectUtils.nullSafeEquals((Object)ExampleMatcher.StringMatcher.DEFAULT, (Object)stringMatcher)) {
            if (ignoreCase) {
                dbo.put("$regex", (Object)Pattern.quote((String)entry.getValue()));
                entry.setValue(dbo);
            }
        } else {
            Part.Type type = this.stringMatcherPartMapping.get(stringMatcher);
            String expression = MongoRegexCreator.INSTANCE.toRegularExpression((String)entry.getValue(), type);
            dbo.put("$regex", (Object)expression);
            entry.setValue(dbo);
        }
        if (ignoreCase) {
            dbo.put("$options", (Object)"i");
        }
    }

    private static DBObject orConcatenate(DBObject source) {
        ArrayList<BasicDBObject> or = new ArrayList<BasicDBObject>(source.keySet().size());
        for (String key : source.keySet()) {
            or.add(new BasicDBObject(key, source.get(key)));
        }
        return new BasicDBObject("$or", or);
    }
}

