/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MapReduceCommand;
import java.lang.reflect.Method;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

final class ReflectiveMapReduceInvoker {
    private static final Method ADD_EXTRA_OPTION_METHOD = ReflectionUtils.findMethod(MapReduceCommand.class, (String)"addExtraOption", (Class[])new Class[]{String.class, Object.class});

    private ReflectiveMapReduceInvoker() {
    }

    public static void addExtraOption(MapReduceCommand cmd, String key, Object value) {
        if (MongoClientVersion.isMongo3Driver()) {
            return;
        }
        Assert.notNull((Object)cmd, (String)"MapReduceCommand must not be null!");
        ReflectionUtils.invokeMethod((Method)ADD_EXTRA_OPTION_METHOD, (Object)cmd, (Object[])new Object[]{key, value});
    }
}

