/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.util.List;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jdbc.repository.query.JdbcQueryExecution;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractJdbcQuery
implements RepositoryQuery {
    private final JdbcQueryMethod queryMethod;
    private final NamedParameterJdbcOperations operations;

    AbstractJdbcQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, @Nullable RowMapper<?> defaultRowMapper) {
        Assert.notNull((Object)((Object)queryMethod), (String)"Query method must not be null!");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null!");
        if (!queryMethod.isModifyingQuery()) {
            Assert.notNull(defaultRowMapper, (String)"Mapper must not be null!");
        }
        this.queryMethod = queryMethod;
        this.operations = operations;
    }

    public JdbcQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected JdbcQueryExecution<?> getQueryExecution(JdbcQueryMethod queryMethod, @Nullable ResultSetExtractor<?> extractor, RowMapper<?> rowMapper) {
        if (queryMethod.isModifyingQuery()) {
            return this.createModifyingQueryExecutor();
        }
        if (queryMethod.isCollectionQuery() || queryMethod.isStreamQuery()) {
            return extractor != null ? this.getQueryExecution(extractor) : this.collectionQuery(rowMapper);
        }
        return extractor != null ? this.getQueryExecution(extractor) : this.singleObjectQuery(rowMapper);
    }

    private JdbcQueryExecution<Object> createModifyingQueryExecutor() {
        return (query, parameters) -> {
            int updatedCount = this.operations.update(query, parameters);
            Class returnedObjectType = this.queryMethod.getReturnedObjectType();
            return returnedObjectType == Boolean.TYPE || returnedObjectType == Boolean.class ? (Comparable<Boolean>)Boolean.valueOf(updatedCount != 0) : (Comparable<Boolean>)Integer.valueOf(updatedCount);
        };
    }

    private JdbcQueryExecution<Object> singleObjectQuery(RowMapper<?> rowMapper) {
        return (query, parameters) -> {
            try {
                return this.operations.queryForObject(query, parameters, rowMapper);
            }
            catch (EmptyResultDataAccessException e) {
                return null;
            }
        };
    }

    private <T> JdbcQueryExecution<List<T>> collectionQuery(RowMapper<T> rowMapper) {
        return this.getQueryExecution((ResultSetExtractor<T>)new RowMapperResultSetExtractor(rowMapper));
    }

    private <T> JdbcQueryExecution<T> getQueryExecution(ResultSetExtractor<T> resultSetExtractor) {
        return (query, parameters) -> this.operations.query(query, parameters, resultSetExtractor);
    }
}

