/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.geode.cache.execute.ResultSender;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class BatchingResultSender {
    private final int batchSize;
    private ResultSender<Object> resultSender;

    public BatchingResultSender(int batchSize, ResultSender<Object> resultSender) {
        Assert.notNull(resultSender, (String)"ResultSender must not be null");
        Assert.isTrue((batchSize >= 0 ? 1 : 0) != 0, (String)"batchSize must be greater than equal to 0");
        this.batchSize = batchSize;
        this.resultSender = resultSender;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public ResultSender<Object> getResultSender() {
        return this.resultSender;
    }

    protected boolean isBatchingDisabled() {
        return !this.isBatchingEnabled();
    }

    protected boolean isBatchingEnabled() {
        return this.getBatchSize() > 0;
    }

    protected boolean doNotSendChunks(boolean resultSetIsEmpty) {
        return resultSetIsEmpty || this.isBatchingDisabled();
    }

    public void sendResults(Iterable<?> result) {
        ResultSender<Object> resultSender = this.getResultSender();
        if (this.doNotSendChunks(!result.iterator().hasNext())) {
            resultSender.lastResult(result);
        } else {
            int batchSize = this.getBatchSize();
            ArrayList chunk = new ArrayList(batchSize);
            Iterator<?> it = result.iterator();
            while (it.hasNext()) {
                if (chunk.size() < batchSize) {
                    chunk.add(it.next());
                }
                if (chunk.size() != batchSize && it.hasNext()) continue;
                if (it.hasNext()) {
                    resultSender.sendResult(chunk);
                } else {
                    resultSender.lastResult(chunk);
                }
                chunk.clear();
            }
        }
    }

    public void sendArrayResults(Object result) {
        Assert.isTrue((boolean)ObjectUtils.isArray((Object)result), () -> String.format("Object must be an array; was [%s]", ObjectUtils.nullSafeClassName((Object)result)));
        int arrayLength = Array.getLength(result);
        ResultSender<Object> resultSender = this.getResultSender();
        if (this.doNotSendChunks(arrayLength == 0)) {
            resultSender.lastResult(result);
        } else {
            int batchSize = this.getBatchSize();
            for (int from = 0; from < arrayLength; from += batchSize) {
                int to = Math.min(arrayLength, from + batchSize);
                Object chunk = this.copyOfRange(result, from, to);
                if (to == arrayLength) {
                    resultSender.lastResult(chunk);
                    continue;
                }
                resultSender.sendResult(chunk);
            }
        }
    }

    private Object copyOfRange(Object result, int from, int to) {
        Class<?> resultType = result.getClass();
        if (boolean[].class.isAssignableFrom(resultType)) {
            return Arrays.copyOfRange((boolean[])result, from, to);
        }
        if (byte[].class.isAssignableFrom(resultType)) {
            return Arrays.copyOfRange((byte[])result, from, to);
        }
        if (short[].class.isAssignableFrom(resultType)) {
            return Arrays.copyOfRange((short[])result, from, to);
        }
        if (int[].class.isAssignableFrom(resultType)) {
            return Arrays.copyOfRange((int[])result, from, to);
        }
        if (long[].class.isAssignableFrom(resultType)) {
            return Arrays.copyOfRange((long[])result, from, to);
        }
        if (float[].class.isAssignableFrom(resultType)) {
            return Arrays.copyOfRange((float[])result, from, to);
        }
        if (double[].class.isAssignableFrom(resultType)) {
            return Arrays.copyOfRange((double[])result, from, to);
        }
        if (char[].class.isAssignableFrom(resultType)) {
            return Arrays.copyOfRange((char[])result, from, to);
        }
        return Arrays.copyOfRange((Object[])result, from, to);
    }
}

