/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Iterator;
import java.util.List;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParameter;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParameters;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReactiveWrappers;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Mono;

public class ReactiveElasticsearchQueryMethod
extends ElasticsearchQueryMethod {
    private static final TypeInformation<Page> PAGE_TYPE = TypeInformation.of(Page.class);
    private static final TypeInformation<Slice> SLICE_TYPE = TypeInformation.of(Slice.class);
    private final Lazy<Boolean> isCollectionQuery;

    public ReactiveElasticsearchQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory, MappingContext<? extends ElasticsearchPersistentEntity<?>, ElasticsearchPersistentProperty> mappingContext) {
        super(method, metadata, factory, mappingContext);
        if (ReflectionUtils.hasParameterOfType((Method)method, Pageable.class)) {
            boolean singleWrapperWithWrappedPageableResult;
            TypeInformation returnType = TypeInformation.fromReturnTypeOf((Method)method);
            boolean multiWrapper = ReactiveWrappers.isMultiValueType((Class)returnType.getType());
            boolean bl = singleWrapperWithWrappedPageableResult = ReactiveWrappers.isSingleValueType((Class)returnType.getType()) && (PAGE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()) || SLICE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()));
            if (singleWrapperWithWrappedPageableResult) {
                throw new InvalidDataAccessApiUsageException(String.format("'%s.%s' must not use sliced or paged execution. Please use Flux.buffer(size, skip).", ClassUtils.getShortName(method.getDeclaringClass()), method.getName()));
            }
            if (!multiWrapper) {
                throw new IllegalStateException(String.format("Method has to use a either multi-item reactive wrapper return type or a wrapped Page/Slice type. Offending method: %s", method));
            }
            if (ReflectionUtils.hasParameterOfType((Method)method, Sort.class)) {
                throw new IllegalStateException(String.format("Method must not have Pageable *and* Sort parameter. Use sorting capabilities on Pageable instead! Offending method: %s", method));
            }
        }
        this.isCollectionQuery = Lazy.of(() -> !this.isPageQuery() && !this.isSliceQuery() && ReactiveWrappers.isMultiValueType((Class)metadata.getReturnType(method).getType()) || super.isCollectionQuery());
    }

    @Override
    protected void verifyCountQueryTypes() {
        if (this.hasCountQueryAnnotation()) {
            TypeInformation returnType = TypeInformation.fromReturnTypeOf((Method)this.method);
            List typeArguments = returnType.getTypeArguments();
            if (!Mono.class.isAssignableFrom(returnType.getType()) || typeArguments.size() != 1 || ((TypeInformation)typeArguments.get(0)).getType() != Long.TYPE && !Long.class.isAssignableFrom(((TypeInformation)typeArguments.get(0)).getType())) {
                throw new InvalidDataAccessApiUsageException("count query methods must return a Mono<Long>");
            }
        }
    }

    public boolean hasReactiveWrapperParameter() {
        Iterator iterator = this.getParameters().iterator();
        while (iterator.hasNext()) {
            ElasticsearchParameter param = (ElasticsearchParameter)((Object)iterator.next());
            if (!ReactiveWrapperConverters.supports((Class)param.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean isCollectionQuery() {
        return (Boolean)this.isCollectionQuery.get();
    }

    public boolean isStreamQuery() {
        return true;
    }

    public ElasticsearchParameters getParameters() {
        return (ElasticsearchParameters)super.getParameters();
    }

    @Override
    protected boolean isAllowedGenericType(ParameterizedType methodGenericReturnType) {
        return super.isAllowedGenericType(methodGenericReturnType) || ReactiveWrappers.supports((Class)((Class)methodGenericReturnType.getRawType()));
    }
}

