/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.convert;

import java.time.temporal.TemporalAccessor;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.elasticsearch.core.convert.AbstractPropertyValueConverter;
import org.springframework.data.elasticsearch.core.convert.ConversionException;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchDateConverter;
import org.springframework.data.mapping.PersistentProperty;

public class TemporalPropertyValueConverter
extends AbstractPropertyValueConverter {
    private static final Log LOGGER = LogFactory.getLog(TemporalPropertyValueConverter.class);
    private final List<ElasticsearchDateConverter> dateConverters;

    public TemporalPropertyValueConverter(PersistentProperty<?> property, List<ElasticsearchDateConverter> dateConverters) {
        super(property);
        this.dateConverters = dateConverters;
    }

    @Override
    public Object read(Object value) {
        String s = value.toString();
        Class actualType = this.getProperty().getActualType();
        for (ElasticsearchDateConverter dateConverter : this.dateConverters) {
            try {
                return dateConverter.parse(s, actualType);
            }
            catch (Exception e) {
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace((Object)e.getMessage(), (Throwable)e);
            }
        }
        throw new ConversionException(String.format("Unable to convert value '%s' to %s for property '%s'", s, this.getProperty().getActualType().getTypeName(), this.getProperty().getName()));
    }

    @Override
    public Object write(Object value) {
        if (!TemporalAccessor.class.isAssignableFrom(value.getClass())) {
            return value.toString();
        }
        try {
            return this.dateConverters.get(0).format((TemporalAccessor)value);
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Unable to convert value '%s' of property '%s'", value, this.getProperty().getName()), e);
        }
    }
}

