/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.GeoDistanceType;
import co.elastic.clients.elasticsearch._types.GeoHashLocation;
import co.elastic.clients.elasticsearch._types.GeoShapeRelation;
import co.elastic.clients.elasticsearch._types.LatLonGeoLocation;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoBoundingBoxQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoDistanceQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.GeoShapeQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryBuilders;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.elasticsearch.core.convert.GeoConverters;
import org.springframework.data.elasticsearch.core.geo.GeoBox;
import org.springframework.data.elasticsearch.core.geo.GeoJson;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.util.Assert;

class CriteriaFilterProcessor {
    CriteriaFilterProcessor() {
    }

    public static Optional<Query> createQuery(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"criteria must not be null");
        ArrayList<Object> filterQueries = new ArrayList<Object>();
        for (Criteria chainedCriteria : criteria.getCriteriaChain()) {
            if (chainedCriteria.isOr()) {
                BoolQuery.Builder boolQueryBuilder = QueryBuilders.bool();
                CriteriaFilterProcessor.queriesForEntries(chainedCriteria).forEach(x$0 -> boolQueryBuilder.should(x$0, new Query[0]));
                filterQueries.add(new Query((QueryVariant)boolQueryBuilder.build()));
                continue;
            }
            if (chainedCriteria.isNegating()) {
                Collection<? extends Query> negatingFilters = CriteriaFilterProcessor.buildNegatingFilter(criteria.getField().getName(), criteria.getFilterCriteriaEntries());
                filterQueries.addAll(negatingFilters);
                continue;
            }
            filterQueries.addAll(CriteriaFilterProcessor.queriesForEntries(chainedCriteria));
        }
        if (filterQueries.isEmpty()) {
            return Optional.empty();
        }
        if (filterQueries.size() == 1) {
            return Optional.of((Query)filterQueries.get(0));
        }
        BoolQuery.Builder boolQueryBuilder = QueryBuilders.bool();
        filterQueries.forEach(x$0 -> boolQueryBuilder.must(x$0, new Query[0]));
        BoolQuery boolQuery = boolQueryBuilder.build();
        return Optional.of(new Query((QueryVariant)boolQuery));
    }

    private static Collection<? extends Query> buildNegatingFilter(String fieldName, Set<Criteria.CriteriaEntry> filterCriteriaEntries) {
        ArrayList negationFilters = new ArrayList();
        filterCriteriaEntries.forEach(criteriaEntry -> {
            Optional<Query> query = CriteriaFilterProcessor.queryFor(criteriaEntry.getKey(), criteriaEntry.getValue(), fieldName);
            if (query.isPresent()) {
                BoolQuery negatingFilter = QueryBuilders.bool().mustNot(query.get(), new Query[0]).build();
                negationFilters.add(new Query((QueryVariant)negatingFilter));
            }
        });
        return negationFilters;
    }

    private static Collection<? extends Query> queriesForEntries(Criteria criteria) {
        Assert.notNull((Object)criteria.getField(), (String)"criteria must have a field");
        String fieldName = criteria.getField().getName();
        Assert.notNull((Object)fieldName, (String)"Unknown field");
        return criteria.getFilterCriteriaEntries().stream().map(entry -> CriteriaFilterProcessor.queryFor(entry.getKey(), entry.getValue(), fieldName)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Optional<Query> queryFor(Criteria.OperationKey key, Object value, String fieldName) {
        ObjectBuilder<GeoDistanceQuery> queryBuilder = null;
        switch (key) {
            case WITHIN: {
                Assert.isTrue((boolean)(value instanceof Object[]), (String)"Value of a geo distance filter should be an array of two values.");
                queryBuilder = CriteriaFilterProcessor.withinQuery(fieldName, (Object[])value);
                break;
            }
            case BBOX: {
                Assert.isTrue((boolean)(value instanceof Object[]), (String)"Value of a boundedBy filter should be an array of one or two values.");
                queryBuilder = CriteriaFilterProcessor.boundingBoxQuery(fieldName, (Object[])value);
                break;
            }
            case GEO_INTERSECTS: {
                Assert.isTrue((boolean)(value instanceof GeoJson), (String)"value of a GEO_INTERSECTS filter must be a GeoJson object");
                queryBuilder = CriteriaFilterProcessor.geoJsonQuery(fieldName, (GeoJson)value, "intersects");
                break;
            }
            case GEO_IS_DISJOINT: {
                Assert.isTrue((boolean)(value instanceof GeoJson), (String)"value of a GEO_IS_DISJOINT filter must be a GeoJson object");
                queryBuilder = CriteriaFilterProcessor.geoJsonQuery(fieldName, (GeoJson)value, "disjoint");
                break;
            }
            case GEO_WITHIN: {
                Assert.isTrue((boolean)(value instanceof GeoJson), (String)"value of a GEO_WITHIN filter must be a GeoJson object");
                queryBuilder = CriteriaFilterProcessor.geoJsonQuery(fieldName, (GeoJson)value, "within");
                break;
            }
            case GEO_CONTAINS: {
                Assert.isTrue((boolean)(value instanceof GeoJson), (String)"value of a GEO_CONTAINS filter must be a GeoJson object");
                queryBuilder = CriteriaFilterProcessor.geoJsonQuery(fieldName, (GeoJson)value, "contains");
            }
        }
        return Optional.ofNullable(queryBuilder != null ? ((QueryVariant)queryBuilder.build())._toQuery() : null);
    }

    private static ObjectBuilder<GeoDistanceQuery> withinQuery(String fieldName, Object ... values) {
        Assert.noNullElements((Object[])values, (String)"Geo distance filter takes 2 not null elements array as parameter.");
        Assert.isTrue((values.length == 2 ? 1 : 0) != 0, (String)"Geo distance filter takes a 2-elements array as parameter.");
        Assert.isTrue((values[0] instanceof GeoPoint || values[0] instanceof String || values[0] instanceof Point ? 1 : 0) != 0, (String)"First element of a geo distance filter must be a GeoPoint, a Point or a text");
        Assert.isTrue((values[1] instanceof String || values[1] instanceof Distance ? 1 : 0) != 0, (String)"Second element of a geo distance filter must be a text or a Distance");
        String dist = values[1] instanceof Distance ? CriteriaFilterProcessor.extractDistanceString((Distance)values[1]) : (String)values[1];
        return QueryBuilders.geoDistance().field(fieldName).distance(dist).distanceType(GeoDistanceType.Plane).location(location -> {
            Object patt7244$temp = values[0];
            if (patt7244$temp instanceof GeoPoint) {
                GeoPoint loc = (GeoPoint)patt7244$temp;
                location.latlon(latlon -> latlon.lat(loc.getLat()).lon(loc.getLon()));
            } else if (values[0] instanceof Point) {
                loc = GeoPoint.fromPoint((Point)values[0]);
                location.latlon(arg_0 -> CriteriaFilterProcessor.lambda$withinQuery$5((GeoPoint)loc, arg_0));
            } else {
                loc = (String)values[0];
                if (((String)loc).contains(",")) {
                    String[] c = ((String)loc).split(",");
                    location.latlon(latlon -> latlon.lat(Double.parseDouble(c[0])).lon(Double.parseDouble(c[1])));
                } else {
                    location.geohash(arg_0 -> CriteriaFilterProcessor.lambda$withinQuery$7((String)loc, arg_0));
                }
            }
            return location;
        });
    }

    private static ObjectBuilder<GeoBoundingBoxQuery> boundingBoxQuery(String fieldName, Object ... values) {
        Assert.noNullElements((Object[])values, (String)"Geo boundedBy filter takes a not null element array as parameter.");
        GeoBoundingBoxQuery.Builder queryBuilder = QueryBuilders.geoBoundingBox().field(fieldName);
        if (values.length == 1) {
            CriteriaFilterProcessor.oneParameterBBox(queryBuilder, values[0]);
        } else if (values.length == 2) {
            CriteriaFilterProcessor.twoParameterBBox(queryBuilder, values);
        } else {
            throw new IllegalArgumentException("Geo distance filter takes a 1-elements array(GeoBox) or 2-elements array(GeoPoints or Strings(format lat,lon or geohash)).");
        }
        return queryBuilder;
    }

    private static void oneParameterBBox(GeoBoundingBoxQuery.Builder queryBuilder, Object value) {
        Assert.isTrue((value instanceof GeoBox || value instanceof Box ? 1 : 0) != 0, (String)"single-element of boundedBy filter must be type of GeoBox or Box");
        GeoBox geoBBox = value instanceof Box ? GeoBox.fromBox((Box)value) : (GeoBox)value;
        queryBuilder.boundingBox(bb -> bb.tlbr(tlbr -> tlbr.topLeft(glb -> glb.latlon(latlon -> latlon.lat(geoBBox.getTopLeft().getLat()).lon(geoBBox.getTopLeft().getLon()))).bottomRight(glb -> glb.latlon(latlon -> latlon.lat(geoBBox.getBottomRight().getLat()).lon(geoBBox.getBottomRight().getLon())))));
    }

    private static void twoParameterBBox(GeoBoundingBoxQuery.Builder queryBuilder, Object ... values) {
        Assert.isTrue((CriteriaFilterProcessor.allElementsAreOfType(values, GeoPoint.class) || CriteriaFilterProcessor.allElementsAreOfType(values, String.class) ? 1 : 0) != 0, (String)" both elements of boundedBy filter must be type of GeoPoint or text(format lat,lon or geohash)");
        Object object = values[0];
        if (object instanceof GeoPoint) {
            GeoPoint topLeft = (GeoPoint)object;
            GeoPoint bottomRight = (GeoPoint)values[1];
            queryBuilder.boundingBox(bb -> bb.tlbr(tlbr -> tlbr.topLeft(glb -> glb.latlon(latlon -> latlon.lat(topLeft.getLat()).lon(topLeft.getLon()))).bottomRight(glb -> glb.latlon(latlon -> latlon.lat(bottomRight.getLat()).lon(bottomRight.getLon())))));
        } else {
            String topLeft = (String)values[0];
            String bottomRight = (String)values[1];
            boolean isGeoHash = !topLeft.contains(",");
            queryBuilder.boundingBox(bb -> bb.tlbr(tlbr -> tlbr.topLeft(glb -> {
                if (isGeoHash) {
                    glb.geohash(gh -> gh.geohash(topLeft));
                } else {
                    glb.text(topLeft);
                }
                return glb;
            }).bottomRight(glb -> {
                if (isGeoHash) {
                    glb.geohash(gh -> gh.geohash(bottomRight));
                } else {
                    glb.text(bottomRight);
                }
                return glb;
            })));
        }
    }

    private static boolean allElementsAreOfType(Object[] array, Class<?> clazz) {
        for (Object o : array) {
            if (clazz.isInstance(o)) continue;
            return false;
        }
        return true;
    }

    private static ObjectBuilder<? extends QueryVariant> geoJsonQuery(String fieldName, GeoJson<?> geoJson, String relation) {
        return CriteriaFilterProcessor.buildGeoShapeQuery(fieldName, geoJson, relation);
    }

    private static ObjectBuilder<GeoShapeQuery> buildGeoShapeQuery(String fieldName, GeoJson<?> geoJson, String relation) {
        return QueryBuilders.geoShape().field(fieldName).shape(gsf -> gsf.shape(JsonData.of(GeoConverters.GeoJsonToMapConverter.INSTANCE.convert(geoJson))).relation(CriteriaFilterProcessor.toRelation(relation)));
    }

    private static GeoShapeRelation toRelation(String relation) {
        for (GeoShapeRelation geoShapeRelation : GeoShapeRelation.values()) {
            if (!geoShapeRelation.name().equalsIgnoreCase(relation)) continue;
            return geoShapeRelation;
        }
        throw new IllegalArgumentException("Unknown geo_shape relation: " + relation);
    }

    private static String extractDistanceString(Distance distance) {
        StringBuilder sb = new StringBuilder();
        sb.append((int)distance.getValue());
        switch ((Metrics)distance.getMetric()) {
            case KILOMETERS: {
                sb.append("km");
                break;
            }
            case MILES: {
                sb.append("mi");
            }
        }
        return sb.toString();
    }

    private static /* synthetic */ ObjectBuilder lambda$withinQuery$7(String loc, GeoHashLocation.Builder geohash) {
        return geohash.geohash(loc);
    }

    private static /* synthetic */ ObjectBuilder lambda$withinQuery$5(GeoPoint loc, LatLonGeoLocation.Builder latlon) {
        return latlon.lat(loc.getLat()).lon(loc.getLon());
    }
}

