/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.reactive;

import java.io.IOException;
import java.util.function.Function;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.main.MainRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.GetFieldMappingsRequest;
import org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.elasticsearch.client.indices.GetMappingsRequest;
import org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.springframework.data.elasticsearch.UncategorizedElasticsearchException;
import org.springframework.data.elasticsearch.client.util.RequestConverters;

public interface RequestCreator {
    default public Function<SearchRequest, Request> search() {
        return RequestConverters::search;
    }

    default public Function<SearchTemplateRequest, Request> searchTemplate() {
        return RequestConverters::searchTemplate;
    }

    default public Function<SearchScrollRequest, Request> scroll() {
        return RequestConverters::searchScroll;
    }

    default public Function<ClearScrollRequest, Request> clearScroll() {
        return RequestConverters::clearScroll;
    }

    default public Function<IndexRequest, Request> index() {
        return RequestConverters::index;
    }

    default public Function<GetRequest, Request> get() {
        return RequestConverters::get;
    }

    default public Function<MainRequest, Request> ping() {
        return request -> RequestConverters.ping();
    }

    default public Function<MainRequest, Request> info() {
        return request -> RequestConverters.info();
    }

    default public Function<MultiGetRequest, Request> multiGet() {
        return RequestConverters::multiGet;
    }

    default public Function<GetRequest, Request> exists() {
        return RequestConverters::exists;
    }

    default public Function<UpdateRequest, Request> update() {
        return RequestConverters::update;
    }

    default public Function<DeleteRequest, Request> delete() {
        return RequestConverters::delete;
    }

    default public Function<DeleteByQueryRequest, Request> deleteByQuery() {
        return RequestConverters::deleteByQuery;
    }

    default public Function<UpdateByQueryRequest, Request> updateByQuery() {
        return RequestConverters::updateByQuery;
    }

    default public Function<BulkRequest, Request> bulk() {
        return request -> {
            try {
                return RequestConverters.bulk(request);
            }
            catch (IOException e) {
                throw new UncategorizedElasticsearchException("Could not parse request", e);
            }
        };
    }

    @Deprecated
    default public Function<GetIndexRequest, Request> indexExists() {
        return RequestConverters::indexExists;
    }

    default public Function<org.elasticsearch.client.indices.GetIndexRequest, Request> indexExistsRequest() {
        return RequestConverters::indexExists;
    }

    default public Function<DeleteIndexRequest, Request> indexDelete() {
        return RequestConverters::indexDelete;
    }

    @Deprecated
    default public Function<org.elasticsearch.action.admin.indices.create.CreateIndexRequest, Request> indexCreate() {
        return RequestConverters::indexCreate;
    }

    default public Function<CreateIndexRequest, Request> createIndexRequest() {
        return RequestConverters::indexCreate;
    }

    default public Function<OpenIndexRequest, Request> indexOpen() {
        return RequestConverters::indexOpen;
    }

    default public Function<CloseIndexRequest, Request> indexClose() {
        return RequestConverters::indexClose;
    }

    default public Function<RefreshRequest, Request> indexRefresh() {
        return RequestConverters::indexRefresh;
    }

    @Deprecated
    default public Function<PutMappingRequest, Request> putMapping() {
        return RequestConverters::putMapping;
    }

    default public Function<org.elasticsearch.client.indices.PutMappingRequest, Request> putMappingRequest() {
        return RequestConverters::putMapping;
    }

    default public Function<FlushRequest, Request> flushIndex() {
        return RequestConverters::flushIndex;
    }

    default public Function<CountRequest, Request> count() {
        return RequestConverters::count;
    }

    default public Function<GetSettingsRequest, Request> getSettings() {
        return RequestConverters::getSettings;
    }

    @Deprecated
    default public Function<org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest, Request> getMapping() {
        return RequestConverters::getMapping;
    }

    default public Function<GetMappingsRequest, Request> getMappingRequest() {
        return RequestConverters::getMapping;
    }

    default public Function<IndicesAliasesRequest, Request> updateAlias() {
        return RequestConverters::updateAliases;
    }

    default public Function<GetAliasesRequest, Request> getAlias() {
        return RequestConverters::getAlias;
    }

    default public Function<PutIndexTemplateRequest, Request> putTemplate() {
        return RequestConverters::putTemplate;
    }

    default public Function<GetIndexTemplatesRequest, Request> getTemplates() {
        return RequestConverters::getTemplates;
    }

    default public Function<IndexTemplatesExistRequest, Request> templatesExist() {
        return RequestConverters::templatesExist;
    }

    default public Function<DeleteIndexTemplateRequest, Request> deleteTemplate() {
        return RequestConverters::deleteTemplate;
    }

    default public Function<GetFieldMappingsRequest, Request> getFieldMapping() {
        return RequestConverters::getFieldMapping;
    }

    default public Function<org.elasticsearch.client.indices.GetIndexRequest, Request> getIndex() {
        return RequestConverters::getIndex;
    }

    default public Function<ClusterHealthRequest, Request> clusterHealth() {
        return RequestConverters::clusterHealth;
    }

    default public Function<ReindexRequest, Request> reindex() {
        return RequestConverters::reindex;
    }

    default public Function<ReindexRequest, Request> submitReindex() {
        return RequestConverters::submitReindex;
    }
}

