/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client;

import java.net.InetSocketAddress;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class InetSocketAddressParser {
    InetSocketAddressParser() {
    }

    static InetSocketAddress parse(String hostPortString, int defaultPort) {
        String host;
        Assert.notNull((Object)hostPortString, (String)"HostPortString must not be null");
        String portString = null;
        if (hostPortString.startsWith("[")) {
            String[] hostAndPort = InetSocketAddressParser.getHostAndPortFromBracketedHost(hostPortString);
            host = hostAndPort[0];
            portString = hostAndPort[1];
        } else {
            int colonPos = hostPortString.indexOf(58);
            if (colonPos >= 0 && hostPortString.indexOf(58, colonPos + 1) == -1) {
                host = hostPortString.substring(0, colonPos);
                portString = hostPortString.substring(colonPos + 1);
            } else {
                host = hostPortString;
            }
        }
        int port = defaultPort;
        if (StringUtils.hasText((String)portString)) {
            Assert.isTrue((!portString.startsWith("+") ? 1 : 0) != 0, (String)String.format("Cannot parse port number: %s", hostPortString));
            try {
                port = Integer.parseInt(portString);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Cannot parse port number: %s", hostPortString));
            }
            Assert.isTrue((boolean)InetSocketAddressParser.isValidPort(port), (String)String.format("Port number out of range: %s", hostPortString));
        }
        return InetSocketAddress.createUnresolved(host, port);
    }

    private static String[] getHostAndPortFromBracketedHost(String hostPortString) {
        Assert.isTrue((hostPortString.charAt(0) == '[' ? 1 : 0) != 0, (String)String.format("Bracketed host-port string must start with a bracket: %s", hostPortString));
        int colonIndex = hostPortString.indexOf(58);
        int closeBracketIndex = hostPortString.lastIndexOf(93);
        Assert.isTrue((colonIndex > -1 && closeBracketIndex > colonIndex ? 1 : 0) != 0, (String)String.format("Invalid bracketed host/port: %s", hostPortString));
        String host = hostPortString.substring(1, closeBracketIndex);
        if (closeBracketIndex + 1 == hostPortString.length()) {
            return new String[]{host, ""};
        }
        Assert.isTrue((hostPortString.charAt(closeBracketIndex + 1) == ':' ? 1 : 0) != 0, (String)("Only a colon may follow a close bracket: " + hostPortString));
        for (int i = closeBracketIndex + 2; i < hostPortString.length(); ++i) {
            Assert.isTrue((boolean)Character.isDigit(hostPortString.charAt(i)), (String)String.format("Port must be numeric: %s", hostPortString));
        }
        return new String[]{host, hostPortString.substring(closeBracketIndex + 2)};
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }
}

