/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchParametersParameterAccessor;
import org.springframework.data.elasticsearch.repository.query.ReactiveElasticsearchQueryMethod;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.repository.util.ReactiveWrappers;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

class ReactiveElasticsearchParametersParameterAccessor
extends ElasticsearchParametersParameterAccessor {
    private final List<MonoProcessor<?>> subscriptions;

    ReactiveElasticsearchParametersParameterAccessor(ReactiveElasticsearchQueryMethod method, Object[] values) {
        super(method, values);
        this.subscriptions = new ArrayList(values.length);
        for (Object value : values) {
            if (value == null || !ReactiveWrappers.supports(value.getClass())) {
                this.subscriptions.add(null);
                continue;
            }
            if (ReactiveWrappers.isSingleValueType(value.getClass())) {
                this.subscriptions.add(((Mono)ReactiveWrapperConverters.toWrapper((Object)value, Mono.class)).toProcessor());
                continue;
            }
            this.subscriptions.add(((Flux)ReactiveWrapperConverters.toWrapper((Object)value, Flux.class)).collectList().toProcessor());
        }
    }

    protected <T> T getValue(int index) {
        if (this.subscriptions.get(index) != null) {
            return (T)this.subscriptions.get(index).block();
        }
        return (T)super.getValue(index);
    }

    @Override
    public Object[] getValues() {
        Object[] result = new Object[this.getValues().length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getValue(i);
        }
        return result;
    }

    public Object getBindableValue(int index) {
        return this.getValue(this.getParameters().getBindableParameter(index).getIndex());
    }
}

