/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import java.util.StringJoiner;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.DeleteStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.GetStoredScriptRequest;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.explain.ExplainRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RethrottleRequest;
import org.elasticsearch.client.core.CountRequest;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.SuppressForbidden;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.rankeval.RankEvalRequest;
import org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.tasks.TaskId;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;

public class RequestConverters {
    private static final XContentType REQUEST_BODY_CONTENT_TYPE = XContentType.JSON;

    private RequestConverters() {
    }

    public static Request delete(DeleteRequest deleteRequest) {
        String endpoint = RequestConverters.endpoint(deleteRequest.index(), deleteRequest.type(), deleteRequest.id());
        Request request = new Request(HttpMethod.DELETE.name(), endpoint);
        Params parameters = new Params(request);
        parameters.withRouting(deleteRequest.routing());
        parameters.withTimeout(deleteRequest.timeout());
        parameters.withVersion(deleteRequest.version());
        parameters.withVersionType(deleteRequest.versionType());
        parameters.withIfSeqNo(deleteRequest.ifSeqNo());
        parameters.withIfPrimaryTerm(deleteRequest.ifPrimaryTerm());
        parameters.withRefreshPolicy(deleteRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(deleteRequest.waitForActiveShards());
        return request;
    }

    public static Request info() {
        return new Request(HttpMethod.GET.name(), "/");
    }

    public static Request bulk(BulkRequest bulkRequest) throws IOException {
        Request request = new Request(HttpMethod.POST.name(), "/_bulk");
        Params parameters = new Params(request);
        parameters.withTimeout(bulkRequest.timeout());
        parameters.withRefreshPolicy(bulkRequest.getRefreshPolicy());
        XContentType bulkContentType = null;
        for (int i = 0; i < bulkRequest.numberOfActions(); ++i) {
            DocWriteRequest action = (DocWriteRequest)bulkRequest.requests().get(i);
            DocWriteRequest.OpType opType = action.opType();
            if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                bulkContentType = RequestConverters.enforceSameContentType((IndexRequest)action, bulkContentType);
                continue;
            }
            if (opType != DocWriteRequest.OpType.UPDATE) continue;
            UpdateRequest updateRequest = (UpdateRequest)action;
            if (updateRequest.doc() != null) {
                bulkContentType = RequestConverters.enforceSameContentType(updateRequest.doc(), bulkContentType);
            }
            if (updateRequest.upsertRequest() == null) continue;
            bulkContentType = RequestConverters.enforceSameContentType(updateRequest.upsertRequest(), bulkContentType);
        }
        if (bulkContentType == null) {
            bulkContentType = XContentType.JSON;
        }
        byte separator = bulkContentType.xContent().streamSeparator();
        ContentType requestContentType = RequestConverters.createContentType(bulkContentType);
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        for (DocWriteRequest action : bulkRequest.requests()) {
            BytesRef source;
            block61: {
                DocWriteRequest.OpType opType = action.opType();
                try (XContentBuilder metadata = XContentBuilder.builder((XContent)bulkContentType.xContent());){
                    VersionType versionType;
                    metadata.startObject();
                    metadata.startObject(opType.getLowercase());
                    if (Strings.hasLength((String)action.index())) {
                        metadata.field("_index", action.index());
                    }
                    if (Strings.hasLength((String)action.type())) {
                        metadata.field("_type", action.type());
                    }
                    if (Strings.hasLength((String)action.id())) {
                        metadata.field("_id", action.id());
                    }
                    if (Strings.hasLength((String)action.routing())) {
                        metadata.field("routing", action.routing());
                    }
                    if (action.version() != -3L) {
                        metadata.field("version", action.version());
                    }
                    if ((versionType = action.versionType()) != VersionType.INTERNAL) {
                        if (versionType == VersionType.EXTERNAL) {
                            metadata.field("version_type", "external");
                        } else if (versionType == VersionType.EXTERNAL_GTE) {
                            metadata.field("version_type", "external_gte");
                        } else if (versionType == VersionType.FORCE) {
                            metadata.field("version_type", "force");
                        }
                    }
                    if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                        IndexRequest indexRequest = (IndexRequest)action;
                        if (Strings.hasLength((String)indexRequest.getPipeline())) {
                            metadata.field("pipeline", indexRequest.getPipeline());
                        }
                    } else if (opType == DocWriteRequest.OpType.UPDATE) {
                        UpdateRequest updateRequest = (UpdateRequest)action;
                        if (updateRequest.retryOnConflict() > 0) {
                            metadata.field("retry_on_conflict", updateRequest.retryOnConflict());
                        }
                        if (updateRequest.fetchSource() != null) {
                            metadata.field("_source", (ToXContent)updateRequest.fetchSource());
                        }
                    }
                    metadata.endObject();
                    metadata.endObject();
                    BytesRef metadataSource = BytesReference.bytes((XContentBuilder)metadata).toBytesRef();
                    content.write(metadataSource.bytes, metadataSource.offset, metadataSource.length);
                    content.write(separator);
                }
                source = null;
                if (opType == DocWriteRequest.OpType.INDEX || opType == DocWriteRequest.OpType.CREATE) {
                    IndexRequest indexRequest = (IndexRequest)action;
                    BytesReference indexSource = indexRequest.source();
                    XContentType indexXContentType = indexRequest.getContentType();
                    try (XContentParser parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (BytesReference)indexSource, (XContentType)indexXContentType);
                         XContentBuilder builder = XContentBuilder.builder((XContent)bulkContentType.xContent());){
                        builder.copyCurrentStructure(parser);
                        source = BytesReference.bytes((XContentBuilder)builder).toBytesRef();
                        break block61;
                    }
                }
                if (opType == DocWriteRequest.OpType.UPDATE) {
                    source = XContentHelper.toXContent((ToXContent)((UpdateRequest)action), (XContentType)bulkContentType, (boolean)false).toBytesRef();
                }
            }
            if (source == null) continue;
            content.write(source.bytes, source.offset, source.length);
            content.write(separator);
        }
        request.setEntity((HttpEntity)new ByteArrayEntity(content.toByteArray(), 0, content.size(), requestContentType));
        return request;
    }

    public static Request exists(GetRequest getRequest) {
        return RequestConverters.getStyleRequest(HttpMethod.HEAD.name(), getRequest);
    }

    public static Request get(GetRequest getRequest) {
        return RequestConverters.getStyleRequest(HttpMethod.GET.name(), getRequest);
    }

    private static Request getStyleRequest(String method, GetRequest getRequest) {
        Request request = new Request(method, RequestConverters.endpoint(getRequest.index(), getRequest.type(), getRequest.id()));
        Params parameters = new Params(request);
        parameters.withPreference(getRequest.preference());
        parameters.withRouting(getRequest.routing());
        parameters.withRefresh(getRequest.refresh());
        parameters.withRealtime(getRequest.realtime());
        parameters.withStoredFields(getRequest.storedFields());
        parameters.withVersion(getRequest.version());
        parameters.withVersionType(getRequest.versionType());
        parameters.withFetchSourceContext(getRequest.fetchSourceContext());
        return request;
    }

    public static Request sourceExists(GetRequest getRequest) {
        Request request = new Request(HttpMethod.HEAD.name(), RequestConverters.endpoint(getRequest.index(), getRequest.type(), getRequest.id(), "_source"));
        Params parameters = new Params(request);
        parameters.withPreference(getRequest.preference());
        parameters.withRouting(getRequest.routing());
        parameters.withRefresh(getRequest.refresh());
        parameters.withRealtime(getRequest.realtime());
        return request;
    }

    public static Request multiGet(MultiGetRequest multiGetRequest) {
        Request request = new Request(HttpMethod.POST.name(), "/_mget");
        Params parameters = new Params(request);
        parameters.withPreference(multiGetRequest.preference());
        parameters.withRealtime(multiGetRequest.realtime());
        parameters.withRefresh(multiGetRequest.refresh());
        request.setEntity(RequestConverters.createEntity((ToXContent)multiGetRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    public static Request index(IndexRequest indexRequest) {
        String method = Strings.hasLength((String)indexRequest.id()) ? HttpMethod.PUT.name() : HttpMethod.POST.name();
        boolean isCreate = indexRequest.opType() == DocWriteRequest.OpType.CREATE;
        String endpoint = RequestConverters.endpoint(indexRequest.index(), indexRequest.type(), indexRequest.id(), isCreate ? "_create" : null);
        Request request = new Request(method, endpoint);
        Params parameters = new Params(request);
        parameters.withRouting(indexRequest.routing());
        parameters.withTimeout(indexRequest.timeout());
        parameters.withVersion(indexRequest.version());
        parameters.withVersionType(indexRequest.versionType());
        parameters.withIfSeqNo(indexRequest.ifSeqNo());
        parameters.withIfPrimaryTerm(indexRequest.ifPrimaryTerm());
        parameters.withPipeline(indexRequest.getPipeline());
        parameters.withRefreshPolicy(indexRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(indexRequest.waitForActiveShards());
        BytesRef source = indexRequest.source().toBytesRef();
        ContentType contentType = RequestConverters.createContentType(indexRequest.getContentType());
        request.setEntity((HttpEntity)new ByteArrayEntity(source.bytes, source.offset, source.length, contentType));
        return request;
    }

    public static Request ping() {
        return new Request(HttpMethod.HEAD.name(), "/");
    }

    public static Request update(UpdateRequest updateRequest) {
        String endpoint = RequestConverters.endpoint(updateRequest.index(), updateRequest.type(), updateRequest.id(), "_update");
        Request request = new Request(HttpMethod.POST.name(), endpoint);
        Params parameters = new Params(request);
        parameters.withRouting(updateRequest.routing());
        parameters.withTimeout(updateRequest.timeout());
        parameters.withRefreshPolicy(updateRequest.getRefreshPolicy());
        parameters.withWaitForActiveShards(updateRequest.waitForActiveShards());
        parameters.withDocAsUpsert(updateRequest.docAsUpsert());
        parameters.withFetchSourceContext(updateRequest.fetchSource());
        parameters.withRetryOnConflict(updateRequest.retryOnConflict());
        parameters.withVersion(updateRequest.version());
        parameters.withVersionType(updateRequest.versionType());
        XContentType xContentType = null;
        if (updateRequest.doc() != null) {
            xContentType = updateRequest.doc().getContentType();
        }
        if (updateRequest.upsertRequest() != null) {
            XContentType upsertContentType = updateRequest.upsertRequest().getContentType();
            if (xContentType != null && xContentType != upsertContentType) {
                throw new IllegalStateException("Update request cannot have different content types for doc [" + xContentType + "] and upsert [" + upsertContentType + "] documents");
            }
            xContentType = upsertContentType;
        }
        if (xContentType == null) {
            xContentType = Requests.INDEX_CONTENT_TYPE;
        }
        request.setEntity(RequestConverters.createEntity((ToXContent)updateRequest, xContentType));
        return request;
    }

    public static Request search(SearchRequest searchRequest) {
        Request request = new Request(HttpMethod.POST.name(), RequestConverters.endpoint(searchRequest.indices(), searchRequest.types(), "_search"));
        Params params = new Params(request);
        RequestConverters.addSearchRequestParams(params, searchRequest);
        if (searchRequest.source() != null) {
            request.setEntity(RequestConverters.createEntity((ToXContent)searchRequest.source(), REQUEST_BODY_CONTENT_TYPE));
        }
        return request;
    }

    public static Request count(CountRequest countRequest) {
        Request request = new Request(HttpMethod.POST.name(), RequestConverters.endpoint(countRequest.indices(), countRequest.types(), "_count"));
        Params params = new Params(request);
        RequestConverters.addCountRequestParams(params, countRequest);
        if (countRequest.source() != null) {
            request.setEntity(RequestConverters.createEntity((ToXContent)countRequest.source(), REQUEST_BODY_CONTENT_TYPE));
        }
        return request;
    }

    private static void addCountRequestParams(Params params, CountRequest countRequest) {
        params.withRouting(countRequest.routing());
        params.withPreference(countRequest.preference());
        params.withIndicesOptions(countRequest.indicesOptions());
    }

    private static void addSearchRequestParams(Params params, SearchRequest searchRequest) {
        params.putParam("typed_keys", "true");
        params.withRouting(searchRequest.routing());
        params.withPreference(searchRequest.preference());
        params.withIndicesOptions(searchRequest.indicesOptions());
        params.putParam("search_type", searchRequest.searchType().name().toLowerCase(Locale.ROOT));
        if (searchRequest.requestCache() != null) {
            params.putParam("request_cache", Boolean.toString(searchRequest.requestCache()));
        }
        if (searchRequest.allowPartialSearchResults() != null) {
            params.putParam("allow_partial_search_results", Boolean.toString(searchRequest.allowPartialSearchResults()));
        }
        params.putParam("batched_reduce_size", Integer.toString(searchRequest.getBatchedReduceSize()));
        if (searchRequest.scroll() != null) {
            params.putParam("scroll", searchRequest.scroll().keepAlive());
        }
    }

    public static Request searchScroll(SearchScrollRequest searchScrollRequest) {
        Request request = new Request(HttpMethod.POST.name(), "/_search/scroll");
        request.setEntity(RequestConverters.createEntity((ToXContent)searchScrollRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    public static Request clearScroll(ClearScrollRequest clearScrollRequest) {
        Request request = new Request(HttpMethod.DELETE.name(), "/_search/scroll");
        request.setEntity(RequestConverters.createEntity((ToXContent)clearScrollRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    public static Request multiSearch(MultiSearchRequest multiSearchRequest) throws IOException {
        Request request = new Request(HttpMethod.POST.name(), "/_msearch");
        Params params = new Params(request);
        params.putParam("typed_keys", "true");
        if (multiSearchRequest.maxConcurrentSearchRequests() != 0) {
            params.putParam("max_concurrent_searches", Integer.toString(multiSearchRequest.maxConcurrentSearchRequests()));
        }
        XContent xContent = REQUEST_BODY_CONTENT_TYPE.xContent();
        byte[] source = MultiSearchRequest.writeMultiLineFormat((MultiSearchRequest)multiSearchRequest, (XContent)xContent);
        request.setEntity((HttpEntity)new ByteArrayEntity(source, RequestConverters.createContentType(xContent.type())));
        return request;
    }

    public static Request explain(ExplainRequest explainRequest) throws IOException {
        Request request = new Request(HttpMethod.GET.name(), RequestConverters.endpoint(explainRequest.index(), explainRequest.type(), explainRequest.id(), "_explain"));
        Params params = new Params(request);
        params.withStoredFields(explainRequest.storedFields());
        params.withFetchSourceContext(explainRequest.fetchSourceContext());
        params.withRouting(explainRequest.routing());
        params.withPreference(explainRequest.preference());
        request.setEntity(RequestConverters.createEntity((ToXContent)explainRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    public static Request fieldCaps(FieldCapabilitiesRequest fieldCapabilitiesRequest) {
        Request request = new Request(HttpMethod.GET.name(), RequestConverters.endpoint(fieldCapabilitiesRequest.indices(), "_field_caps"));
        Params params = new Params(request);
        params.withFields(fieldCapabilitiesRequest.fields());
        params.withIndicesOptions(fieldCapabilitiesRequest.indicesOptions());
        return request;
    }

    public static Request rankEval(RankEvalRequest rankEvalRequest) throws IOException {
        Request request = new Request(HttpMethod.GET.name(), RequestConverters.endpoint(rankEvalRequest.indices(), Strings.EMPTY_ARRAY, "_rank_eval"));
        Params params = new Params(request);
        params.withIndicesOptions(rankEvalRequest.indicesOptions());
        request.setEntity(RequestConverters.createEntity((ToXContent)rankEvalRequest.getRankEvalSpec(), REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    public static Request reindex(ReindexRequest reindexRequest) throws IOException {
        return RequestConverters.prepareReindexRequest(reindexRequest, true);
    }

    static Request submitReindex(ReindexRequest reindexRequest) throws IOException {
        return RequestConverters.prepareReindexRequest(reindexRequest, false);
    }

    private static Request prepareReindexRequest(ReindexRequest reindexRequest, boolean waitForCompletion) throws IOException {
        String endpoint = new EndpointBuilder().addPathPart("_reindex").build();
        Request request = new Request(HttpMethod.POST.name(), endpoint);
        Params params = new Params(request).withWaitForCompletion(waitForCompletion).withRefresh(reindexRequest.isRefresh()).withTimeout(reindexRequest.getTimeout()).withWaitForActiveShards(reindexRequest.getWaitForActiveShards()).withRequestsPerSecond(reindexRequest.getRequestsPerSecond());
        if (reindexRequest.getScrollTime() != null) {
            params.putParam("scroll", reindexRequest.getScrollTime());
        }
        request.setEntity(RequestConverters.createEntity((ToXContent)reindexRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    public static Request updateByQuery(UpdateByQueryRequest updateByQueryRequest) throws IOException {
        String endpoint = RequestConverters.endpoint(updateByQueryRequest.indices(), updateByQueryRequest.getDocTypes(), "_update_by_query");
        Request request = new Request(HttpMethod.POST.name(), endpoint);
        Params params = new Params(request).withRouting(updateByQueryRequest.getRouting()).withPipeline(updateByQueryRequest.getPipeline()).withRefresh(updateByQueryRequest.isRefresh()).withTimeout(updateByQueryRequest.getTimeout()).withWaitForActiveShards(updateByQueryRequest.getWaitForActiveShards()).withRequestsPerSecond(updateByQueryRequest.getRequestsPerSecond()).withIndicesOptions(updateByQueryRequest.indicesOptions());
        if (!updateByQueryRequest.isAbortOnVersionConflict()) {
            params.putParam("conflicts", "proceed");
        }
        if (updateByQueryRequest.getBatchSize() != 1000) {
            params.putParam("scroll_size", Integer.toString(updateByQueryRequest.getBatchSize()));
        }
        if (updateByQueryRequest.getScrollTime() != AbstractBulkByScrollRequest.DEFAULT_SCROLL_TIMEOUT) {
            params.putParam("scroll", updateByQueryRequest.getScrollTime());
        }
        if (updateByQueryRequest.getSize() > 0) {
            params.putParam("size", Integer.toString(updateByQueryRequest.getSize()));
        }
        request.setEntity(RequestConverters.createEntity((ToXContent)updateByQueryRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    public static Request deleteByQuery(DeleteByQueryRequest deleteByQueryRequest) throws IOException {
        String endpoint = RequestConverters.endpoint(deleteByQueryRequest.indices(), deleteByQueryRequest.getDocTypes(), "_delete_by_query");
        Request request = new Request(HttpMethod.POST.name(), endpoint);
        Params params = new Params(request).withRouting(deleteByQueryRequest.getRouting()).withRefresh(deleteByQueryRequest.isRefresh()).withTimeout(deleteByQueryRequest.getTimeout()).withWaitForActiveShards(deleteByQueryRequest.getWaitForActiveShards()).withRequestsPerSecond(deleteByQueryRequest.getRequestsPerSecond()).withIndicesOptions(deleteByQueryRequest.indicesOptions());
        if (!deleteByQueryRequest.isAbortOnVersionConflict()) {
            params.putParam("conflicts", "proceed");
        }
        if (deleteByQueryRequest.getBatchSize() != 1000) {
            params.putParam("scroll_size", Integer.toString(deleteByQueryRequest.getBatchSize()));
        }
        if (deleteByQueryRequest.getScrollTime() != AbstractBulkByScrollRequest.DEFAULT_SCROLL_TIMEOUT) {
            params.putParam("scroll", deleteByQueryRequest.getScrollTime());
        }
        if (deleteByQueryRequest.getSize() > 0) {
            params.putParam("size", Integer.toString(deleteByQueryRequest.getSize()));
        }
        request.setEntity(RequestConverters.createEntity((ToXContent)deleteByQueryRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    public static Request rethrottleReindex(RethrottleRequest rethrottleRequest) {
        return RequestConverters.rethrottle(rethrottleRequest, "_reindex");
    }

    public static Request rethrottleUpdateByQuery(RethrottleRequest rethrottleRequest) {
        return RequestConverters.rethrottle(rethrottleRequest, "_update_by_query");
    }

    public static Request rethrottleDeleteByQuery(RethrottleRequest rethrottleRequest) {
        return RequestConverters.rethrottle(rethrottleRequest, "_delete_by_query");
    }

    private static Request rethrottle(RethrottleRequest rethrottleRequest, String firstPathPart) {
        String endpoint = new EndpointBuilder().addPathPart(firstPathPart).addPathPart(rethrottleRequest.getTaskId().toString()).addPathPart("_rethrottle").build();
        Request request = new Request(HttpMethod.POST.name(), endpoint);
        Params params = new Params(request).withRequestsPerSecond(rethrottleRequest.getRequestsPerSecond());
        params.putParam("group_by", "none");
        return request;
    }

    public static Request putScript(PutStoredScriptRequest putStoredScriptRequest) throws IOException {
        String endpoint = new EndpointBuilder().addPathPartAsIs("_scripts").addPathPart(putStoredScriptRequest.id()).build();
        Request request = new Request(HttpMethod.POST.name(), endpoint);
        Params params = new Params(request);
        params.withTimeout(putStoredScriptRequest.timeout());
        params.withMasterTimeout(putStoredScriptRequest.masterNodeTimeout());
        if (Strings.hasText((String)putStoredScriptRequest.context())) {
            params.putParam("context", putStoredScriptRequest.context());
        }
        request.setEntity(RequestConverters.createEntity((ToXContent)putStoredScriptRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    public static Request analyze(AnalyzeRequest request) throws IOException {
        EndpointBuilder builder = new EndpointBuilder();
        String index = request.index();
        if (index != null) {
            builder.addPathPart(index);
        }
        builder.addPathPartAsIs("_analyze");
        Request req = new Request(HttpMethod.GET.name(), builder.build());
        req.setEntity(RequestConverters.createEntity((ToXContent)request, REQUEST_BODY_CONTENT_TYPE));
        return req;
    }

    public static Request getScript(GetStoredScriptRequest getStoredScriptRequest) {
        String endpoint = new EndpointBuilder().addPathPartAsIs("_scripts").addPathPart(getStoredScriptRequest.id()).build();
        Request request = new Request(HttpMethod.GET.name(), endpoint);
        Params params = new Params(request);
        params.withMasterTimeout(getStoredScriptRequest.masterNodeTimeout());
        return request;
    }

    public static Request deleteScript(DeleteStoredScriptRequest deleteStoredScriptRequest) {
        String endpoint = new EndpointBuilder().addPathPartAsIs("_scripts").addPathPart(deleteStoredScriptRequest.id()).build();
        Request request = new Request(HttpMethod.DELETE.name(), endpoint);
        Params params = new Params(request);
        params.withTimeout(deleteStoredScriptRequest.timeout());
        params.withMasterTimeout(deleteStoredScriptRequest.masterNodeTimeout());
        return request;
    }

    public static Request getIndex(GetIndexRequest getIndexRequest) {
        String[] indices = getIndexRequest.indices() == null ? Strings.EMPTY_ARRAY : getIndexRequest.indices();
        String endpoint = RequestConverters.endpoint(indices);
        Request request = new Request(HttpMethod.GET.name(), endpoint);
        Params params = new Params(request);
        params.withIndicesOptions(getIndexRequest.indicesOptions());
        params.withLocal(getIndexRequest.local());
        params.withIncludeDefaults(getIndexRequest.includeDefaults());
        params.withHuman(getIndexRequest.humanReadable());
        params.withMasterTimeout(getIndexRequest.masterNodeTimeout());
        return request;
    }

    public static Request indexDelete(DeleteIndexRequest deleteIndexRequest) {
        String endpoint = RequestConverters.endpoint(deleteIndexRequest.indices());
        Request request = new Request(HttpMethod.DELETE.name(), endpoint);
        Params parameters = new Params(request);
        parameters.withTimeout(deleteIndexRequest.timeout());
        parameters.withMasterTimeout(deleteIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(deleteIndexRequest.indicesOptions());
        return request;
    }

    public static Request indexExists(GetIndexRequest getIndexRequest) {
        if (getIndexRequest.indices() == null || getIndexRequest.indices().length == 0) {
            throw new IllegalArgumentException("indices are mandatory");
        }
        String endpoint = RequestConverters.endpoint(getIndexRequest.indices(), "");
        Request request = new Request(HttpMethod.HEAD.name(), endpoint);
        Params params = new Params(request);
        params.withLocal(getIndexRequest.local());
        params.withHuman(getIndexRequest.humanReadable());
        params.withIndicesOptions(getIndexRequest.indicesOptions());
        params.withIncludeDefaults(getIndexRequest.includeDefaults());
        return request;
    }

    public static Request indexOpen(OpenIndexRequest openIndexRequest) {
        String endpoint = RequestConverters.endpoint(openIndexRequest.indices(), "_open");
        Request request = new Request(HttpMethod.POST.name(), endpoint);
        Params parameters = new Params(request);
        parameters.withTimeout(openIndexRequest.timeout());
        parameters.withMasterTimeout(openIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(openIndexRequest.waitForActiveShards(), ActiveShardCount.NONE);
        parameters.withIndicesOptions(openIndexRequest.indicesOptions());
        return request;
    }

    public static Request indexClose(CloseIndexRequest closeIndexRequest) {
        String endpoint = RequestConverters.endpoint(closeIndexRequest.indices(), "_close");
        Request request = new Request(HttpMethod.POST.name(), endpoint);
        Params parameters = new Params(request);
        parameters.withTimeout(closeIndexRequest.timeout());
        parameters.withMasterTimeout(closeIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(closeIndexRequest.indicesOptions());
        return request;
    }

    public static Request indexCreate(CreateIndexRequest createIndexRequest) {
        String endpoint = RequestConverters.endpoint(createIndexRequest.indices());
        Request request = new Request(HttpMethod.PUT.name(), endpoint);
        Params parameters = new Params(request);
        parameters.withTimeout(createIndexRequest.timeout());
        parameters.withMasterTimeout(createIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(createIndexRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        request.setEntity(RequestConverters.createEntity((ToXContent)createIndexRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    public static Request indexRefresh(RefreshRequest refreshRequest) {
        String[] indices = refreshRequest.indices() == null ? Strings.EMPTY_ARRAY : refreshRequest.indices();
        Request request = new Request(HttpMethod.POST.name(), RequestConverters.endpoint(indices, "_refresh"));
        Params parameters = new Params(request);
        parameters.withIndicesOptions(refreshRequest.indicesOptions());
        return request;
    }

    public static Request putMapping(PutMappingRequest putMappingRequest) {
        if (putMappingRequest.getConcreteIndex() != null) {
            throw new IllegalArgumentException("concreteIndex cannot be set on PutMapping requests made over the REST API");
        }
        Request request = new Request(HttpMethod.PUT.name(), RequestConverters.endpoint(putMappingRequest.indices(), "_mapping", putMappingRequest.type()));
        Params parameters = new Params(request);
        parameters.withTimeout(putMappingRequest.timeout());
        parameters.withMasterTimeout(putMappingRequest.masterNodeTimeout());
        request.setEntity(RequestConverters.createEntity((ToXContent)putMappingRequest, REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    public static Request flushIndex(FlushRequest flushRequest) {
        String[] indices = flushRequest.indices() == null ? Strings.EMPTY_ARRAY : flushRequest.indices();
        Request request = new Request(HttpMethod.POST.name(), RequestConverters.endpoint(indices, "_flush"));
        Params parameters = new Params(request);
        parameters.withIndicesOptions(flushRequest.indicesOptions());
        parameters.putParam("wait_if_ongoing", Boolean.toString(flushRequest.waitIfOngoing()));
        parameters.putParam("force", Boolean.toString(flushRequest.force()));
        return request;
    }

    static HttpEntity createEntity(ToXContent toXContent, XContentType xContentType) {
        try {
            BytesRef source = XContentHelper.toXContent((ToXContent)toXContent, (XContentType)xContentType, (boolean)false).toBytesRef();
            return new ByteArrayEntity(source.bytes, source.offset, source.length, RequestConverters.createContentType(xContentType));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static String endpoint(String index, String type, String id) {
        return new EndpointBuilder().addPathPart(index, type, id).build();
    }

    static String endpoint(String index, String type, String id, String endpoint) {
        return new EndpointBuilder().addPathPart(index, type, id).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).build();
    }

    static String endpoint(String[] indices, String endpoint) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices, String[] types, String endpoint) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addCommaSeparatedPathParts(types).addPathPartAsIs(endpoint).build();
    }

    static String endpoint(String[] indices, String endpoint, String[] suffixes) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).addCommaSeparatedPathParts(suffixes).build();
    }

    static String endpoint(String[] indices, String endpoint, String type) {
        return new EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs(endpoint).addPathPart(type).build();
    }

    @SuppressForbidden(reason="Only allowed place to convert a XContentType to a ContentType")
    public static ContentType createContentType(XContentType xContentType) {
        return ContentType.create((String)xContentType.mediaTypeWithoutParameters(), (Charset)null);
    }

    static XContentType enforceSameContentType(IndexRequest indexRequest, @Nullable XContentType xContentType) {
        XContentType requestContentType = indexRequest.getContentType();
        if (requestContentType != XContentType.JSON && requestContentType != XContentType.SMILE) {
            throw new IllegalArgumentException("Unsupported content-type found for request with content-type [" + requestContentType + "], only JSON and SMILE are supported");
        }
        if (xContentType == null) {
            return requestContentType;
        }
        if (requestContentType != xContentType) {
            throw new IllegalArgumentException("Mismatching content-type found for request with content-type [" + requestContentType + "], previous requests have content-type [" + xContentType + "]");
        }
        return xContentType;
    }

    static class EndpointBuilder {
        private final StringJoiner joiner = new StringJoiner("/", "/", "");

        EndpointBuilder() {
        }

        EndpointBuilder addPathPart(String ... parts) {
            for (String part : parts) {
                if (!Strings.hasLength((String)part)) continue;
                this.joiner.add(EndpointBuilder.encodePart(part));
            }
            return this;
        }

        EndpointBuilder addCommaSeparatedPathParts(String[] parts) {
            this.addPathPart(String.join((CharSequence)",", parts));
            return this;
        }

        EndpointBuilder addCommaSeparatedPathParts(List<String> parts) {
            this.addPathPart(String.join((CharSequence)",", parts));
            return this;
        }

        EndpointBuilder addPathPartAsIs(String ... parts) {
            for (String part : parts) {
                if (!Strings.hasLength((String)part)) continue;
                this.joiner.add(part);
            }
            return this;
        }

        String build() {
            return this.joiner.toString();
        }

        private static String encodePart(String pathPart) {
            try {
                URI uri = new URI(null, null, null, -1, "/" + pathPart, null, null);
                return uri.getRawPath().substring(1).replaceAll("/", "%2F");
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Path part [" + pathPart + "] couldn't be encoded", e);
            }
        }
    }

    static class Params {
        private final Request request;

        Params(Request request) {
            this.request = request;
        }

        Params putParam(String name, String value) {
            if (Strings.hasLength((String)value)) {
                this.request.addParameter(name, value);
            }
            return this;
        }

        Params putParam(String key, TimeValue value) {
            if (value != null) {
                return this.putParam(key, value.getStringRep());
            }
            return this;
        }

        Params withDocAsUpsert(boolean docAsUpsert) {
            if (docAsUpsert) {
                return this.putParam("doc_as_upsert", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withFetchSourceContext(FetchSourceContext fetchSourceContext) {
            if (fetchSourceContext != null) {
                if (!fetchSourceContext.fetchSource()) {
                    this.putParam("_source", Boolean.FALSE.toString());
                }
                if (fetchSourceContext.includes() != null && fetchSourceContext.includes().length > 0) {
                    this.putParam("_source_includes", String.join((CharSequence)",", fetchSourceContext.includes()));
                }
                if (fetchSourceContext.excludes() != null && fetchSourceContext.excludes().length > 0) {
                    this.putParam("_source_excludes", String.join((CharSequence)",", fetchSourceContext.excludes()));
                }
            }
            return this;
        }

        Params withFields(String[] fields) {
            if (fields != null && fields.length > 0) {
                return this.putParam("fields", String.join((CharSequence)",", fields));
            }
            return this;
        }

        Params withMasterTimeout(TimeValue masterTimeout) {
            return this.putParam("master_timeout", masterTimeout);
        }

        Params withPipeline(String pipeline) {
            return this.putParam("pipeline", pipeline);
        }

        Params withPreference(String preference) {
            return this.putParam("preference", preference);
        }

        Params withRealtime(boolean realtime) {
            if (!realtime) {
                return this.putParam("realtime", Boolean.FALSE.toString());
            }
            return this;
        }

        Params withRefresh(boolean refresh) {
            if (refresh) {
                return this.withRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            }
            return this;
        }

        Params withRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
            if (refreshPolicy != WriteRequest.RefreshPolicy.NONE) {
                return this.putParam("refresh", refreshPolicy.getValue());
            }
            return this;
        }

        Params withRequestsPerSecond(float requestsPerSecond) {
            if (Float.isFinite(requestsPerSecond)) {
                return this.putParam("requests_per_second", Float.toString(requestsPerSecond));
            }
            return this.putParam("requests_per_second", "-1");
        }

        Params withRetryOnConflict(int retryOnConflict) {
            if (retryOnConflict > 0) {
                return this.putParam("retry_on_conflict", String.valueOf(retryOnConflict));
            }
            return this;
        }

        Params withRouting(String routing) {
            return this.putParam("routing", routing);
        }

        Params withStoredFields(String[] storedFields) {
            if (storedFields != null && storedFields.length > 0) {
                return this.putParam("stored_fields", String.join((CharSequence)",", storedFields));
            }
            return this;
        }

        Params withTimeout(TimeValue timeout) {
            return this.putParam("timeout", timeout);
        }

        Params withVersion(long version) {
            if (version != -3L) {
                return this.putParam("version", Long.toString(version));
            }
            return this;
        }

        Params withVersionType(VersionType versionType) {
            if (versionType != VersionType.INTERNAL) {
                return this.putParam("version_type", versionType.name().toLowerCase(Locale.ROOT));
            }
            return this;
        }

        Params withIfSeqNo(long seqNo) {
            if (seqNo != -2L) {
                return this.putParam("if_seq_no", Long.toString(seqNo));
            }
            return this;
        }

        Params withIfPrimaryTerm(long primaryTerm) {
            if (primaryTerm != 0L) {
                return this.putParam("if_primary_term", Long.toString(primaryTerm));
            }
            return this;
        }

        Params withWaitForActiveShards(ActiveShardCount activeShardCount) {
            return this.withWaitForActiveShards(activeShardCount, ActiveShardCount.DEFAULT);
        }

        Params withWaitForActiveShards(ActiveShardCount activeShardCount, ActiveShardCount defaultActiveShardCount) {
            if (activeShardCount != null && activeShardCount != defaultActiveShardCount) {
                return this.putParam("wait_for_active_shards", activeShardCount.toString().toLowerCase(Locale.ROOT));
            }
            return this;
        }

        Params withIndicesOptions(IndicesOptions indicesOptions) {
            String expandWildcards;
            this.withIgnoreUnavailable(indicesOptions.ignoreUnavailable());
            this.putParam("allow_no_indices", Boolean.toString(indicesOptions.allowNoIndices()));
            if (!indicesOptions.expandWildcardsOpen() && !indicesOptions.expandWildcardsClosed()) {
                expandWildcards = "none";
            } else {
                StringJoiner joiner = new StringJoiner(",");
                if (indicesOptions.expandWildcardsOpen()) {
                    joiner.add("open");
                }
                if (indicesOptions.expandWildcardsClosed()) {
                    joiner.add("closed");
                }
                expandWildcards = joiner.toString();
            }
            this.putParam("expand_wildcards", expandWildcards);
            return this;
        }

        Params withIgnoreUnavailable(boolean ignoreUnavailable) {
            this.putParam("ignore_unavailable", Boolean.toString(ignoreUnavailable));
            return this;
        }

        Params withHuman(boolean human) {
            if (human) {
                this.putParam("human", "true");
            }
            return this;
        }

        Params withLocal(boolean local) {
            if (local) {
                this.putParam("local", "true");
            }
            return this;
        }

        Params withIncludeDefaults(boolean includeDefaults) {
            if (includeDefaults) {
                return this.putParam("include_defaults", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withPreserveExisting(boolean preserveExisting) {
            if (preserveExisting) {
                return this.putParam("preserve_existing", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withDetailed(boolean detailed) {
            if (detailed) {
                return this.putParam("detailed", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForCompletion(Boolean waitForCompletion) {
            return this.putParam("wait_for_completion", waitForCompletion.toString());
        }

        Params withNodes(String[] nodes) {
            if (nodes != null && nodes.length > 0) {
                return this.putParam("nodes", String.join((CharSequence)",", nodes));
            }
            return this;
        }

        Params withActions(String[] actions) {
            if (actions != null && actions.length > 0) {
                return this.putParam("actions", String.join((CharSequence)",", actions));
            }
            return this;
        }

        Params withTaskId(TaskId taskId) {
            if (taskId != null && taskId.isSet()) {
                return this.putParam("task_id", taskId.toString());
            }
            return this;
        }

        Params withParentTaskId(TaskId parentTaskId) {
            if (parentTaskId != null && parentTaskId.isSet()) {
                return this.putParam("parent_task_id", parentTaskId.toString());
            }
            return this;
        }

        Params withVerify(boolean verify) {
            if (verify) {
                return this.putParam("verify", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForStatus(ClusterHealthStatus status) {
            if (status != null) {
                return this.putParam("wait_for_status", status.name().toLowerCase(Locale.ROOT));
            }
            return this;
        }

        Params withWaitForNoRelocatingShards(boolean waitNoRelocatingShards) {
            if (waitNoRelocatingShards) {
                return this.putParam("wait_for_no_relocating_shards", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForNoInitializingShards(boolean waitNoInitShards) {
            if (waitNoInitShards) {
                return this.putParam("wait_for_no_initializing_shards", Boolean.TRUE.toString());
            }
            return this;
        }

        Params withWaitForNodes(String waitForNodes) {
            return this.putParam("wait_for_nodes", waitForNodes);
        }

        Params withLevel(ClusterHealthRequest.Level level) {
            return this.putParam("level", level.name().toLowerCase(Locale.ROOT));
        }

        Params withWaitForEvents(Priority waitForEvents) {
            if (waitForEvents != null) {
                return this.putParam("wait_for_events", waitForEvents.name().toLowerCase(Locale.ROOT));
            }
            return this;
        }
    }
}

