/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.repository.query;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.convert.DateTimeConverters;
import org.springframework.data.elasticsearch.core.query.StringQuery;
import org.springframework.data.elasticsearch.repository.query.AbstractElasticsearchRepositoryQuery;
import org.springframework.data.elasticsearch.repository.query.ElasticsearchQueryMethod;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.util.Assert;

public class ElasticsearchStringQuery
extends AbstractElasticsearchRepositoryQuery {
    private static final Pattern PARAMETER_PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    private String query;
    private final GenericConversionService conversionService = new GenericConversionService();

    public ElasticsearchStringQuery(ElasticsearchQueryMethod queryMethod, ElasticsearchOperations elasticsearchOperations, String query) {
        super(queryMethod, elasticsearchOperations);
        if (!this.conversionService.canConvert(Date.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JavaDateConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(ReadableInstant.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JodaDateTimeConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(LocalDateTime.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JodaLocalDateTimeConverter.INSTANCE);
        }
        Assert.notNull((Object)query, (String)"Query cannot be empty");
        this.query = query;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        StringQuery stringQuery = this.createQuery(accessor);
        if (this.queryMethod.isPageQuery()) {
            stringQuery.setPageable(accessor.getPageable());
            return this.elasticsearchOperations.queryForPage(stringQuery, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (this.queryMethod.isCollectionQuery()) {
            if (accessor.getPageable() != null) {
                stringQuery.setPageable(accessor.getPageable());
            }
            return this.elasticsearchOperations.queryForList(stringQuery, this.queryMethod.getEntityInformation().getJavaType());
        }
        return this.elasticsearchOperations.queryForObject(stringQuery, this.queryMethod.getEntityInformation().getJavaType());
    }

    protected StringQuery createQuery(ParametersParameterAccessor parameterAccessor) {
        String queryString = this.replacePlaceholders(this.query, parameterAccessor);
        return new StringQuery(queryString);
    }

    private String replacePlaceholders(String input, ParametersParameterAccessor accessor) {
        Matcher matcher = PARAMETER_PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String group = matcher.group();
            int index = Integer.parseInt(matcher.group(1));
            result = result.replace(group, this.getParameterWithIndex(accessor, index));
        }
        return result;
    }

    private String getParameterWithIndex(ParametersParameterAccessor accessor, int index) {
        Object parameter = accessor.getBindableValue(index);
        if (parameter == null) {
            return "null";
        }
        if (this.conversionService.canConvert(parameter.getClass(), String.class)) {
            return (String)this.conversionService.convert(parameter, String.class);
        }
        return parameter.toString();
    }
}

