/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class BeanLookup {
    private BeanLookup() {
    }

    public static <T> Lazy<T> lazyIfAvailable(Class<T> type, BeanFactory beanFactory) {
        Assert.notNull(type, (String)"Type must not be null");
        Assert.isInstanceOf(ListableBeanFactory.class, (Object)beanFactory);
        return Lazy.of(() -> BeanLookup.lookupBean(type, (ListableBeanFactory)beanFactory));
    }

    @Nullable
    private static <T> T lookupBean(Class<T> type, ListableBeanFactory beanFactory) {
        Map names = beanFactory.getBeansOfType(type, false, false);
        switch (names.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (T)names.values().iterator().next();
            }
        }
        throw new NoUniqueBeanDefinitionException(type, names.keySet());
    }
}

