/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aot;

import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.springframework.aot.generate.AccessControl;
import org.springframework.aot.generate.GeneratedMethod;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.beans.factory.aot.BeanRegistrationCode;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragments;
import org.springframework.beans.factory.aot.BeanRegistrationCodeFragmentsDecorator;
import org.springframework.beans.factory.support.InstanceSupplier;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.ResolvableType;
import org.springframework.data.aot.RegisteredBeanAotContribution;
import org.springframework.data.domain.ManagedTypes;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeCollector;
import org.springframework.javapoet.ClassName;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.MethodSpec;
import org.springframework.javapoet.ParameterizedTypeName;
import org.springframework.javapoet.TypeName;
import org.springframework.javapoet.WildcardTypeName;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

class ManagedTypesRegistrationAotContribution
implements RegisteredBeanAotContribution {
    private final ManagedTypes managedTypes;
    private final Lazy<List<Class<?>>> sourceTypes;
    private final BiConsumer<ResolvableType, GenerationContext> contributionAction;
    private final RegisteredBean source;

    public ManagedTypesRegistrationAotContribution(ManagedTypes managedTypes, RegisteredBean registeredBean, BiConsumer<ResolvableType, GenerationContext> contributionAction) {
        this.managedTypes = managedTypes;
        this.sourceTypes = Lazy.of(managedTypes::toList);
        this.contributionAction = contributionAction;
        this.source = registeredBean;
    }

    public void applyTo(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode) {
        List<Class<?>> types = this.sourceTypes.get();
        if (!types.isEmpty()) {
            TypeCollector.inspect(types).forEach(type -> this.contributionAction.accept((ResolvableType)type, generationContext));
        }
    }

    public BeanRegistrationCodeFragments customizeBeanRegistrationCodeFragments(GenerationContext generationContext, BeanRegistrationCodeFragments codeFragments) {
        if (this.managedTypes == null) {
            return codeFragments;
        }
        ManagedTypesInstanceCodeFragment fragment = new ManagedTypesInstanceCodeFragment(this.sourceTypes.get(), this.source, codeFragments);
        return fragment.canGenerateCode() ? fragment : codeFragments;
    }

    @Override
    public RegisteredBean getSource() {
        return this.source;
    }

    static class ManagedTypesInstanceCodeFragment
    extends BeanRegistrationCodeFragmentsDecorator {
        public static final ResolvableType LIST_TYPE = ResolvableType.forType(List.class);
        public static final ResolvableType MANAGED_TYPES_TYPE = ResolvableType.forType(ManagedTypes.class);
        private final List<Class<?>> sourceTypes;
        private final RegisteredBean source;
        private final Lazy<Method> instanceMethod = Lazy.of(this::findInstanceFactory);
        private static final TypeName WILDCARD = WildcardTypeName.subtypeOf(Object.class);
        private static final TypeName CLASS_OF_ANY = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WILDCARD});
        private static final TypeName LIST_OF_ANY = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{CLASS_OF_ANY});

        protected ManagedTypesInstanceCodeFragment(List<Class<?>> sourceTypes, RegisteredBean source, BeanRegistrationCodeFragments codeFragments) {
            super(codeFragments);
            this.sourceTypes = sourceTypes;
            this.source = source;
        }

        public CodeBlock generateInstanceSupplierCode(GenerationContext generationContext, BeanRegistrationCode beanRegistrationCode, Executable constructorOrFactoryMethod, boolean allowDirectSupplierShortcut) {
            GeneratedMethod generatedMethod = beanRegistrationCode.getMethods().add("Instance", this::generateInstanceFactory);
            return CodeBlock.of((String)"$T.$L()", (Object[])new Object[]{beanRegistrationCode.getClassName(), generatedMethod.getName()});
        }

        boolean canGenerateCode() {
            if (ObjectUtils.nullSafeEquals((Object)this.source.getBeanClass(), ManagedTypes.class)) {
                return true;
            }
            return this.instanceMethod.getNullable() != null;
        }

        void generateInstanceFactory(MethodSpec.Builder method) {
            boolean allSourceTypesVisible = this.sourceTypes.stream().allMatch(it -> AccessControl.forClass((Class)it).isPublic());
            ParameterizedTypeName targetTypeName = ParameterizedTypeName.get(InstanceSupplier.class, (Type[])new Type[]{this.source.getBeanClass()});
            method.addJavadoc("Get the bean instance for '$L'.", new Object[]{this.source.getBeanName()});
            method.addModifiers(new javax.lang.model.element.Modifier[]{javax.lang.model.element.Modifier.PRIVATE, javax.lang.model.element.Modifier.STATIC});
            method.returns((TypeName)targetTypeName);
            CodeBlock.Builder builder = CodeBlock.builder().add("return ", new Object[0]).beginControlFlow("(registeredBean -> ", new Object[0]);
            if (this.sourceTypes.isEmpty()) {
                builder.addStatement("$T types = $T.emptyList()", new Object[]{LIST_OF_ANY, Collections.class});
            } else {
                Object variableTypeName = allSourceTypesVisible ? LIST_OF_ANY : ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get(String.class)});
                builder.addStatement("$T types = $T.of($L)", new Object[]{variableTypeName, List.class, this.toCodeBlock(this.sourceTypes, allSourceTypesVisible)});
            }
            if (allSourceTypesVisible) {
                builder.addStatement("$T managedTypes = $T.fromIterable($L)", new Object[]{ManagedTypes.class, ManagedTypes.class, "types"});
            } else {
                builder.add(CodeBlock.builder().beginControlFlow("$T managedTypes = $T.fromStream(types.stream().map(it ->", new Object[]{ManagedTypes.class, ManagedTypes.class}).beginControlFlow("try", new Object[0]).addStatement("return $T.forName(it, registeredBean.getBeanFactory().getBeanClassLoader())", new Object[]{ClassUtils.class}).nextControlFlow("catch ($T e)", new Object[]{ClassNotFoundException.class}).addStatement("throw new $T($S, e)", new Object[]{IllegalArgumentException.class, "Cannot to load type"}).endControlFlow().endControlFlow("))", new Object[0]).build());
            }
            if (ObjectUtils.nullSafeEquals((Object)this.source.getBeanClass(), ManagedTypes.class)) {
                builder.add("return managedTypes", new Object[0]);
            } else {
                Method instanceFactoryMethod = this.instanceMethod.get();
                if (ResolvableType.forMethodParameter((Method)instanceFactoryMethod, (int)0).isAssignableFrom(ResolvableType.forType(ManagedTypes.class))) {
                    builder.addStatement("return $T.$L($L)", new Object[]{instanceFactoryMethod.getDeclaringClass(), instanceFactoryMethod.getName(), "managedTypes"});
                } else {
                    builder.addStatement("return $T.$L($L.toList())", new Object[]{instanceFactoryMethod.getDeclaringClass(), instanceFactoryMethod.getName(), "managedTypes"});
                }
            }
            builder.endControlFlow(")", new Object[0]);
            method.addCode(builder.build());
        }

        private CodeBlock toCodeBlock(List<Class<?>> values, boolean allPublic) {
            if (allPublic) {
                return CodeBlock.join(values.stream().map(value -> CodeBlock.of((String)"$T.class", (Object[])new Object[]{value})).toList(), (String)", ");
            }
            return CodeBlock.join(values.stream().map(value -> CodeBlock.of((String)"$S", (Object[])new Object[]{value.getName()})).toList(), (String)", ");
        }

        @Nullable
        private Method findInstanceFactory() {
            for (Method beanMethod : ReflectionUtils.getDeclaredMethods((Class)this.source.getBeanClass())) {
                ResolvableType parameterType;
                if (!ManagedTypesInstanceCodeFragment.isInstanceFactory(beanMethod) || !(parameterType = ResolvableType.forMethodParameter((Method)beanMethod, (int)0, (Class)this.source.getBeanClass())).isAssignableFrom(LIST_TYPE) && !parameterType.isAssignableFrom(MANAGED_TYPES_TYPE)) continue;
                return beanMethod;
            }
            return null;
        }

        private static boolean isInstanceFactory(Method beanMethod) {
            return beanMethod.getParameterCount() == 1 && Modifier.isPublic(beanMethod.getModifiers()) && Modifier.isStatic(beanMethod.getModifiers());
        }
    }
}

