/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.beans.ConstructorProperties;
import lombok.NonNull;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.lang.Nullable;

public class PersistentEntityParameterValueProvider<P extends PersistentProperty<P>>
implements ParameterValueProvider<P> {
    @NonNull
    private final PersistentEntity<?, P> entity;
    @NonNull
    private final PropertyValueProvider<P> provider;
    @Nullable
    private final Object parent;

    @Override
    @Nullable
    public <T> T getParameterValue(PreferredConstructor.Parameter<T, P> parameter) {
        PreferredConstructor<T, P> constructor = this.entity.getPersistenceConstructor();
        if (constructor != null && constructor.isEnclosingClassParameter(parameter)) {
            return (T)this.parent;
        }
        String name = parameter.getName();
        if (name == null) {
            throw new MappingException(String.format("Parameter %s does not have a name!", parameter));
        }
        P property = this.entity.getPersistentProperty(name);
        if (property == null) {
            throw new MappingException(String.format("No property %s found on entity %s to bind constructor parameter to!", name, this.entity.getType()));
        }
        return this.provider.getPropertyValue(property);
    }

    @ConstructorProperties(value={"entity", "provider", "parent"})
    public PersistentEntityParameterValueProvider(@NonNull PersistentEntity<?, P> entity, @NonNull PropertyValueProvider<P> provider, @Nullable Object parent) {
        if (entity == null) {
            throw new IllegalArgumentException("entity is null");
        }
        if (provider == null) {
            throw new IllegalArgumentException("provider is null");
        }
        this.entity = entity;
        this.provider = provider;
        this.parent = parent;
    }
}

