/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import org.springframework.data.util.ParentTypeAwareTypeInformation;
import org.springframework.data.util.TypeDiscoverer;
import org.springframework.data.util.TypeInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GenericArrayTypeInformation<S>
extends ParentTypeAwareTypeInformation<S> {
    private GenericArrayType type;

    protected GenericArrayTypeInformation(GenericArrayType type, TypeDiscoverer<?> parent) {
        super(type, parent, parent.getTypeVariableMap());
        this.type = type;
    }

    @Override
    public Class<S> getType() {
        return Array.newInstance(this.resolveType(this.type.getGenericComponentType()), 0).getClass();
    }

    @Override
    public TypeInformation<?> getComponentType() {
        Type componentType = this.type.getGenericComponentType();
        return this.createInfo(componentType);
    }
}

