/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.support;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryFactoryInformation;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repositories
implements Iterable<Class<?>> {
    static final Repositories NONE = new Repositories();
    private final Map<Class<?>, RepositoryFactoryInformation<Object, Serializable>> domainClassToBeanName = new HashMap();
    private final Map<RepositoryFactoryInformation<Object, Serializable>, CrudRepository<Object, Serializable>> repositories = new HashMap<RepositoryFactoryInformation<Object, Serializable>, CrudRepository<Object, Serializable>>();

    private Repositories() {
    }

    public Repositories(ListableBeanFactory factory) {
        Assert.notNull((Object)factory);
        Collection providers = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)factory, RepositoryFactoryInformation.class).values();
        for (RepositoryFactoryInformation info : providers) {
            RepositoryInformation information = info.getRepositoryInformation();
            Class<?> repositoryInterface = information.getRepositoryInterface();
            if (!CrudRepository.class.isAssignableFrom(repositoryInterface)) continue;
            Class<?> objectType = repositoryInterface;
            CrudRepository repository = (CrudRepository)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)factory, objectType);
            this.domainClassToBeanName.put(information.getDomainType(), info);
            this.repositories.put(info, repository);
        }
    }

    public boolean hasRepositoryFor(Class<?> domainClass) {
        return this.domainClassToBeanName.containsKey(domainClass);
    }

    public <T, S extends Serializable> CrudRepository<T, S> getRepositoryFor(Class<?> domainClass) {
        return this.repositories.get(this.domainClassToBeanName.get(domainClass));
    }

    public <T, S extends Serializable> EntityInformation<T, S> getEntityInformationFor(Class<?> domainClass) {
        RepositoryFactoryInformation<Object, Serializable> information = this.getRepoInfoFor(domainClass);
        return information == null ? null : information.getEntityInformation();
    }

    public RepositoryInformation getRepositoryInformationFor(Class<?> domainClass) {
        RepositoryFactoryInformation<Object, Serializable> information = this.getRepoInfoFor(domainClass);
        return information == null ? null : information.getRepositoryInformation();
    }

    public PersistentEntity<?, ?> getPersistentEntity(Class<?> domainClass) {
        RepositoryFactoryInformation<Object, Serializable> information = this.getRepoInfoFor(domainClass);
        return information == null ? null : information.getPersistentEntity();
    }

    public List<QueryMethod> getQueryMethodsFor(Class<?> domainClass) {
        RepositoryFactoryInformation<Object, Serializable> information = this.getRepoInfoFor(domainClass);
        return information == null ? Collections.emptyList() : information.getQueryMethods();
    }

    private RepositoryFactoryInformation<Object, Serializable> getRepoInfoFor(Class<?> domainClass) {
        Assert.notNull(domainClass);
        for (RepositoryFactoryInformation<Object, Serializable> information : this.repositories.keySet()) {
            if (!domainClass.equals(information.getEntityInformation().getJavaType())) continue;
            return information;
        }
        return null;
    }

    @Override
    public Iterator<Class<?>> iterator() {
        return this.domainClassToBeanName.keySet().iterator();
    }
}

