/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.model;

import java.lang.reflect.Constructor;
import java.util.List;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingInstantiationException
extends RuntimeException {
    private static final long serialVersionUID = 822211065035487628L;
    private static final String TEXT_TEMPLATE = "Failed to instantiate %s using constructor %s with arguments %s";
    private final Class<?> entityType;
    private final Constructor<?> constructor;
    private final List<Object> constructorArguments;

    @Deprecated
    public MappingInstantiationException(String message, Exception cause) {
        this(null, null, message, cause);
    }

    public MappingInstantiationException(PersistentEntity<?, ?> entity, List<Object> arguments, Exception cause) {
        this(entity, arguments, null, cause);
    }

    private MappingInstantiationException(PersistentEntity<?, ?> entity, List<Object> arguments, String message, Exception cause) {
        super(MappingInstantiationException.buildExceptionMessage(entity, arguments, null), cause);
        this.entityType = entity == null ? null : entity.getType();
        this.constructor = entity == null || entity.getPersistenceConstructor() == null ? null : entity.getPersistenceConstructor().getConstructor();
        this.constructorArguments = arguments;
    }

    private static final String buildExceptionMessage(PersistentEntity<?, ?> entity, List<Object> arguments, String defaultMessage) {
        if (entity == null) {
            return defaultMessage;
        }
        PreferredConstructor<?, ?> constructor = entity.getPersistenceConstructor();
        return String.format(TEXT_TEMPLATE, entity.getType().getName(), constructor == null ? "NO_CONSTRUCTOR" : constructor.getConstructor().toString(), StringUtils.collectionToCommaDelimitedString(arguments));
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public List<Object> getConstructorArguments() {
        return this.constructorArguments;
    }
}

