/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl;

import com.querydsl.core.types.Predicate;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;

public class QuerydslRepositoryInvokerAdapter
implements RepositoryInvoker {
    private final RepositoryInvoker delegate;
    private final QueryDslPredicateExecutor<Object> executor;
    private final Predicate predicate;

    public QuerydslRepositoryInvokerAdapter(RepositoryInvoker delegate, QueryDslPredicateExecutor<Object> executor, Predicate predicate) {
        Assert.notNull((Object)delegate, (String)"Delegate RepositoryInvoker must not be null!");
        Assert.notNull(executor, (String)"QuerydslPredicateExecutor must not be null!");
        this.delegate = delegate;
        this.executor = executor;
        this.predicate = predicate;
    }

    @Override
    public Iterable<Object> invokeFindAll(Pageable pageable) {
        return this.executor.findAll(this.predicate, pageable);
    }

    @Override
    public Iterable<Object> invokeFindAll(Sort sort) {
        return this.executor.findAll(this.predicate, sort);
    }

    @Override
    public boolean hasDeleteMethod() {
        return this.delegate.hasDeleteMethod();
    }

    @Override
    public boolean hasFindAllMethod() {
        return this.delegate.hasFindAllMethod();
    }

    @Override
    public boolean hasFindOneMethod() {
        return this.delegate.hasFindOneMethod();
    }

    @Override
    public boolean hasSaveMethod() {
        return this.delegate.hasSaveMethod();
    }

    @Override
    public void invokeDelete(Serializable id) {
        this.delegate.invokeDelete(id);
    }

    @Override
    public <T> T invokeFindOne(Serializable id) {
        return this.delegate.invokeFindOne(id);
    }

    @Override
    public Object invokeQueryMethod(Method method, Map<String, String[]> parameters, Pageable pageable, Sort sort) {
        return this.delegate.invokeQueryMethod(method, parameters, pageable, sort);
    }

    @Override
    public Object invokeQueryMethod(Method method, MultiValueMap<String, ? extends Object> parameters, Pageable pageable, Sort sort) {
        return this.delegate.invokeQueryMethod(method, parameters, pageable, sort);
    }

    @Override
    public <T> T invokeSave(T object) {
        return this.delegate.invokeSave(object);
    }
}

