/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.stream.binder.Binder;
import org.springframework.cloud.stream.binder.BinderFactory;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.ExtendedPropertiesBinder;
import org.springframework.cloud.stream.binder.PollableConsumerBinder;
import org.springframework.cloud.stream.binder.PollableSource;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.DataBinder;

public class BindingService {
    private final Log log = LogFactory.getLog(BindingService.class);
    private final BindingServiceProperties bindingServiceProperties;
    private final Map<String, Binding<?>> producerBindings = new HashMap();
    private final Map<String, List<Binding<?>>> consumerBindings = new HashMap();
    private final TaskScheduler taskScheduler;
    private final BinderFactory binderFactory;
    private final ObjectMapper objectMapper;

    public BindingService(BindingServiceProperties bindingServiceProperties, BinderFactory binderFactory, ObjectMapper objectMapper) {
        this(bindingServiceProperties, binderFactory, null, objectMapper);
    }

    public BindingService(BindingServiceProperties bindingServiceProperties, BinderFactory binderFactory, TaskScheduler taskScheduler, ObjectMapper objectMapper) {
        this.bindingServiceProperties = bindingServiceProperties;
        this.binderFactory = binderFactory;
        this.taskScheduler = taskScheduler;
        this.objectMapper = objectMapper;
    }

    public <T> Collection<Binding<T>> bindConsumer(T input, String inputName) {
        ArrayList<Binding<T>> bindings = new ArrayList<Binding<T>>();
        Class<?> inputClass = input.getClass();
        if (input instanceof Advised) {
            Advised advisedInput = (Advised)input;
            inputClass = Stream.of(advisedInput.getProxiedInterfaces()).filter(c -> !c.getName().contains("org.springframework")).findFirst().orElse(inputClass);
        }
        Binder<?, ?, ?> binder = this.getBinder(inputName, inputClass);
        ExtendedConsumerProperties consumerProperties = this.bindingServiceProperties.getConsumerProperties(inputName);
        if (binder instanceof ExtendedPropertiesBinder) {
            ExtendedPropertiesBinder extendedPropertiesBinder = (ExtendedPropertiesBinder)binder;
            Object extension = extendedPropertiesBinder.getExtendedConsumerProperties(inputName);
            ExtendedConsumerProperties extendedConsumerProperties = new ExtendedConsumerProperties(extension);
            BeanUtils.copyProperties((Object)consumerProperties, extendedConsumerProperties);
            consumerProperties = extendedConsumerProperties;
        }
        consumerProperties.populateBindingName(inputName);
        this.validate(consumerProperties);
        String bindingTarget = this.bindingServiceProperties.getBindingDestination(inputName);
        if (consumerProperties.isMultiplex()) {
            bindings.add(this.doBindConsumer(input, inputName, binder, consumerProperties, bindingTarget));
        } else {
            String[] bindingTargets;
            for (String target : bindingTargets = StringUtils.commaDelimitedListToStringArray((String)bindingTarget)) {
                if (!consumerProperties.isPartitioned() || consumerProperties.getInstanceIndexList().isEmpty()) {
                    Binding<T> binding = input instanceof PollableSource ? this.doBindPollableConsumer(input, inputName, binder, consumerProperties, target) : this.doBindConsumer(input, inputName, binder, consumerProperties, target);
                    bindings.add(binding);
                    continue;
                }
                for (Integer index : consumerProperties.getInstanceIndexList()) {
                    Object t;
                    if (index < 0) continue;
                    if (consumerProperties instanceof ExtendedConsumerProperties) {
                        ExtendedConsumerProperties extendedProperties = consumerProperties;
                        t = extendedProperties.getExtension();
                    } else {
                        t = null;
                    }
                    Object extension = t;
                    ExtendedConsumerProperties<Object> consumerPropertiesTemp = new ExtendedConsumerProperties<Object>(extension);
                    BeanUtils.copyProperties(consumerProperties, consumerPropertiesTemp);
                    consumerPropertiesTemp.setInstanceIndex(index);
                    Binding<T> binding = input instanceof PollableSource ? this.doBindPollableConsumer(input, inputName, binder, consumerPropertiesTemp, target) : this.doBindConsumer(input, inputName, binder, consumerPropertiesTemp, target);
                    bindings.add(binding);
                }
            }
        }
        bindings = Collections.unmodifiableCollection(bindings);
        this.consumerBindings.put(inputName, new ArrayList(bindings));
        return bindings;
    }

    public <T> Binding<T> doBindConsumer(T input, String inputName, Binder<T, ConsumerProperties, ?> binder, ConsumerProperties consumerProperties, String target) {
        if (this.taskScheduler == null || this.bindingServiceProperties.getBindingRetryInterval() <= 0) {
            return binder.bindConsumer(target, this.bindingServiceProperties.getGroup(inputName), input, consumerProperties);
        }
        try {
            return binder.bindConsumer(target, this.bindingServiceProperties.getGroup(inputName), input, consumerProperties);
        }
        catch (RuntimeException e) {
            LateBinding late = new LateBinding(target, e.getCause() == null ? e.toString() : e.getCause().getMessage(), consumerProperties, true, this.objectMapper);
            this.rescheduleConsumerBinding(input, inputName, binder, consumerProperties, target, late, e);
            this.consumerBindings.put(inputName, Collections.singletonList(late));
            return late;
        }
    }

    public <T> void rescheduleConsumerBinding(T input, String inputName, Binder<T, ConsumerProperties, ?> binder, ConsumerProperties consumerProperties, String target, LateBinding<T> late, RuntimeException exception) {
        this.assertNotIllegalException(exception);
        this.log.error((Object)("Failed to create consumer binding; retrying in " + this.bindingServiceProperties.getBindingRetryInterval() + " seconds"), (Throwable)exception);
        this.scheduleTask(() -> {
            try {
                late.setDelegate(binder.bindConsumer(target, this.bindingServiceProperties.getGroup(inputName), input, consumerProperties));
            }
            catch (RuntimeException e) {
                this.rescheduleConsumerBinding(input, inputName, binder, consumerProperties, target, late, e);
            }
        });
    }

    public <T> Binding<T> doBindPollableConsumer(T input, String inputName, Binder<T, ConsumerProperties, ?> binder, ConsumerProperties consumerProperties, String target) {
        if (this.taskScheduler == null || this.bindingServiceProperties.getBindingRetryInterval() <= 0) {
            return ((PollableConsumerBinder)((Object)binder)).bindPollableConsumer(target, this.bindingServiceProperties.getGroup(inputName), (PollableSource)input, consumerProperties);
        }
        try {
            return ((PollableConsumerBinder)((Object)binder)).bindPollableConsumer(target, this.bindingServiceProperties.getGroup(inputName), (PollableSource)input, consumerProperties);
        }
        catch (RuntimeException e) {
            LateBinding late = new LateBinding(target, e.getCause() == null ? e.toString() : e.getCause().getMessage(), consumerProperties, true, this.objectMapper);
            this.reschedulePollableConsumerBinding(input, inputName, binder, consumerProperties, target, late, e);
            return late;
        }
    }

    public <T> void reschedulePollableConsumerBinding(T input, String inputName, Binder<T, ConsumerProperties, ?> binder, ConsumerProperties consumerProperties, String target, LateBinding<T> late, RuntimeException exception) {
        this.assertNotIllegalException(exception);
        this.log.error((Object)("Failed to create consumer binding; retrying in " + this.bindingServiceProperties.getBindingRetryInterval() + " seconds"), (Throwable)exception);
        this.scheduleTask(() -> {
            try {
                late.setDelegate(((PollableConsumerBinder)((Object)binder)).bindPollableConsumer(target, this.bindingServiceProperties.getGroup(inputName), (PollableSource)input, consumerProperties));
            }
            catch (RuntimeException e) {
                this.reschedulePollableConsumerBinding(input, inputName, binder, consumerProperties, target, late, e);
            }
        });
    }

    public <T> Binding<T> bindProducer(T output, String outputName, boolean cache, @Nullable Binder<T, ?, ProducerProperties> binder) {
        String bindingTarget = this.bindingServiceProperties.getBindingDestination(outputName);
        Class<?> outputClass = output.getClass();
        if (output instanceof Advised) {
            Advised advisedOutput = (Advised)output;
            outputClass = Stream.of(advisedOutput.getProxiedInterfaces()).filter(c -> !c.getName().contains("org.springframework")).findFirst().orElse(outputClass);
        }
        if (binder == null) {
            binder = this.getBinder(outputName, outputClass);
        }
        ExtendedProducerProperties producerProperties = this.bindingServiceProperties.getProducerProperties(outputName);
        if (binder instanceof ExtendedPropertiesBinder) {
            ExtendedPropertiesBinder extendedPropertiesBinder = (ExtendedPropertiesBinder)binder;
            Object extension = extendedPropertiesBinder.getExtendedProducerProperties(outputName);
            ExtendedProducerProperties extendedProducerProperties = new ExtendedProducerProperties(extension);
            BeanUtils.copyProperties((Object)producerProperties, extendedProducerProperties);
            producerProperties = extendedProducerProperties;
        }
        producerProperties.populateBindingName(outputName);
        this.validate(producerProperties);
        Binding<T> binding = this.doBindProducer(output, bindingTarget, binder, producerProperties);
        if (cache) {
            this.producerBindings.put(outputName, binding);
        }
        return binding;
    }

    public <T> Binding<T> bindProducer(T output, String outputName, boolean cache) {
        return this.bindProducer(output, outputName, cache, null);
    }

    public <T> Binding<T> bindProducer(T output, String outputName) {
        return this.bindProducer(output, outputName, true);
    }

    public Object getExtendedProducerProperties(Object output, String outputName) {
        Binder<?, ?, ?> binder = this.getBinder(outputName, output.getClass());
        if (binder instanceof ExtendedPropertiesBinder) {
            ExtendedPropertiesBinder extendedPropertiesBinder = (ExtendedPropertiesBinder)binder;
            return extendedPropertiesBinder.getExtendedProducerProperties(outputName);
        }
        return null;
    }

    public String[] getProducerBindingNames() {
        return this.producerBindings.keySet().toArray(new String[0]);
    }

    @Nullable
    public Binding<?> getProducerBinding(String bindingName) {
        return this.producerBindings.get(bindingName);
    }

    public String[] getConsumerBindingNames() {
        return this.consumerBindings.keySet().toArray(new String[0]);
    }

    public List<Binding<?>> getConsumerBindings(String bindingName) {
        return this.consumerBindings.getOrDefault(bindingName, Collections.emptyList());
    }

    public <T> Binding<T> doBindProducer(T output, String bindingTarget, Binder<T, ?, ProducerProperties> binder, ProducerProperties producerProperties) {
        if (this.taskScheduler == null || this.bindingServiceProperties.getBindingRetryInterval() <= 0) {
            return binder.bindProducer(bindingTarget, output, producerProperties);
        }
        try {
            return binder.bindProducer(bindingTarget, output, producerProperties);
        }
        catch (RuntimeException e) {
            LateBinding late = new LateBinding(bindingTarget, e.getCause() == null ? e.toString() : e.getCause().getMessage(), producerProperties, false, this.objectMapper);
            this.rescheduleProducerBinding(output, bindingTarget, binder, producerProperties, late, e);
            return late;
        }
    }

    public <T> void rescheduleProducerBinding(T output, String bindingTarget, Binder<T, ?, ProducerProperties> binder, ProducerProperties producerProperties, LateBinding<T> late, RuntimeException exception) {
        this.assertNotIllegalException(exception);
        this.log.error((Object)("Failed to create producer binding; retrying in " + this.bindingServiceProperties.getBindingRetryInterval() + " seconds"), (Throwable)exception);
        this.scheduleTask(() -> {
            try {
                late.setDelegate(binder.bindProducer(bindingTarget, output, producerProperties));
            }
            catch (RuntimeException e) {
                this.rescheduleProducerBinding(output, bindingTarget, binder, producerProperties, late, e);
            }
        });
    }

    public void unbindConsumers(String inputName) {
        List<Binding<?>> bindings = this.consumerBindings.remove(inputName);
        if (bindings != null && !CollectionUtils.isEmpty(bindings)) {
            for (Binding<?> binding : bindings) {
                binding.stop();
                binding.unbind();
            }
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Trying to unbind '" + inputName + "', but no binding found."));
        }
    }

    public void unbindProducers(String outputName) {
        Binding<?> binding = this.producerBindings.remove(outputName);
        if (binding != null) {
            binding.stop();
            binding.unbind();
        } else if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Trying to unbind '" + outputName + "', but no binding found."));
        }
    }

    public BindingServiceProperties getBindingServiceProperties() {
        return this.bindingServiceProperties;
    }

    protected <T> Binder<T, ?, ?> getBinder(String channelName, Class<T> bindableType) {
        String binderConfigurationName = this.bindingServiceProperties.getBinder(channelName);
        return this.binderFactory.getBinder(binderConfigurationName, bindableType);
    }

    private void validate(Object properties) {
        DataBinder dataBinder = new DataBinder(properties);
        dataBinder.validate();
        if (dataBinder.getBindingResult().hasErrors()) {
            throw new IllegalStateException(dataBinder.getBindingResult().toString());
        }
    }

    private void scheduleTask(Runnable task) {
        this.taskScheduler.schedule(task, Instant.ofEpochMilli(System.currentTimeMillis() + (long)(this.bindingServiceProperties.getBindingRetryInterval() * 1000)));
    }

    private void assertNotIllegalException(RuntimeException exception) throws RuntimeException {
        if (exception instanceof IllegalStateException || exception instanceof IllegalArgumentException) {
            throw exception;
        }
    }

    public static class LateBinding<T>
    implements Binding<T> {
        private volatile Binding<T> delegate;
        private volatile boolean unbound;
        private final String error;
        private final String bindingName;
        private final Object consumerOrProducerproperties;
        private final boolean isInput;
        final ObjectMapper objectMapper;

        LateBinding(String bindingName, String error, Object consumerOrProducerproperties, boolean isInput, ObjectMapper objectMapper) {
            this.error = error;
            this.bindingName = bindingName;
            this.consumerOrProducerproperties = consumerOrProducerproperties;
            this.isInput = isInput;
            this.objectMapper = objectMapper;
        }

        public synchronized void setDelegate(Binding<T> delegate) {
            if (this.unbound) {
                delegate.unbind();
            } else {
                this.delegate = delegate;
            }
        }

        @Override
        public synchronized void unbind() {
            this.unbound = true;
            if (this.delegate != null) {
                this.delegate.unbind();
            }
        }

        @Override
        public String getName() {
            return this.bindingName;
        }

        @Override
        public String getBindingName() {
            return this.bindingName;
        }

        public String getError() {
            return this.error;
        }

        public String toString() {
            return "LateBinding [delegate=" + this.delegate + "]";
        }

        @Override
        public Map<String, Object> getExtendedInfo() {
            LinkedHashMap<String, Object> extendedInfo = new LinkedHashMap<String, Object>();
            extendedInfo.put("bindingDestination", this.getBindingName());
            extendedInfo.put(this.consumerOrProducerproperties.getClass().getSimpleName(), this.objectMapper.convertValue(this.consumerOrProducerproperties, Map.class));
            return extendedInfo;
        }

        @Override
        public boolean isInput() {
            return this.isInput;
        }
    }
}

